/*
 * Decompiled with CFR 0.152.
 */
package fleet.docker.common.build;

import com.github.dockerjava.api.exception.DockerClientException;
import com.intellij.docker.agent.build.ContextFolderArchive;
import com.intellij.docker.agent.build.DockerFilesToTransferCollector;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.TtySink;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lfleet/docker/common/build/Dockerfile;", "", "dockerFile", "Ljava/io/File;", "baseDirectory", "(Ljava/io/File;Ljava/io/File;)V", "getBaseDirectory", "()Ljava/io/File;", "getDockerFile", "filesToTransfer", "", "getFilesToTransfer", "()Ljava/util/Set;", "filesToTransfer$delegate", "Lkotlin/Lazy;", "buildContextFolderArchive", "Lcom/intellij/docker/agent/build/ContextFolderArchive;", "tty", "Lcom/intellij/docker/agent/progress/TtySink;", "fleet.plugins.docker.common"})
public final class Dockerfile {
    @NotNull
    private final File dockerFile;
    @NotNull
    private final File baseDirectory;
    @NotNull
    private final Lazy filesToTransfer$delegate;

    public Dockerfile(@NotNull File dockerFile, @NotNull File baseDirectory) {
        Intrinsics.checkNotNullParameter((Object)dockerFile, (String)"dockerFile");
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        this.dockerFile = dockerFile;
        this.baseDirectory = baseDirectory;
        this.filesToTransfer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends File>>(this){
            final /* synthetic */ Dockerfile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<File> invoke() {
                if (this.this$0.getBaseDirectory().listFiles() == null) {
                    throw new DockerClientException("Failed to read build context directory: " + this.this$0.getBaseDirectory().getAbsolutePath());
                }
                return new DockerFilesToTransferCollector(this.this$0.getBaseDirectory(), this.this$0.getDockerFile()).collectFiles();
            }
        }));
    }

    @NotNull
    public final File getDockerFile() {
        return this.dockerFile;
    }

    @NotNull
    public final File getBaseDirectory() {
        return this.baseDirectory;
    }

    private final Set<File> getFilesToTransfer() {
        Lazy lazy = this.filesToTransfer$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final ContextFolderArchive buildContextFolderArchive(@NotNull TtySink tty) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tty, (String)"tty");
        DockerProgressDetailsFormat ttyFormat = new DockerProgressDetailsFormat("files");
        int total = this.getFilesToTransfer().size();
        tty.ttyPrintln("Preparing build context archive\u2026");
        tty.ttyPrintln(ttyFormat.toTtyString(0, total));
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String archiveNameWithOutExtension = string;
        ContextFolderArchive archive = new ContextFolderArchive(this.baseDirectory, archiveNameWithOutExtension);
        archive.createArchiveWith((Function1)new Function1<TarArchiveOutputStream, Unit>(total, this, tty, ttyFormat, archive){
            final /* synthetic */ int $total;
            final /* synthetic */ Dockerfile this$0;
            final /* synthetic */ TtySink $tty;
            final /* synthetic */ DockerProgressDetailsFormat $ttyFormat;
            final /* synthetic */ ContextFolderArchive $archive;
            {
                this.$total = $total;
                this.this$0 = $receiver;
                this.$tty = $tty;
                this.$ttyFormat = $ttyFormat;
                this.$archive = $archive;
                super(1);
            }

            public final void invoke(@NotNull TarArchiveOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int batch = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)(this.$total / 10), (int)1), (int)25);
                Iterator<E> iterator = Dockerfile.access$getFilesToTransfer(this.this$0).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int idx = n++;
                    File nextFile = (File)iterator.next();
                    if (idx % batch == 0) {
                        this.$tty.ttyCursorUp(1);
                        this.$tty.ttyClearLine();
                        this.$tty.ttyPrintln(this.$ttyFormat.toTtyString(idx, this.$total));
                    }
                    this.$archive.addFileToTar(it, nextFile);
                }
            }
        });
        tty.ttyCursorUp(1);
        tty.ttyClearLine();
        tty.ttyPrintln(ttyFormat.toTtyString(total, total));
        tty.ttyPrintln("Done");
        tty.ttyPrintln("");
        return archive;
    }

    public static final /* synthetic */ Set access$getFilesToTransfer(Dockerfile $this) {
        return $this.getFilesToTransfer();
    }
}

