/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.settings;

import com.jetbrains.fus.reporting.schema.EventField;
import com.jetbrains.fus.reporting.schema.EventFields;
import fleet.frontend.fus.SettingsReporter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lfleet/frontend/settings/VersionReporter;", "Lfleet/frontend/fus/SettingsReporter;", "()V", "REGEX", "", "UNKNOWN", "createValueField", "Lcom/jetbrains/fus/reporting/schema/EventField;", "name", "description", "isAllowedToReport", "", "value", "reportValue", "", "fleet.frontend"})
public final class VersionReporter
implements SettingsReporter {
    @NotNull
    public static final VersionReporter INSTANCE = new VersionReporter();
    @NotNull
    private static final String REGEX = "(\\d+\\.?)*\\d+";
    @NotNull
    private static final String UNKNOWN = "unknown";

    private VersionReporter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAllowedToReport(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)UNKNOWN)) return true;
        MatchResult matchResult = Regex.find$default((Regex)new Regex(REGEX), (CharSequence)value, (int)0, (int)2, null);
        if (matchResult == null) return false;
        String string = matchResult.getValue();
        if (string == null) return false;
        return true;
    }

    @Override
    @NotNull
    public String reportValue(@NotNull Object value) {
        String adjustedVersion;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String versionString = value instanceof String ? (String)value : null;
        if (versionString == null) {
            return UNKNOWN;
        }
        MatchResult matchResult = Regex.find$default((Regex)new Regex(REGEX), (CharSequence)versionString, (int)0, (int)2, null);
        String string = adjustedVersion = matchResult != null ? matchResult.getValue() : null;
        if (string == null) {
            return UNKNOWN;
        }
        return string;
    }

    @Override
    @NotNull
    public EventField<?> createValueField(@NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return (EventField)EventFields.StringValidatedByRegexp((String)name, (String)"version", (String)description);
    }
}

