/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.settings;

import com.jetbrains.fus.reporting.schema.EventField;
import fleet.frontend.fus.SettingsReporter;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lfleet/frontend/settings/AllowedFloatReporter;", "Lfleet/frontend/fus/SettingsReporter;", "()V", "isAllowedToReport", "", "value", "", "reportValue", "", "fleet.frontend"})
public final class AllowedFloatReporter
implements SettingsReporter {
    @NotNull
    public static final AllowedFloatReporter INSTANCE = new AllowedFloatReporter();

    private AllowedFloatReporter() {
    }

    @Override
    public boolean isAllowedToReport(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String reportValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return String.valueOf(value instanceof Float ? (Float)value : null);
    }

    @Override
    @Deprecated(message="Left for compatibility, will be removed in ~1.35. New reporters must return null, old reporters must return not-null")
    @Nullable
    public EventField<?> createValueField(@NotNull String name, @NotNull String description) {
        return SettingsReporter.DefaultImpls.createValueField(this, name, description);
    }
}

