/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.notifications;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lfleet/frontend/notifications/NotificationTime;", "", "epochTime", "", "(J)V", "getEpochTime", "()J", "component1", "copy", "equals", "", "other", "getDate", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "getTime", "Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "hashCode", "", "localDateTime", "Ljava/time/LocalDateTime;", "toString", "", "RenderedDate", "RenderedTime", "fleet.frontend"})
public final class NotificationTime {
    private final long epochTime;

    public NotificationTime(long epochTime) {
        this.epochTime = epochTime;
    }

    public final long getEpochTime() {
        return this.epochTime;
    }

    @NotNull
    public final RenderedDate getDate() {
        RenderedDate renderedDate;
        LocalDateTime timeNow = LocalDateTime.now();
        LocalDateTime msgTime = this.localDateTime();
        if (Intrinsics.areEqual((Object)msgTime.toLocalDate(), (Object)timeNow.toLocalDate())) {
            renderedDate = RenderedDate.Today.INSTANCE;
        } else if (Intrinsics.areEqual((Object)msgTime.toLocalDate(), (Object)timeNow.toLocalDate().minusDays(1L))) {
            renderedDate = RenderedDate.Yesterday.INSTANCE;
        } else {
            String string = msgTime.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            renderedDate = new RenderedDate.JustDate(string);
        }
        return renderedDate;
    }

    @NotNull
    public final RenderedTime getTime() {
        Instant msgInstant = Instant.ofEpochMilli(this.epochTime);
        ZoneOffset offset = ZoneId.systemDefault().getRules().getOffset(msgInstant);
        LocalDateTime dt = LocalDateTime.ofInstant(msgInstant, offset);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        String string = dt.format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return new RenderedTime.JustTime(string);
    }

    private final LocalDateTime localDateTime() {
        Instant msgInstant = Instant.ofEpochMilli(this.epochTime);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(msgInstant, ZoneId.systemDefault().getRules().getOffset(msgInstant));
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    public final long component1() {
        return this.epochTime;
    }

    @NotNull
    public final NotificationTime copy(long epochTime) {
        return new NotificationTime(epochTime);
    }

    public static /* synthetic */ NotificationTime copy$default(NotificationTime notificationTime, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = notificationTime.epochTime;
        }
        return notificationTime.copy(l);
    }

    @NotNull
    public String toString() {
        return "NotificationTime(epochTime=" + this.epochTime + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.epochTime);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationTime)) {
            return false;
        }
        NotificationTime notificationTime = (NotificationTime)other;
        return this.epochTime == notificationTime.epochTime;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u0082\u0001\u0003\b\t\n\u00a8\u0006\u000b"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "", "()V", "getCaption", "", "JustDate", "Today", "Yesterday", "Lfleet/frontend/notifications/NotificationTime$RenderedDate$JustDate;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate$Today;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate$Yesterday;", "fleet.frontend"})
    public static abstract class RenderedDate {
        private RenderedDate() {
        }

        @NotNull
        public abstract String getCaption();

        public /* synthetic */ RenderedDate(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\b\u0010\r\u001a\u00020\u0003H\u0016J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate$JustDate;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "date", "", "(Ljava/lang/String;)V", "getDate", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "getCaption", "hashCode", "", "toString", "fleet.frontend"})
        public static final class JustDate
        extends RenderedDate {
            @NotNull
            private final String date;

            public JustDate(@NotNull String date) {
                Intrinsics.checkNotNullParameter((Object)date, (String)"date");
                super(null);
                this.date = date;
            }

            @NotNull
            public final String getDate() {
                return this.date;
            }

            @Override
            @NotNull
            public String getCaption() {
                return this.date;
            }

            @NotNull
            public final String component1() {
                return this.date;
            }

            @NotNull
            public final JustDate copy(@NotNull String date) {
                Intrinsics.checkNotNullParameter((Object)date, (String)"date");
                return new JustDate(date);
            }

            public static /* synthetic */ JustDate copy$default(JustDate justDate, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = justDate.date;
                }
                return justDate.copy(string);
            }

            @NotNull
            public String toString() {
                return "JustDate(date=" + this.date + ")";
            }

            public int hashCode() {
                return this.date.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JustDate)) {
                    return false;
                }
                JustDate justDate = (JustDate)other;
                return Intrinsics.areEqual((Object)this.date, (Object)justDate.date);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate$Today;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "()V", "getCaption", "", "fleet.frontend"})
        public static final class Today
        extends RenderedDate {
            @NotNull
            public static final Today INSTANCE = new Today();

            private Today() {
                super(null);
            }

            @Override
            @NotNull
            public String getCaption() {
                return "Today";
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate$Yesterday;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "()V", "getCaption", "", "fleet.frontend"})
        public static final class Yesterday
        extends RenderedDate {
            @NotNull
            public static final Yesterday INSTANCE = new Yesterday();

            private Yesterday() {
                super(null);
            }

            @Override
            @NotNull
            public String getCaption() {
                return "Yesterday";
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "", "()V", "getCaption", "", "Ago", "JustTime", "Lfleet/frontend/notifications/NotificationTime$RenderedTime$Ago;", "Lfleet/frontend/notifications/NotificationTime$RenderedTime$JustTime;", "fleet.frontend"})
    public static abstract class RenderedTime {
        private RenderedTime() {
        }

        @NotNull
        public abstract String getCaption();

        public /* synthetic */ RenderedTime(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedTime$Ago;", "Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "count", "", "name", "", "(ILjava/lang/String;)V", "getCount", "()I", "getName", "()Ljava/lang/String;", "getCaption", "fleet.frontend"})
        public static final class Ago
        extends RenderedTime {
            private final int count;
            @NotNull
            private final String name;

            public Ago(int count, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(null);
                this.count = count;
                this.name = name;
            }

            public final int getCount() {
                return this.count;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            @NotNull
            public String getCaption() {
                return "" + this.count + this.name.charAt(0);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedTime$JustTime;", "Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "time", "", "(Ljava/lang/String;)V", "getTime", "()Ljava/lang/String;", "getCaption", "fleet.frontend"})
        public static final class JustTime
        extends RenderedTime {
            @NotNull
            private final String time;

            public JustTime(@NotNull String time) {
                Intrinsics.checkNotNullParameter((Object)time, (String)"time");
                super(null);
                this.time = time;
            }

            @NotNull
            public final String getTime() {
                return this.time;
            }

            @Override
            @NotNull
            public String getCaption() {
                return this.time;
            }
        }
    }
}

