/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.fus;

import androidx.compose.ui.unit.DpOffset;
import com.jetbrains.fus.reporting.schema.EventField;
import fleet.api.WorkspaceId;
import fleet.compose.theme.Analytics;
import fleet.dock.connectors.fus.FieldValue;
import fleet.dock.connectors.fus.FusEventsKt;
import fleet.frontend.actions.ActionsReportsKt;
import fleet.frontend.fus.WorkspaceUIReports;
import fleet.reporting.fus.api.FusApi;
import fleet.reporting.fus.api.FusEventLogger;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import noria.model.ActionContext;
import noria.model.ActionId;
import noria.model.CommonTrigger;
import noria.model.Trigger;
import noria.windowManagement.api.MouseButton;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\f\u0010\u001e\u001a\u00020\u0017*\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"Lfleet/frontend/fus/FleetWorkspaceAnalytics;", "Lfleet/compose/theme/Analytics;", "fusApi", "Lfleet/reporting/fus/api/FusApi;", "workspaceId", "Lfleet/api/WorkspaceId;", "(Lfleet/reporting/fus/api/FusApi;Lfleet/api/WorkspaceId;)V", "getFusApi", "()Lfleet/reporting/fus/api/FusApi;", "getWorkspaceId", "()Lfleet/api/WorkspaceId;", "ident", "", "Lnoria/model/Trigger;", "getIdent", "(Lnoria/model/Trigger;)Ljava/lang/String;", "logClick", "", "metadata", "Lfleet/compose/theme/Analytics$Metadata;", "button", "Lnoria/windowManagement/api/MouseButton;", "clickCount", "", "position", "Landroidx/compose/ui/unit/DpOffset;", "actionContext", "Lnoria/model/ActionContext;", "logClick-rxAGgVk", "(Lfleet/compose/theme/Analytics$Metadata;Lnoria/windowManagement/api/MouseButton;IJLnoria/model/ActionContext;)V", "getButtonNumber", "fleet.frontend"})
public final class FleetWorkspaceAnalytics
implements Analytics {
    @NotNull
    private final FusApi fusApi;
    @NotNull
    private final WorkspaceId workspaceId;

    public FleetWorkspaceAnalytics(@NotNull FusApi fusApi, @NotNull WorkspaceId workspaceId) {
        Intrinsics.checkNotNullParameter((Object)fusApi, (String)"fusApi");
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        this.fusApi = fusApi;
        this.workspaceId = workspaceId;
    }

    @NotNull
    public final FusApi getFusApi() {
        return this.fusApi;
    }

    @NotNull
    public final WorkspaceId getWorkspaceId() {
        return this.workspaceId;
    }

    public void logClick-rxAGgVk(@NotNull Analytics.Metadata metadata, @NotNull MouseButton button, int clickCount, long position, @NotNull ActionContext actionContext2) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        FieldValue[] fieldValueArray = new FieldValue[7];
        fieldValueArray[0] = new FieldValue((EventField)WorkspaceUIReports.INSTANCE.getComponentTypeField(), (Object)metadata.getComponentType().toString());
        fieldValueArray[1] = new FieldValue((EventField)WorkspaceUIReports.INSTANCE.getActionOwnerField(), (Object)ActionsReportsKt.reportedOwner(actionContext2));
        Trigger trigger = metadata.getRelatedTrigger();
        fieldValueArray[2] = new FieldValue((EventField)WorkspaceUIReports.INSTANCE.getRelatedTriggerField(), (Object)(trigger != null ? this.getIdent(trigger) : null));
        fieldValueArray[3] = new FieldValue((EventField)WorkspaceUIReports.INSTANCE.getButtonField(), (Object)this.getButtonNumber(button));
        fieldValueArray[4] = new FieldValue((EventField)WorkspaceUIReports.INSTANCE.getClickCountField(), (Object)clickCount);
        fieldValueArray[5] = new FieldValue((EventField)WorkspaceUIReports.INSTANCE.getPositionXField(), (Object)Float.valueOf(DpOffset.getX-D9Ej5fM((long)position)));
        fieldValueArray[6] = new FieldValue((EventField)WorkspaceUIReports.INSTANCE.getPositionYField(), (Object)Float.valueOf(DpOffset.getY-D9Ej5fM((long)position)));
        FusEventsKt.logVararg(WorkspaceUIReports.INSTANCE.getClickedEvent(), (FusEventLogger)this.fusApi.getEventLogger(), (UID)this.workspaceId.getUid(), (FieldValue[])fieldValueArray);
    }

    private final String getIdent(Trigger $this$ident) {
        String string;
        Trigger trigger = $this$ident;
        if (trigger instanceof CommonTrigger) {
            string = ((CommonTrigger)$this$ident).getId();
        } else if (trigger instanceof ActionId) {
            string = ((ActionId)$this$ident).getId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final int getButtonNumber(MouseButton $this$getButtonNumber) {
        int n;
        MouseButton mouseButton = $this$getButtonNumber;
        if (Intrinsics.areEqual((Object)mouseButton, (Object)MouseButton.Left.INSTANCE)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)mouseButton, (Object)MouseButton.Right.INSTANCE)) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)mouseButton, (Object)MouseButton.Middle.INSTANCE)) {
            n = 3;
        } else if (mouseButton instanceof MouseButton.Other) {
            n = ((MouseButton.Other)$this$getButtonNumber).getCode();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }
}

