/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.actions;

import com.jetbrains.fus.reporting.schema.EventField;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DB;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.DbContextKt;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.LegacyEntity;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.common.FleetCommonSettingsKeysKt;
import fleet.common.WorkspaceEntity;
import fleet.common.WorkspaceEntityKt;
import fleet.common.document.DocumentEntity;
import fleet.common.document.EditorEntity;
import fleet.common.fus.ReportingApiKt;
import fleet.common.fus.validation.CustomValidationKt;
import fleet.compose.foundation.input.InputEvent;
import fleet.dock.connectors.fus.FieldValue;
import fleet.dock.connectors.fus.FusApiKind;
import fleet.dock.connectors.fus.FusEventsKt;
import fleet.dock.connectors.fus.ValidationRule;
import fleet.frontend.actions.ActionEntity;
import fleet.frontend.actions.ActionIdValidator;
import fleet.frontend.actions.ActionOwnerValidator;
import fleet.frontend.actions.ActionOwnersProviderEntity;
import fleet.frontend.actions.ActionTriggerValidator;
import fleet.frontend.actions.ActionsReports;
import fleet.frontend.actions.ActionsReportsKt;
import fleet.frontend.actions.FleetActionsKt;
import fleet.frontend.actions.FleetDataKeysKt;
import fleet.frontend.actions.RememberedState;
import fleet.frontend.actions.ReportedActionsEntity;
import fleet.frontend.fus.ReportUtil;
import fleet.frontend.layout.ActionOwnerEntity;
import fleet.frontend.navigation.ViewEntity;
import fleet.kernel.plugins.ContributionScope;
import fleet.reporting.fus.api.FusApi;
import fleet.reporting.fus.api.FusEventLogger;
import fleet.util.AtomicRef;
import fleet.util.AtomicRefKt;
import fleet.util.UID;
import fleet.util.logging.BaseLogger;
import fleet.util.logging.KLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import noria.model.ActionContext;
import noria.model.ActionId;
import noria.model.ActionOwnerData;
import noria.model.ActionTag;
import noria.model.CommonDataKeys;
import noria.model.CommonTrigger;
import noria.model.FocusDataKey;
import noria.model.Trigger;
import noria.ui.core.Initiator;
import noria.ui.events.Chord;
import noria.ui.events.Input;
import noria.ui.events.InputKt;
import noria.windowManagement.api.Key;
import noria.windowManagement.api.ModifierKey;
import noria.windowManagement.api.MouseButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a8\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0000\u001a\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0019H\u0000\u001a\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001\u001a\u000e\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'\u001a\u0010\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010(\u001a\u00020\u0012\u001a\u0010\u0010%\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010,\u001a\u00020-H\u0002\u001a\u0012\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0002\u001a\u001e\u00102\u001a\u00020 *\u0002032\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001d05\u001a\f\u00106\u001a\u00020 *\u000203H\u0000\u001a\u001e\u0010$\u001a\u00020 *\u0002032\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001d05\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00068"}, d2={"SKIP_TRIGGERS", "", "Lnoria/model/Trigger;", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "reported", "Lfleet/util/AtomicRef;", "", "ident", "", "getIdent", "(Lnoria/model/Trigger;)Ljava/lang/String;", "getContextLanguageId", "actionContext", "Lnoria/model/ActionContext;", "isSafeToReportAction", "", "data", "Lnoria/model/ActionId;", "rememberState", "Lkotlin/Lazy;", "Lfleet/frontend/actions/RememberedState;", "identifier", "trigger", "tags", "", "Lnoria/model/ActionTag;", "reportInvocationToFus", "", "fus", "Lfleet/reporting/fus/api/FusApi;", "remembered", "reportedActions", "reportedOwner", "owner", "Lfleet/frontend/layout/ActionOwnerEntity;", "context", "ownerData", "Lnoria/model/ActionOwnerData;", "toFusChord", "chord", "Lnoria/ui/events/Chord;", "toInvocationMethod", "Lfleet/frontend/actions/ActionsReports$ActionInvocationMethod;", "initiator", "Lnoria/ui/core/Initiator;", "actionOwners", "Lfleet/kernel/plugins/ContributionScope;", "ownersProvider", "Lkotlin/Function0;", "registerActionsEvents", "actionsIdsProvider", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nActionsReports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionsReportsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 KLogger.kt\nfleet/util/logging/KLogger\n+ 6 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n+ 7 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n*L\n1#1,387:1\n1446#2,5:388\n1864#2,2:398\n1549#2:400\n1620#2,3:401\n1866#2:404\n1#3:393\n37#4,2:394\n17#5,2:396\n287#6,2:405\n49#7,10:407\n*S KotlinDebug\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionsReportsKt\n*L\n53#1:388,5\n278#1:398,2\n282#1:400\n282#1:401,3\n278#1:404\n254#1:394,2\n262#1:396,2\n317#1:405,2\n317#1:407,10\n*E\n"})
public final class ActionsReportsKt {
    @NotNull
    private static final Set<Trigger> SKIP_TRIGGERS = SetsKt.setOf((Object)CommonTrigger.KeyboardModifiersPressed);
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    @NotNull
    private static final AtomicRef<Integer> reported = AtomicRefKt.AtomicRef((Object)4);

    public static final void actionOwners(@NotNull ContributionScope $this$actionOwners, @NotNull Function0<? extends List<String>> ownersProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$actionOwners, (String)"<this>");
        Intrinsics.checkNotNullParameter(ownersProvider, (String)"ownersProvider");
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$actionOwners), (KClass)Reflection.getOrCreateKotlinClass(ActionOwnersProviderEntity.class), (int)0, (Function1)((Function1)new Function1<ActionOwnersProviderEntity, Unit>(ownersProvider){
            final /* synthetic */ Function0<List<String>> $ownersProvider;
            {
                this.$ownersProvider = $ownersProvider;
                super(1);
            }

            public final void invoke(@NotNull ActionOwnersProviderEntity $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setOwnersProvider(this.$ownersProvider);
            }
        }), (int)2, null);
    }

    public static final void reportedActions(@NotNull ContributionScope $this$reportedActions, @NotNull Function0<? extends List<ActionId>> actionsIdsProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$reportedActions, (String)"<this>");
        Intrinsics.checkNotNullParameter(actionsIdsProvider, (String)"actionsIdsProvider");
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$reportedActions), (KClass)Reflection.getOrCreateKotlinClass(ReportedActionsEntity.class), (int)0, (Function1)((Function1)new Function1<ReportedActionsEntity, Unit>(actionsIdsProvider){
            final /* synthetic */ Function0<List<ActionId>> $actionsIdsProvider;
            {
                this.$actionsIdsProvider = $actionsIdsProvider;
                super(1);
            }

            public final void invoke(@NotNull ReportedActionsEntity $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setActionsIds((List)this.$actionsIdsProvider.invoke());
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ActionId> reportedActions() {
        void var1_1;
        void $this$flatMapTo$iv;
        Iterable iterable = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(ReportedActionsEntity.class));
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            ReportedActionsEntity it = (ReportedActionsEntity)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getActionsIds();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var1_1;
    }

    @Nullable
    public static final String reportedOwner(@NotNull ActionContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionOwnerData actionOwnerData = (ActionOwnerData)context.get((FocusDataKey)CommonDataKeys.INSTANCE.getActionOwnerData());
        if (actionOwnerData != null) {
            ActionOwnerData it = actionOwnerData;
            boolean bl = false;
            string = ActionsReportsKt.reportedOwner(it);
        } else {
            string = null;
        }
        return string;
    }

    private static final String reportedOwner(ActionOwnerData ownerData) {
        ActionOwnerData actionOwnerData = ownerData;
        if (actionOwnerData instanceof ActionOwnerData.ActionOwnerName) {
            if (ActionOwnerValidator.INSTANCE.isSafeToReport(((ActionOwnerData.ActionOwnerName)ownerData).getName())) {
                return ((ActionOwnerData.ActionOwnerName)ownerData).getName();
            }
            if (((ActionOwnerData.ActionOwnerName)ownerData).isAllowedToReport() && FleetCommonSettingsKeysKt.isInternalMode()) {
                BaseLogger.error$default((BaseLogger)((BaseLogger)ActionsReportsKt.getLogger()), (Throwable)new Throwable("Action owner '" + ownerData + "' was reported as string, but not registered. This is internal-mode-only error, please report it"), null, (int)2, null);
            }
            return "3rd party";
        }
        if (actionOwnerData instanceof ActionOwnerData.ActionOwner) {
            Object owner = ((ActionOwnerData.ActionOwner)ownerData).getOwner();
            if (owner instanceof ActionOwnerEntity) {
                return ActionsReportsKt.reportedOwner((ActionOwnerEntity)owner);
            }
            BaseLogger.error$default((BaseLogger)((BaseLogger)ActionsReportsKt.getLogger()), (Throwable)new Throwable("Action owner must be an ActionOwnerEntity: '" + ownerData + "'"), null, (int)2, null);
            return "3rd party";
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final String reportedOwner(@NotNull ActionOwnerEntity owner) {
        String ownerName;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner instanceof ViewEntity) {
            v0 = ((ViewEntity)owner).getViewType().getId().getId();
        } else {
            v0 = EntitiesKt.getEntityClass((Entity)((Entity)owner)).getSimpleName();
            if (v0 == null) {
                v0 = ownerName = "";
            }
        }
        if (ActionOwnerValidator.INSTANCE.isSafeToReport(ownerName)) {
            return ownerName;
        }
        if (FleetCommonSettingsKeysKt.isInternalMode()) {
            String string = EntitiesKt.getEntityClass((Entity)((Entity)owner)).getQualifiedName();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"fleet", (boolean)false, (int)2, null) : false;
            if (bl && ((Number)reported.getAndUpdate((Function1)reportedOwner.2.INSTANCE)).intValue() > 0) {
                BaseLogger.error$default((BaseLogger)((BaseLogger)ActionsReportsKt.getLogger()), (Throwable)new Throwable("Action owner '" + ownerName + "' was reported, but not registered. This is internal-mode-only error, please report it"), null, (int)2, null);
            }
        }
        return "3rd party";
    }

    @Nullable
    public static final Lazy<RememberedState> rememberState(@NotNull ActionId identifier, @Nullable Trigger trigger, @NotNull ActionContext actionContext2, @NotNull List<ActionTag> tags) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        InputEvent.KeymapChord invocationEvent = (InputEvent.KeymapChord)actionContext2.get((FocusDataKey)CommonDataKeys.INSTANCE.getInvocationEvent());
        Q q = DbContext.Companion.getThreadBound().getImpl().getOriginal();
        DB dB = q instanceof DB ? (DB)q : null;
        if (dB == null) {
            throw new IllegalStateException("trying to invoke an action from the transaction?");
        }
        DB db = dB;
        return LazyKt.lazy((Function0)((Function0)new Function0<RememberedState>(db, startTime, identifier, trigger, actionContext2, tags, invocationEvent){
            final /* synthetic */ DB $db;
            final /* synthetic */ long $startTime;
            final /* synthetic */ ActionId $identifier;
            final /* synthetic */ Trigger $trigger;
            final /* synthetic */ ActionContext $actionContext;
            final /* synthetic */ List<ActionTag> $tags;
            final /* synthetic */ InputEvent.KeymapChord $invocationEvent;
            {
                this.$db = $db;
                this.$startTime = $startTime;
                this.$identifier = $identifier;
                this.$trigger = $trigger;
                this.$actionContext = $actionContext;
                this.$tags = $tags;
                this.$invocationEvent = $invocationEvent;
                super(0);
            }

            @NotNull
            public final RememberedState invoke() {
                return (RememberedState)DbContextKt.asOf((Q)((Q)this.$db), (Function1)((Function1)new Function1<DbContext<? extends DB>, RememberedState>(this.$startTime, this.$identifier, this.$trigger, this.$actionContext, this.$tags, this.$invocationEvent){
                    final /* synthetic */ long $startTime;
                    final /* synthetic */ ActionId $identifier;
                    final /* synthetic */ Trigger $trigger;
                    final /* synthetic */ ActionContext $actionContext;
                    final /* synthetic */ List<ActionTag> $tags;
                    final /* synthetic */ InputEvent.KeymapChord $invocationEvent;
                    {
                        this.$startTime = $startTime;
                        this.$identifier = $identifier;
                        this.$trigger = $trigger;
                        this.$actionContext = $actionContext;
                        this.$tags = $tags;
                        this.$invocationEvent = $invocationEvent;
                        super(1);
                    }

                    @NotNull
                    public final RememberedState invoke(@NotNull DbContext<DB> $this$asOf) {
                        Intrinsics.checkNotNullParameter($this$asOf, (String)"$this$asOf");
                        InputEvent.KeymapChord keymapChord = this.$invocationEvent;
                        WorkspaceEntity workspaceEntity = WorkspaceEntityKt.currentWorkspace();
                        return new RememberedState(this.$startTime, workspaceEntity != null && (workspaceEntity = WorkspaceEntityKt.getWorkspaceId((WorkspaceEntity)workspaceEntity)) != null ? workspaceEntity.getUid() : null, this.$identifier, this.$trigger, ActionsReportsKt.access$getContextLanguageId(this.$actionContext), !this.$tags.contains(FleetActionsKt.getTOGGLE_ACTION_TAG()) ? null : (this.$tags.contains(FleetActionsKt.getTOGGLE_ENABLE_TAG()) ? "enable" : "disable"), ActionsReportsKt.access$toInvocationMethod((Initiator)this.$actionContext.get((FocusDataKey)CommonDataKeys.INSTANCE.getInitiator())).getId(), (Chord)(keymapChord != null ? keymapChord.getChord() : null), ActionsReportsKt.reportedOwner(this.$actionContext), this.$tags, null);
                    }
                }));
            }
        }));
    }

    private static final String getIdent(Trigger $this$ident) {
        String string;
        Trigger trigger = $this$ident;
        if (trigger instanceof CommonTrigger) {
            string = ((CommonTrigger)$this$ident).getId();
        } else if (trigger instanceof ActionId) {
            string = ((ActionId)$this$ident).getId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final void reportInvocationToFus(@NotNull FusApi fus, @NotNull RememberedState remembered) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)fus, (String)"fus");
        Intrinsics.checkNotNullParameter((Object)remembered, (String)"remembered");
        if (CollectionsKt.contains((Iterable)SKIP_TRIGGERS, (Object)remembered.getTrigger())) {
            return;
        }
        if (!ActionsReportsKt.isSafeToReportAction(remembered.getIdentifier())) {
            return;
        }
        long duration = Duration.getInWholeMilliseconds-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)remembered.getStartTime-z9LOYto()));
        List fields = new ArrayList();
        fields.add(new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getIdentifierField$fleet_frontend(), (Object)remembered.getIdentifier().getId()));
        Trigger trigger = remembered.getTrigger();
        if (trigger != null) {
            it = trigger;
            boolean bl = false;
            fields.add(new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getTriggerField$fleet_frontend(), (Object)ActionsReportsKt.getIdent(it)));
        }
        String string = remembered.getContextLanguageId();
        if (string != null) {
            it = string;
            boolean bl = false;
            fields.add(new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getLanguageIdField(), it));
        }
        String string2 = remembered.getToggleState();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            fields.add(new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getToggleStateField$fleet_frontend(), it));
        }
        fields.add(new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getInvocationMethodField$fleet_frontend(), (Object)remembered.getInvocationMethod()));
        Chord chord = remembered.getChord();
        if (chord != null) {
            it = chord;
            boolean bl = false;
            fields.add(new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getShortcutField$fleet_frontend(), ActionsReportsKt.toFusChord((Chord)it)));
        }
        String string3 = remembered.getOwner();
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            fields.add(new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getOwnerField$fleet_frontend(), it));
        }
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)fields, (Object)new FieldValue((EventField)ActionsReports.FieldsDescriptor.INSTANCE.getDurationField(), (Object)duration));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FieldValue[] fieldValueArray = thisCollection$iv.toArray(new FieldValue[0]);
        FusEventsKt.logVararg(ActionsReports.INSTANCE.getInvokedEvent$fleet_frontend(), (FusEventLogger)fus.getEventLogger(), (UID)remembered.getWorkspaceId(), (FieldValue[])Arrays.copyOf(fieldValueArray, fieldValueArray.length));
    }

    private static final ActionsReports.ActionInvocationMethod toInvocationMethod(Initiator initiator) {
        Initiator initiator2 = initiator;
        return switch (initiator2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[initiator2.ordinal()]) {
            case 1 -> ActionsReports.ActionInvocationMethod.Keyboard;
            case 2 -> ActionsReports.ActionInvocationMethod.Mouse;
            case 3 -> {
                ActionsReports.ActionInvocationMethod var1_1;
                ActionsReports.ActionInvocationMethod it = var1_1 = ActionsReports.ActionInvocationMethod.Reactivity;
                boolean $i$a$-also-ActionsReportsKt$toInvocationMethod$1 = false;
                KLogger this_$iv = ActionsReportsKt.getLogger();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    KLogger var6_6 = this_$iv;
                    boolean $i$a$-warn-ActionsReportsKt$toInvocationMethod$1$1 = false;
                    var6_6.warn((Object)"Reactivity-invoked action is logged");
                }
                yield var1_1;
            }
            case 4 -> ActionsReports.ActionInvocationMethod.Accessibility;
            case 5 -> ActionsReports.ActionInvocationMethod.AppMenu;
            case -1 -> ActionsReports.ActionInvocationMethod.Unknown;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String getContextLanguageId(ActionContext actionContext2) {
        EditorEntity editorEntity = FleetDataKeysKt.getEditorEntity(actionContext2);
        Object document2 = editorEntity != null ? editorEntity.getDocument() : null;
        if (document2 == null) {
            return null;
        }
        return ReportUtil.Companion.getLanguageId((DocumentEntity)document2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> toFusChord(Chord chord) {
        List result2 = new ArrayList();
        Iterable $this$forEachIndexed$iv = chord.getInputs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void input;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Input input2 = (Input)item$iv;
            int index = n;
            boolean bl = false;
            if (index != 0) {
                result2.add(",");
            }
            Iterable iterable = input.getModifiers().getModifierKeys();
            List list = result2;
            boolean $i$f$map = false;
            void var14_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = ((ModifierKey)item$iv$iv).unbox-impl();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it);
            }
            list.addAll((List)destination$iv$iv);
            iterable = input;
            if (iterable instanceof Input.Keystroke) {
                if (((Input.Keystroke)input).getKey() != null) {
                    Key it;
                    boolean bl3 = false;
                    result2.add(it.getIdentifier());
                }
                continue;
            }
            if (!(iterable instanceof Input.MouseClick)) continue;
            String shortName = InputKt.getShortName((MouseButton)((Input.MouseClick)input).getMouseButton());
            result2.add(ActionsReports.FieldsDescriptor.INSTANCE.getACTION_MOUSE_BUTTONS$fleet_frontend().contains(shortName) ? shortName : "mouseX");
        }
        return result2;
    }

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSafeToReportAction(ActionId data) {
        if (ActionsReportsKt.reportedActions().contains(data)) return true;
        KMutableProperty1 prop$iv = (KMutableProperty1)isSafeToReportAction.1.INSTANCE;
        boolean $i$f$lookupOne = false;
        Iterable $this$singleOrNullOrThrowWithMessage$iv$iv = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)prop$iv), (Object)data, (KClass)Reflection.getOrCreateKotlinClass(ActionEntity.class));
        boolean $i$f$singleOrNullOrThrowWithMessage = false;
        Object single$iv$iv = null;
        boolean found$iv$iv = false;
        for (Object element$iv$iv : $this$singleOrNullOrThrowWithMessage$iv$iv) {
            if (found$iv$iv) {
                Object t = element$iv$iv;
                Object var10_10 = single$iv$iv;
                boolean bl = false;
                String string = " searched prop " + prop$iv + " and value " + data;
                String string2 = "Collection contains more than one matching element: " + var10_10 + ", " + t + " " + string;
                throw new IllegalArgumentException(string2);
            }
            single$iv$iv = element$iv$iv;
            found$iv$iv = true;
        }
        ActionEntity actionEntity = (ActionEntity)((LegacyEntity)single$iv$iv);
        if (actionEntity == null) return false;
        ActionEntity actionEntity2 = actionEntity;
        boolean bl = false;
        boolean bl2 = CustomValidationKt.isFromAllowedPlugin((ValidationRule.Companion)ValidationRule.Companion, (Entity)((Entity)actionEntity2));
        if (!bl2) return false;
        return true;
    }

    public static final void registerActionsEvents(@NotNull ContributionScope $this$registerActionsEvents) {
        Intrinsics.checkNotNullParameter((Object)$this$registerActionsEvents, (String)"<this>");
        ReportingApiKt.customValidation((ContributionScope)$this$registerActionsEvents, (String)ActionTriggerValidator.Companion.getRULE_ID(), (Function0)registerActionsEvents.1.INSTANCE);
        ReportingApiKt.customValidation((ContributionScope)$this$registerActionsEvents, (String)ActionIdValidator.Companion.getRULE_ID(), (Function0)registerActionsEvents.2.INSTANCE);
        ReportingApiKt.customValidation((ContributionScope)$this$registerActionsEvents, (String)"fleet.actions.owners", (Function0)registerActionsEvents.3.INSTANCE);
        ReportingApiKt.eventLogGroup$default((ContributionScope)$this$registerActionsEvents, (Function0)((Function0)new PropertyReference0Impl(ActionsReports.INSTANCE){

            @Nullable
            public Object get() {
                return ((ActionsReports)this.receiver).getEventGroup$fleet_frontend();
            }
        }), (FusApiKind)FusApiKind.Main, (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ AtomicRef access$getReported$p() {
        return reported;
    }

    public static final /* synthetic */ KLogger access$getLogger() {
        return ActionsReportsKt.getLogger();
    }

    public static final /* synthetic */ boolean access$isSafeToReportAction(ActionId data) {
        return ActionsReportsKt.isSafeToReportAction(data);
    }

    public static final /* synthetic */ String access$getContextLanguageId(ActionContext actionContext2) {
        return ActionsReportsKt.getContextLanguageId(actionContext2);
    }

    public static final /* synthetic */ ActionsReports.ActionInvocationMethod access$toInvocationMethod(Initiator initiator) {
        return ActionsReportsKt.toInvocationMethod(initiator);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Initiator.values().length];
            try {
                nArray[Initiator.KeyboardEvent.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Initiator.MouseEvent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Initiator.Reactivity.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Initiator.Accessibility.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Initiator.AppMenu.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

