/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.actions;

import com.jetbrains.rhizomedb.CachedQuery;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.UtilKt;
import fleet.common.fus.validation.CustomValidationKt;
import fleet.dock.connectors.fus.EventContext;
import fleet.dock.connectors.fus.ValidationResult;
import fleet.dock.connectors.fus.ValidationRule;
import fleet.frontend.actions.ActionOwnersProviderEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfleet/frontend/actions/ActionOwnerValidator;", "Lfleet/dock/connectors/fus/ValidationRule;", "()V", "RULE_ID", "", "isSafeToReport", "", "owner", "validate", "Lfleet/dock/connectors/fus/ValidationResult;", "data", "context", "Lfleet/dock/connectors/fus/EventContext;", "AllowedActionOwnerCachedQuery", "fleet.frontend"})
public final class ActionOwnerValidator
implements ValidationRule {
    @NotNull
    public static final ActionOwnerValidator INSTANCE = new ActionOwnerValidator();
    @NotNull
    public static final String RULE_ID = "fleet.actions.owners";

    private ActionOwnerValidator() {
    }

    @NotNull
    public ValidationResult validate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isSafeToReport(data) ? ValidationResult.ACCEPTED : ValidationResult.REJECTED;
    }

    public final boolean isSafeToReport(@NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (Intrinsics.areEqual((Object)owner, (Object)"3rd party") || StringsKt.isBlank((CharSequence)owner)) {
            return true;
        }
        return ((Set)UtilKt.cachedQuery((CachedQuery)AllowedActionOwnerCachedQuery.INSTANCE)).contains(owner);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lfleet/frontend/actions/ActionOwnerValidator$AllowedActionOwnerCachedQuery;", "Lcom/jetbrains/rhizomedb/CachedQuery;", "", "", "()V", "query", "Lcom/jetbrains/rhizomedb/DbContext;", "Lcom/jetbrains/rhizomedb/Q;", "fleet.frontend"})
    @SourceDebugExtension(value={"SMAP\nActionsReports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionOwnerValidator$AllowedActionOwnerCachedQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n766#2:388\n857#2,2:389\n1446#2,5:391\n*S KotlinDebug\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionOwnerValidator$AllowedActionOwnerCachedQuery\n*L\n377#1:388\n377#1:389,2\n377#1:391,5\n*E\n"})
    private static final class AllowedActionOwnerCachedQuery
    implements CachedQuery<Set<? extends String>> {
        @NotNull
        public static final AllowedActionOwnerCachedQuery INSTANCE = new AllowedActionOwnerCachedQuery();

        private AllowedActionOwnerCachedQuery() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Set<String> query(@NotNull DbContext<? extends Q> $this$query) {
            void var3_4;
            void $this$flatMapTo$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$query, (String)"<this>");
            Iterable $this$filter$iv = EntitiesKt.byEntityType($this$query, (KClass)Reflection.getOrCreateKotlinClass(ActionOwnersProviderEntity.class));
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ActionOwnersProviderEntity it = (ActionOwnersProviderEntity)element$iv$iv;
                boolean bl = false;
                if (!CustomValidationKt.isFromAllowedPlugin((ValidationRule.Companion)ValidationRule.Companion, (Entity)((Entity)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ActionOwnersProviderEntity it = (ActionOwnersProviderEntity)element$iv;
                boolean bl = false;
                Iterable list$iv = (List)it.getOwnersProvider().invoke();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (Set)var3_4;
        }
    }
}

