/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import fleet.api.FileAddress;
import fleet.api.HostId;
import fleet.common.WorkspaceEntity;
import fleet.common.WorkspaceEntityKt;
import fleet.common.fs.SharedWorkspaceRootEntity;
import fleet.common.topology.Host;
import fleet.dock.connectors.SupervisorShipParams;
import fleet.frontend.ApplicationEntity;
import fleet.frontend.FrontendEntity;
import fleet.kernel.KernelKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\t\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u000b\u001a\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0006\u0010\u0013\u001a\u00020\r\u001a\u0006\u0010\u0014\u001a\u00020\r\u001a\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\n\u0010\u0017\u001a\u00020\r*\u00020\u0012\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"application", "Lfleet/frontend/ApplicationEntity;", "getApplication", "()Lfleet/frontend/ApplicationEntity;", "localHostId", "Lfleet/api/HostId;", "getLocalHostId", "()Lfleet/api/HostId;", "applicationIfAny", "closeFrontend", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "currentWorkspaceIsLocal", "", "isApplicationHost", "hostId", "isLocalFileAddress", "fileAddress", "Lfleet/api/FileAddress;", "isSupervisor", "isWorkspaceWithoutRoots", "localHost", "Lfleet/common/topology/Host;", "isOnLocalMachine", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nAppEntities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppEntities.kt\nfleet/frontend/AppEntitiesKt\n+ 2 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n+ 3 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt$singleOrNullOrThrow$1\n*L\n1#1,78:1\n33#2,5:79\n38#2,8:85\n33#3:84\n*S KotlinDebug\n*F\n+ 1 AppEntities.kt\nfleet/frontend/AppEntitiesKt\n*L\n49#1:79,5\n49#1:85,8\n49#1:84\n*E\n"})
public final class AppEntitiesKt {
    public static final boolean isLocalFileAddress(@NotNull FileAddress fileAddress) {
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        return Intrinsics.areEqual((Object)fileAddress.getHostId(), (Object)AppEntitiesKt.getApplication().getLocalServicesHostId());
    }

    @Nullable
    public static final Host localHost() {
        return Host.Companion.lookup(AppEntitiesKt.getLocalHostId());
    }

    @NotNull
    public static final ApplicationEntity getApplication() {
        return (ApplicationEntity)EntitiesKt.singleton((KClass)Reflection.getOrCreateKotlinClass(ApplicationEntity.class));
    }

    @NotNull
    public static final HostId getLocalHostId() {
        return AppEntitiesKt.getApplication().getLocalServicesHostId();
    }

    public static final boolean isApplicationHost(@NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        return Intrinsics.areEqual((Object)hostId, (Object)AppEntitiesKt.getApplication().getHostId()) || Intrinsics.areEqual((Object)hostId, (Object)AppEntitiesKt.getApplication().getLocalServicesHostId());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ApplicationEntity applicationIfAny() {
        void var2_2;
        Iterable $this$singleOrNullOrThrow_u24default$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(ApplicationEntity.class));
        boolean $i$f$singleOrNullOrThrow = false;
        Object single$iv = null;
        boolean found$iv = false;
        Iterator iterator = $this$singleOrNullOrThrow_u24default$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object t = element$iv = iterator.next();
            boolean bl = false;
            Object it = t;
            if (!true) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element: " + single$iv + ", " + element$iv);
            }
            single$iv = element$iv;
            found$iv = true;
        }
        return (ApplicationEntity)var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean currentWorkspaceIsLocal() {
        WorkspaceEntity workspace2 = WorkspaceEntityKt.currentWorkspace();
        ApplicationEntity appMaybe = AppEntitiesKt.applicationIfAny();
        if (appMaybe == null) return false;
        WorkspaceEntity workspaceEntity = workspace2;
        if (!Intrinsics.areEqual((Object)(workspaceEntity != null ? workspaceEntity.getWorkspaceHostId() : null), (Object)appMaybe.getHostId())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnLocalMachine(@NotNull FileAddress $this$isOnLocalMachine) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnLocalMachine, (String)"<this>");
        ApplicationEntity applicationEntity = AppEntitiesKt.applicationIfAny();
        if (Intrinsics.areEqual((Object)$this$isOnLocalMachine.getHostId(), (Object)(applicationEntity != null ? applicationEntity.getLocalServicesHostId() : null))) return true;
        ApplicationEntity applicationEntity2 = AppEntitiesKt.applicationIfAny();
        if (!Intrinsics.areEqual((Object)$this$isOnLocalMachine.getHostId(), (Object)(applicationEntity2 != null ? applicationEntity2.getHostId() : null))) return false;
        return true;
    }

    public static final boolean isWorkspaceWithoutRoots() {
        return SharedWorkspaceRootEntity.Companion.all().isEmpty() && !AppEntitiesKt.isSupervisor();
    }

    public static final boolean isSupervisor() {
        FrontendEntity frontendEntity = (FrontendEntity)EntitiesKt.singletonOrNull((KClass)Reflection.getOrCreateKotlinClass(FrontendEntity.class));
        return (frontendEntity != null ? frontendEntity.getShipParams() : null) instanceof SupervisorShipParams;
    }

    @Nullable
    public static final Object closeFrontend(@NotNull Continuation<? super Unit> $completion) {
        FrontendEntity frontendEntity = (FrontendEntity)EntitiesKt.singletonOrNull((KClass)Reflection.getOrCreateKotlinClass(FrontendEntity.class));
        if (frontendEntity != null) {
            FrontendEntity frontend = frontendEntity;
            boolean bl = false;
            Object object = KernelKt.change((Function1)((Function1)new Function1<ChangeScope, Unit>(frontend){
                final /* synthetic */ FrontendEntity $frontend;
                {
                    this.$frontend = $frontend;
                    super(1);
                }

                public final void invoke(@NotNull ChangeScope $this$change) {
                    Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                    $this$change.delete((Entity)this.$frontend);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }
}

