/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.parsing;

import fleet.com.intellij.lang.ITokenTypeRemapper;
import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.python.parsing.ParsingContext;
import fleet.com.jetbrains.python.parsing.PyParser;
import fleet.com.jetbrains.python.parsing.StatementParsing;
import fleet.com.jetbrains.python.psi.LanguageLevel;

public class PythonParser {
    protected static final Logger LOGGER = Logger.getInstance((String)PyParser.class.getName());
    protected LanguageLevel myLanguageLevel = LanguageLevel.getDefault();

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    public void parseRoot(IElementType root, SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker rootMarker = builder.mark();
        ParsingContext context = this.createParsingContext(builder, this.myLanguageLevel);
        StatementParsing statementParser = context.getStatementParser();
        builder.setTokenTypeRemapper((ITokenTypeRemapper)statementParser);
        boolean lastAfterSemicolon = false;
        while (!builder.eof()) {
            context.pushScope(context.emptyParsingScope());
            if (lastAfterSemicolon) {
                statementParser.parseSimpleStatement();
            } else {
                statementParser.parseStatement();
            }
            lastAfterSemicolon = context.getScope().isAfterSemicolon();
            context.popScope();
        }
        rootMarker.done(root);
    }

    protected ParsingContext createParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel) {
        return new ParsingContext(builder, languageLevel);
    }
}

