/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.parsing;

import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.python.PyElementTypes;
import fleet.com.jetbrains.python.PyParsingBundle;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.parsing.ExpressionParsing;
import fleet.com.jetbrains.python.parsing.FunctionParsing;
import fleet.com.jetbrains.python.parsing.ParsingContext;
import fleet.com.jetbrains.python.parsing.PatternParsing;
import fleet.com.jetbrains.python.parsing.StatementParsing;
import fleet.com.jetbrains.python.psi.PyElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    protected ParsingContext myContext;
    protected SyntaxTreeBuilder myBuilder;
    private static final Logger LOG = Logger.getInstance(Parsing.class);

    protected Parsing(ParsingContext context) {
        this.myContext = context;
        this.myBuilder = context.getBuilder();
    }

    public ParsingContext getParsingContext() {
        return this.myContext;
    }

    public ExpressionParsing getExpressionParser() {
        return this.getParsingContext().getExpressionParser();
    }

    public StatementParsing getStatementParser() {
        return this.getParsingContext().getStatementParser();
    }

    public FunctionParsing getFunctionParser() {
        return this.getParsingContext().getFunctionParser();
    }

    @NotNull
    public PatternParsing getPatternParser() {
        return this.getParsingContext().getPatternParser();
    }

    @Contract(mutates="this")
    protected boolean checkMatches(IElementType token, @NotNull @NlsContexts.ParsingError String message) {
        if (this.myBuilder.getTokenType() == token) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    protected boolean parseIdentifierOrSkip(IElementType ... validSuccessiveTokens) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            this.myBuilder.advanceLexer();
            return true;
        }
        SyntaxTreeBuilder.Marker nameExpected = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && !this.atAnyOfTokens(validSuccessiveTokens)) {
            this.myBuilder.advanceLexer();
        }
        nameExpected.error(PyParsingBundle.message("PARSE.expected.identifier", new Object[0]));
        return false;
    }

    protected void assertCurrentToken(PyElementType tokenType) {
        LOG.assertTrue(this.myBuilder.getTokenType() == tokenType);
    }

    protected boolean atToken(@Nullable IElementType tokenType) {
        return this.myBuilder.getTokenType() == tokenType;
    }

    protected boolean atToken(@NotNull IElementType tokenType, @NotNull String tokenText) {
        return this.myBuilder.getTokenType() == tokenType && tokenText.equals(this.myBuilder.getTokenText());
    }

    protected boolean atAnyOfTokens(IElementType ... tokenTypes) {
        IElementType currentTokenType = this.myBuilder.getTokenType();
        for (IElementType tokenType : tokenTypes) {
            if (currentTokenType != tokenType) continue;
            return true;
        }
        return false;
    }

    protected boolean atAnyOfTokens(@NotNull TokenSet tokenTypes) {
        return tokenTypes.contains(this.myBuilder.getTokenType());
    }

    protected boolean matchToken(IElementType tokenType) {
        if (this.myBuilder.getTokenType() == tokenType) {
            this.myBuilder.advanceLexer();
            return true;
        }
        return false;
    }

    protected void nextToken() {
        this.myBuilder.advanceLexer();
    }

    protected void advanceAsync(boolean falseAsync) {
        if (falseAsync) {
            Parsing.advanceError(this.myBuilder, PyParsingBundle.message("PARSE.async.keyword.not.expected.here", new Object[0]));
        } else {
            this.myBuilder.advanceLexer();
        }
    }

    protected static void advanceIdentifierLike(@NotNull SyntaxTreeBuilder builder) {
        if (Parsing.isFalseIdentifier(builder)) {
            String tokenText = builder.getTokenText();
            Parsing.advanceError(builder, PyParsingBundle.message("PARSE.keyword.cannot.be.used.as.identifier.py2", tokenText));
        } else {
            builder.advanceLexer();
        }
    }

    protected static void advanceError(@NotNull SyntaxTreeBuilder builder, @NotNull @NlsContexts.ParsingError String message) {
        SyntaxTreeBuilder.Marker err = builder.mark();
        builder.advanceLexer();
        err.error(message);
    }

    protected static boolean isIdentifier(@NotNull SyntaxTreeBuilder builder) {
        return builder.getTokenType() == PyTokenTypes.IDENTIFIER || Parsing.isFalseIdentifier(builder);
    }

    private static boolean isFalseIdentifier(@NotNull SyntaxTreeBuilder builder) {
        return builder.getTokenType() == PyTokenTypes.EXEC_KEYWORD || builder.getTokenType() == PyTokenTypes.PRINT_KEYWORD;
    }

    protected static void buildTokenElement(IElementType type, SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker marker = builder.mark();
        Parsing.advanceIdentifierLike(builder);
        marker.done(type);
    }

    protected IElementType getReferenceType() {
        return PyElementTypes.REFERENCE_EXPRESSION;
    }
}

