/*
 * Decompiled with CFR 0.152.
 */
package fleet.workspace.auth;

import fleet.api.WorkspaceId;
import fleet.api.auth.SpaceAuthOptions;
import fleet.net.HttpClientApi;
import fleet.rpc.relay.Authorizer;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.workspace.auth.JWK;
import fleet.workspace.auth.JWKS;
import fleet.workspace.auth.JWT;
import fleet.workspace.auth.OAuthAuthorizer;
import fleet.workspace.auth.OAuthAuthorizerKt;
import io.ktor.client.HttpClient;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lfleet/workspace/auth/OAuthAuthorizer;", "Lfleet/rpc/relay/Authorizer;", "workspaceId", "Lfleet/api/WorkspaceId;", "authorizerUrl", "", "httpClientApi", "Lfleet/net/HttpClientApi;", "(Lfleet/api/WorkspaceId;Ljava/lang/String;Lfleet/net/HttpClientApi;)V", "key", "getKey", "()Ljava/lang/String;", "options", "Lkotlinx/serialization/json/JsonElement;", "getOptions", "()Lkotlinx/serialization/json/JsonElement;", "getWorkspaceId", "()Lfleet/api/WorkspaceId;", "authorize", "Lfleet/rpc/relay/Authorizer$Verdict;", "request", "Lfleet/rpc/relay/Authorizer$Request;", "(Lfleet/rpc/relay/Authorizer$Request;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "fleet.workspace"})
@SourceDebugExtension(value={"SMAP\nOAuthAuthorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthAuthorizer.kt\nfleet/workspace/auth/OAuthAuthorizer\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,158:1\n13#2,2:159\n22#3:161\n*S KotlinDebug\n*F\n+ 1 OAuthAuthorizer.kt\nfleet/workspace/auth/OAuthAuthorizer\n*L\n46#1:159,2\n38#1:161\n*E\n"})
public final class OAuthAuthorizer
implements Authorizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkspaceId workspaceId;
    @NotNull
    private final String authorizerUrl;
    @NotNull
    private final HttpClientApi httpClientApi;
    @NotNull
    private final String key;
    @NotNull
    private final JsonElement options;
    @NotNull
    private static final KLogger logger;

    public OAuthAuthorizer(@NotNull WorkspaceId workspaceId, @NotNull String authorizerUrl, @NotNull HttpClientApi httpClientApi) {
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        Intrinsics.checkNotNullParameter((Object)authorizerUrl, (String)"authorizerUrl");
        Intrinsics.checkNotNullParameter((Object)httpClientApi, (String)"httpClientApi");
        this.workspaceId = workspaceId;
        this.authorizerUrl = authorizerUrl;
        this.httpClientApi = httpClientApi;
        this.key = "SPACE_OAUTH";
        this.options = Json.Default.encodeToJsonElement((SerializationStrategy)SpaceAuthOptions.Companion.serializer(), (Object)new SpaceAuthOptions(this.authorizerUrl, this.workspaceId));
    }

    @NotNull
    public final WorkspaceId getWorkspaceId() {
        return this.workspaceId;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public JsonElement getOptions() {
        return this.options;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object authorize(@NotNull Authorizer.Request var1_1, @NotNull Continuation<? super Authorizer.Verdict> var2_2) {
        if (!(var2_2 instanceof authorize.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ OAuthAuthorizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.authorize(null, (Continuation<? super Authorizer.Verdict>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this_$iv = OAuthAuthorizer.logger;
                $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    var11_9 = this_$iv;
                    $i$a$-info-OAuthAuthorizer$authorize$2 = false;
                    var11_9.info((Object)("Got authorization request " + request + ", " + this.authorizerUrl));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.label = 1;
                v0 = this.httpClientApi.httpClient((Continuation)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                request = (Authorizer.Request)$continuation.L$1;
                this = (OAuthAuthorizer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.label = 2;
                v1 = OAuthAuthorizerKt.access$retrieveJWKS((HttpClient)v0, this.authorizerUrl, (Continuation)$continuation);
                if (v1 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl43
            }
            case 2: {
                request = (Authorizer.Request)$continuation.L$1;
                this = (OAuthAuthorizer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                jwks = (JWKS)v1;
                jwk = (JWK)CollectionsKt.single(jwks.getKeys());
                jwtString = (String)Json.Default.decodeFromJsonElement((DeserializationStrategy)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), request.getCredentials());
                error = "";
                try {
                    var8_13 = OAuthAuthorizerKt.access$decodeJWT(jwtString, jwk);
                }
                catch (Exception e) {
                    v2 = e.getMessage();
                    if (v2 == null) {
                        v2 = "";
                    }
                    error = v2;
                    OAuthAuthorizer.logger.error((Throwable)e, (Object)"Unexpected JWT");
                    var8_13 = JWT.InvalidSignature.INSTANCE;
                }
                var8_13 = jwt = var8_13;
                if (Intrinsics.areEqual((Object)var8_13, (Object)JWT.InvalidSignature.INSTANCE)) {
                    v3 = (Authorizer.Verdict)new Authorizer.Verdict.Denied("Invalid JWT signature " + error);
                } else if (var8_13 instanceof JWT.Valid) {
                    var10_17 = ((JWT.Valid)jwt).getContents().get((Object)"fleet_ws");
                    v4 = var10_17 instanceof JsonPrimitive != false ? (JsonPrimitive)var10_17 : null;
                    v5 = fleetWs = v4 != null ? v4.getContent() : null;
                    v3 = Intrinsics.areEqual((Object)fleetWs, (Object)this.workspaceId.getUid().getId()) ? (Authorizer.Verdict)new Authorizer.Verdict.Accepted((Function2)new Function2<CoroutineScope, Continuation<? super Authorizer.Revocation>, Object>(null){
                        int label;

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                    if (object3 != object2) throw new KotlinNothingValueException();
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    throw new KotlinNothingValueException();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Authorizer.Revocation> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }) : (fleetWs == null ? (Authorizer.Verdict)new Authorizer.Verdict.Denied("No fleet_ws key in JWT") : (Authorizer.Verdict)new Authorizer.Verdict.Denied("Incorrect fleet_ws " + fleetWs));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(OAuthAuthorizer.class));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lfleet/workspace/auth/OAuthAuthorizer$Companion;", "", "()V", "logger", "Lfleet/util/logging/KLogger;", "fleet.workspace"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

