/*
 * Decompiled with CFR 0.152.
 */
package fleet.supervisor.impl.welcomescreen.connections;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.focus.FocusRequester;
import fleet.compose.theme.layout.NavigationStack;
import fleet.supervisor.api.ShipHostEntity;
import fleet.supervisor.api.SupervisorKey;
import fleet.supervisor.api.SupervisorPriority;
import fleet.supervisor.impl.ship.ShipHostEntitiesKt;
import fleet.supervisor.impl.ship.ShipHostSupervisorEntity;
import fleet.supervisor.impl.welcomescreen.connections.ConnectionsNavigationPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR/\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lfleet/supervisor/impl/welcomescreen/connections/ConnectionsViewModel;", "", "navigationStack", "Lfleet/compose/theme/layout/NavigationStack;", "Lfleet/supervisor/impl/welcomescreen/connections/ConnectionsNavigationPath;", "(Lfleet/compose/theme/layout/NavigationStack;)V", "availableConnectionTypes", "", "Lfleet/supervisor/impl/ship/ShipHostSupervisorEntity;", "getAvailableConnectionTypes", "()Ljava/util/List;", "contentFocusRequester", "Landroidx/compose/ui/focus/FocusRequester;", "getContentFocusRequester", "()Landroidx/compose/ui/focus/FocusRequester;", "<set-?>", "Lfleet/supervisor/api/SupervisorKey;", "currentSupervisorKey", "getCurrentSupervisorKey", "()Lfleet/supervisor/api/SupervisorKey;", "setCurrentSupervisorKey", "(Lfleet/supervisor/api/SupervisorKey;)V", "currentSupervisorKey$delegate", "Landroidx/compose/runtime/MutableState;", "getNavigationStack", "()Lfleet/compose/theme/layout/NavigationStack;", "navigateToExistingConnections", "", "host", "Lfleet/supervisor/api/ShipHostEntity;", "navigateToNewConnection", "fleet.supervisor"})
@SourceDebugExtension(value={"SMAP\nConnectionsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionsViewModel.kt\nfleet/supervisor/impl/welcomescreen/connections/ConnectionsViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,36:1\n766#2:37\n857#2,2:38\n68#3:40\n94#3,2:41\n*S KotlinDebug\n*F\n+ 1 ConnectionsViewModel.kt\nfleet/supervisor/impl/welcomescreen/connections/ConnectionsViewModel\n*L\n16#1:37\n16#1:38,2\n18#1:40\n18#1:41,2\n*E\n"})
public final class ConnectionsViewModel {
    @NotNull
    private final NavigationStack<ConnectionsNavigationPath> navigationStack;
    @NotNull
    private final FocusRequester contentFocusRequester;
    @NotNull
    private final MutableState currentSupervisorKey$delegate;

    public ConnectionsViewModel(@NotNull NavigationStack<ConnectionsNavigationPath> navigationStack) {
        Intrinsics.checkNotNullParameter(navigationStack, (String)"navigationStack");
        this.navigationStack = navigationStack;
        this.contentFocusRequester = new FocusRequester();
        ShipHostSupervisorEntity shipHostSupervisorEntity = (ShipHostSupervisorEntity)CollectionsKt.firstOrNull(this.getAvailableConnectionTypes());
        this.currentSupervisorKey$delegate = SnapshotStateKt.mutableStateOf$default((Object)(shipHostSupervisorEntity != null ? shipHostSupervisorEntity.getKey() : null), null, (int)2, null);
    }

    @NotNull
    public final NavigationStack<ConnectionsNavigationPath> getNavigationStack() {
        return this.navigationStack;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ShipHostSupervisorEntity> getAvailableConnectionTypes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ShipHostSupervisorEntity.Companion.all();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShipHostSupervisorEntity it = (ShipHostSupervisorEntity)element$iv$iv;
            boolean bl = false;
            if (!ShipHostEntitiesKt.getCanCreateNewConnection(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ShipHostSupervisorEntity it = (ShipHostSupervisorEntity)b;
                boolean bl = false;
                Comparable comparable = SupervisorPriority.box-impl(it.getSupervisor().getPriority-GjMK-Zs());
                it = (ShipHostSupervisorEntity)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)SupervisorPriority.box-impl(it.getSupervisor().getPriority-GjMK-Zs()));
            }
        });
    }

    @NotNull
    public final FocusRequester getContentFocusRequester() {
        return this.contentFocusRequester;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SupervisorKey getCurrentSupervisorKey() {
        void $this$getValue$iv;
        State state = (State)this.currentSupervisorKey$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (SupervisorKey)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentSupervisorKey(@Nullable SupervisorKey supervisorKey) {
        void $this$setValue$iv;
        MutableState mutableState = this.currentSupervisorKey$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)supervisorKey);
    }

    public final void navigateToNewConnection() {
        this.navigationStack.push((Object)ConnectionsNavigationPath.NewConnection.INSTANCE);
    }

    public final void navigateToExistingConnections(@NotNull ShipHostEntity host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.navigationStack.push((Object)new ConnectionsNavigationPath.EditConnection(host));
    }
}

