/*
 * Decompiled with CFR 0.152.
 */
package fleet.supervisor.api.util;

import fleet.api.Arch;
import fleet.api.Checksum;
import fleet.api.DownloadApi;
import fleet.api.Os;
import fleet.api.Platform;
import fleet.api.ProtocolPath;
import fleet.common.DownloadService;
import fleet.common.GlobalProgressProviderKt;
import fleet.common.SimpleProgressProvider;
import fleet.common.download.DownloadServiceExtensionsKt;
import fleet.common.download.FleetPartsS3ExtensionsKt;
import fleet.common.download.S3ArtifactType;
import fleet.common.download.S3Version;
import fleet.dock.connectors.ConnectorsKt;
import fleet.preferences.FleetPropertiesKt;
import fleet.supervisor.api.util.Launcher;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\n\u001a(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u001a \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u0010\u001a\u00020\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u001a,\u0010\u0011\u001a\u00020\u0003*\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"logger", "Lfleet/util/logging/KLogger;", "downloadLauncherForSupervisorOrUseLocal", "Lfleet/api/ProtocolPath;", "version", "", "platform", "Lfleet/api/Platform;", "downloadService", "Lfleet/common/DownloadService;", "(Ljava/lang/String;Lfleet/api/Platform;Lfleet/common/DownloadService;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLauncherStartArguments", "", "launchShipRequestPath", "cachePath", "getLauncherStopArguments", "shipId", "ensureLauncherDownloaded", "Lfleet/api/DownloadApi;", "progressProvider", "Lfleet/common/SimpleProgressProvider;", "(Lfleet/api/DownloadApi;Lfleet/api/Platform;Ljava/lang/String;Lfleet/common/SimpleProgressProvider;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.supervisor"})
@SourceDebugExtension(value={"SMAP\nLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Launcher.kt\nfleet/supervisor/api/util/LauncherKt\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,96:1\n17#2,2:97\n22#3:99\n*S KotlinDebug\n*F\n+ 1 Launcher.kt\nfleet/supervisor/api/util/LauncherKt\n*L\n24#1:97,2\n17#1:99\n*E\n"})
public final class LauncherKt {
    @NotNull
    private static final KLogger logger;

    @Nullable
    public static final Object downloadLauncherForSupervisorOrUseLocal(@NotNull String version, @NotNull Platform platform, @NotNull DownloadService downloadService, @NotNull Continuation<? super ProtocolPath> $completion) {
        ProtocolPath protocolPath;
        Platform localPlatform = Platform.Companion.local();
        boolean isSamePlatform = Intrinsics.areEqual((Object)localPlatform, (Object)platform);
        if (FleetPropertiesKt.isFleetUnpublishedBuild()) {
            KLogger this_$iv = logger;
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String v = isSamePlatform ? "local" : version;
                kLogger.warn((Object)("!!! This is an unpublished build. Local platform: " + localPlatform + ", container platform: " + platform + ". Using launcher:" + v));
            }
        }
        if (isSamePlatform) {
            Path path = ConnectorsKt.getLauncherPath((CoroutineContext)$completion.getContext());
            if (path == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            protocolPath = ProtocolPath.Companion.of$default((ProtocolPath.Companion)ProtocolPath.Companion, (String)((Object)path).toString(), null, (int)2, null);
        } else {
            Object object = GlobalProgressProviderKt.withProgress$default((String)"Download launcher binary", (boolean)false, (Function3)((Function3)new Function3<CoroutineScope, SimpleProgressProvider, Continuation<? super ProtocolPath>, Object>(downloadService, platform, version, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ DownloadService $downloadService;
                final /* synthetic */ Platform $platform;
                final /* synthetic */ String $version;
                {
                    this.$downloadService = $downloadService;
                    this.$platform = $platform;
                    this.$version = $version;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            SimpleProgressProvider progressProvider2 = (SimpleProgressProvider)this.L$0;
                            this.label = 1;
                            Object object3 = LauncherKt.access$ensureLauncherDownloaded((DownloadApi)this.$downloadService, this.$platform, this.$version, progressProvider2, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @NotNull SimpleProgressProvider p2, @Nullable Continuation<? super ProtocolPath> p3) {
                    var var4_4 = new /* invalid duplicate definition of identical inner class */;
                    var4_4.L$0 = p2;
                    return var4_4.invokeSuspend(Unit.INSTANCE);
                }
            }), $completion, (int)2, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            protocolPath = (ProtocolPath)object;
        }
        return protocolPath;
    }

    private static final Object ensureLauncherDownloaded(DownloadApi $this$ensureLauncherDownloaded, Platform platform, String version, SimpleProgressProvider progressProvider2, Continuation<? super ProtocolPath> $completion) {
        Object[] objectArray = new Platform[]{new Platform(Os.Macos, Arch.aarch64), new Platform(Os.Macos, Arch.arm), new Platform(Os.Macos, Arch.x86_64), new Platform(Os.Linux, Arch.aarch64), new Platform(Os.Linux, Arch.arm), new Platform(Os.Linux, Arch.x86_64), new Platform(Os.Windows, Arch.x86_64)};
        Set supportedLauncherPlatforms = SetsKt.setOf((Object[])objectArray);
        if (!supportedLauncherPlatforms.contains(platform)) {
            throw new IllegalStateException(("Unsupported platform: " + platform).toString());
        }
        String url = FleetPartsS3ExtensionsKt.s3ArtifactUrl$default((String)"launcher", null, (S3ArtifactType)((S3ArtifactType)S3ArtifactType.Binary.INSTANCE), (Platform)platform, (S3Version)(Intrinsics.areEqual((Object)version, (Object)"latest") ? (S3Version)S3Version.Latest.INSTANCE : (S3Version)new S3Version.Specific(version)), null, (int)34, null);
        return DownloadServiceExtensionsKt.download$default((DownloadApi)$this$ensureLauncherDownloaded, (String)url, (Checksum)((Checksum)FleetPartsS3ExtensionsKt.s3ArtifactChecksum((String)url)), (boolean)false, (SimpleProgressProvider)progressProvider2, $completion, (int)4, null);
    }

    @NotNull
    public static final List<String> getLauncherStartArguments(@NotNull String version, @NotNull String launchShipRequestPath, @Nullable String cachePath) {
        List list;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)launchShipRequestPath, (String)"launchShipRequestPath");
        List $this$getLauncherStartArguments_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (cachePath != null) {
            $this$getLauncherStartArguments_u24lambda_u241.add("--cache-path");
            $this$getLauncherStartArguments_u24lambda_u241.add(cachePath);
        }
        $this$getLauncherStartArguments_u24lambda_u241.add("--machine-readable-output");
        $this$getLauncherStartArguments_u24lambda_u241.add("dock");
        $this$getLauncherStartArguments_u24lambda_u241.add("start");
        $this$getLauncherStartArguments_u24lambda_u241.add("--request-file");
        $this$getLauncherStartArguments_u24lambda_u241.add(launchShipRequestPath);
        $this$getLauncherStartArguments_u24lambda_u241.add("--version");
        $this$getLauncherStartArguments_u24lambda_u241.add(version);
        return CollectionsKt.build((List)list);
    }

    public static /* synthetic */ List getLauncherStartArguments$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return LauncherKt.getLauncherStartArguments(string, string2, string3);
    }

    @NotNull
    public static final List<String> getLauncherStopArguments(@NotNull String shipId, @Nullable String cachePath) {
        Object[] objectArray;
        List list;
        Intrinsics.checkNotNullParameter((Object)shipId, (String)"shipId");
        List $this$getLauncherStopArguments_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (cachePath != null) {
            objectArray = new String[]{"--cache-path", cachePath};
            $this$getLauncherStopArguments_u24lambda_u242.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        $this$getLauncherStopArguments_u24lambda_u242.add("dock");
        objectArray = new String[]{"stop", "--ship-id", shipId};
        $this$getLauncherStopArguments_u24lambda_u242.addAll(CollectionsKt.listOf((Object[])objectArray));
        return CollectionsKt.build((List)list);
    }

    public static /* synthetic */ List getLauncherStopArguments$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return LauncherKt.getLauncherStopArguments(string, string2);
    }

    public static final /* synthetic */ Object access$ensureLauncherDownloaded(DownloadApi $receiver, Platform platform, String version, SimpleProgressProvider progressProvider2, Continuation $completion) {
        return LauncherKt.ensureLauncherDownloaded($receiver, platform, version, progressProvider2, (Continuation<? super ProtocolPath>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(Launcher.class));
    }
}

