/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.sh.parser;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.lang.WhitespaceSkippedCallback;
import fleet.com.intellij.lang.parser.GeneratedParserUtilBase;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.sh.ShTypes;
import fleet.com.intellij.sh.lexer.ShTokenTypes;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;

public class ShParserUtil
extends GeneratedParserUtilBase {
    private static final Key<Object2LongMap<String>> MODES_KEY = Key.create((String)"MODES_KEY");

    private static Object2LongMap<String> getParsingModes(PsiBuilder b) {
        Object2LongMap flags = (Object2LongMap)b.getUserData(MODES_KEY);
        if (flags == null) {
            flags = new Object2LongOpenHashMap();
            b.putUserData(MODES_KEY, (Object)flags);
        }
        return flags;
    }

    static boolean isModeOn(PsiBuilder b, int level, String mode) {
        return ShParserUtil.getParsingModes(b).getLong((Object)mode) > 0L;
    }

    static boolean withOn(PsiBuilder b, int level_, String mode, GeneratedParserUtilBase.Parser parser) {
        return ShParserUtil.withImpl(b, level_, mode, true, parser, parser);
    }

    private static boolean withImpl(PsiBuilder b, int level_, String mode, boolean onOff, GeneratedParserUtilBase.Parser whenOn, GeneratedParserUtilBase.Parser whenOff) {
        boolean change;
        Object2LongMap<String> map = ShParserUtil.getParsingModes(b);
        long prev = map.getLong((Object)mode);
        boolean bl = change = (prev & 1L) == 0L == onOff;
        if (change) {
            map.put((Object)mode, prev << 1 | (long)(onOff ? 1 : 0));
        }
        boolean result = (change ? whenOn : whenOff).parse(b, level_);
        if (change) {
            map.put((Object)mode, prev);
        }
        return result;
    }

    static boolean backslash(PsiBuilder b, int level) {
        return ShParserUtil.consumeTokenFast((PsiBuilder)b, (String)"\\\n");
    }

    static boolean notQuote(SyntaxTreeBuilder b, int level) {
        if (b.getTokenType() == ShTypes.OPEN_QUOTE || b.getTokenType() == ShTypes.CLOSE_QUOTE) {
            return false;
        }
        b.advanceLexer();
        return true;
    }

    static boolean differentBracketsWarning(SyntaxTreeBuilder b, int level) {
        b.error("Expected similar close bracket");
        return true;
    }

    static boolean parseUntilSpace(PsiBuilder b, int level, GeneratedParserUtilBase.Parser parser) {
        int startOffset = b.getCurrentOffset();
        PsiBuilder.Marker mark = b.mark();
        while (parser.parse(b, level) && !ShTokenTypes.whitespaceTokens.contains(b.rawLookup(0)) && !b.eof()) {
        }
        mark.drop();
        return b.getCurrentOffset() > startOffset;
    }

    static boolean keywordsRemapped(PsiBuilder b, int level) {
        IElementType type = b.getTokenType();
        if (ShTokenTypes.identifierKeywords.contains(type)) {
            PsiBuilder.Marker mark = b.mark();
            b.remapCurrentToken(ShTypes.WORD);
            b.advanceLexer();
            mark.done(ShTypes.LITERAL);
            return true;
        }
        return false;
    }

    static boolean arithmeticOperationsRemapped(PsiBuilder psiBuilder, int level) {
        IElementType type = psiBuilder.getTokenType();
        PsiBuilder.Marker marker = null;
        final boolean[] isWhitespaceSkipped = new boolean[1];
        while (!isWhitespaceSkipped[0] && (ShTokenTypes.arithmeticOperationsForRemapping.contains(type) || marker != null && ShTokenTypes.numbers.contains(type) || type == ShTypes.WORD)) {
            if (marker == null) {
                marker = psiBuilder.mark();
            }
            psiBuilder.setWhitespaceSkippedCallback(new WhitespaceSkippedCallback(){

                public void onSkip(IElementType type, int start, int end) {
                    isWhitespaceSkipped[0] = true;
                }
            });
            psiBuilder.remapCurrentToken(ShTypes.WORD);
            psiBuilder.advanceLexer();
            type = psiBuilder.getTokenType();
        }
        psiBuilder.setWhitespaceSkippedCallback(null);
        if (marker != null) {
            marker.collapse(ShTypes.WORD);
            return true;
        }
        return false;
    }

    static boolean functionNameKeywordsRemapped(SyntaxTreeBuilder b, int level) {
        IElementType type = b.getTokenType();
        if (ShTokenTypes.identifierKeywords.contains(type)) {
            b.remapCurrentToken(ShTypes.WORD);
            b.advanceLexer();
            return true;
        }
        return false;
    }
}

