/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.vim.frontend;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.Editor;
import andel.editor.EditorCommandType;
import andel.editor.EditorExtKt;
import andel.editor.EditorLayout;
import andel.editor.MutableEditor;
import andel.text.Text;
import andel.text.TextLine;
import andel.undo.UndoGroupKey;
import andel.undo.UndoScope;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.CaretRegisterStorage;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.LocalMarkStorage;
import com.maddyhome.idea.vim.api.SelectionInfo;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretBase;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.EditorLine;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.common.Offset;
import com.maddyhome.idea.vim.common.VimRangeKt;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import fleet.plugins.vim.frontend.FleetMutableVimEditor;
import fleet.plugins.vim.frontend.FleetVimCaretKt;
import fleet.plugins.vim.frontend.FleetVimCaretRegisterStorage;
import fleet.plugins.vim.frontend.FleetVimKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import noria.model.components.editor.CaretActionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010A\u001a\u00020\f2\b\u0010B\u001a\u0004\u0018\u00010CH\u0096\u0002J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\fH\u0016J\b\u0010K\u001a\u00020$H\u0016J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020EH\u0016J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020$H\u0016J\u0010\u0010R\u001a\u00020M2\u0006\u0010\u001b\u001a\u00020$H\u0016J\u0010\u0010S\u001a\u00020M2\u0006\u0010N\u001a\u00020IH\u0016J\b\u0010T\u001a\u00020MH\u0016J\b\u0010U\u001a\u00020MH\u0016J\u0018\u0010V\u001a\u00020M2\u0006\u0010W\u001a\u00020\u001c2\u0006\u0010X\u001a\u00020\u001cH\u0016J\u0010\u0010Y\u001a\u00020P2\u0006\u0010Z\u001a\u00020$H\u0016J\b\u0010[\u001a\u00020MH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u001a\u0010)\u001a\u00020*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u00100\u001a\u00020$2\u0006\u0010/\u001a\u00020$8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010&\"\u0004\b2\u00103R(\u00105\u001a\u0004\u0018\u0001042\b\u0010/\u001a\u0004\u0018\u0001048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010&R$\u0010<\u001a\u00020$2\u0006\u0010/\u001a\u00020$8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010&\"\u0004\b>\u00103R\u0014\u0010?\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010&\u00a8\u0006\\"}, d2={"Lfleet/plugins/vim/frontend/FleetVimCaret;", "Lcom/maddyhome/idea/vim/api/VimCaretBase;", "caret", "Landel/editor/Caret;", "editor", "Lfleet/plugins/vim/frontend/FleetMutableVimEditor;", "(Landel/editor/Caret;Lfleet/plugins/vim/frontend/FleetMutableVimEditor;)V", "getCaret", "()Landel/editor/Caret;", "getEditor", "()Lfleet/plugins/vim/frontend/FleetMutableVimEditor;", "isPrimary", "", "()Z", "isValid", "lastSelectionInfo", "Lcom/maddyhome/idea/vim/api/SelectionInfo;", "getLastSelectionInfo", "()Lcom/maddyhome/idea/vim/api/SelectionInfo;", "setLastSelectionInfo", "(Lcom/maddyhome/idea/vim/api/SelectionInfo;)V", "markStorage", "Lcom/maddyhome/idea/vim/api/LocalMarkStorage;", "getMarkStorage", "()Lcom/maddyhome/idea/vim/api/LocalMarkStorage;", "mutableEditor", "Landel/editor/MutableEditor;", "offset", "Lcom/maddyhome/idea/vim/common/Offset;", "getOffset", "()Lcom/maddyhome/idea/vim/common/Offset;", "registerStorage", "Lcom/maddyhome/idea/vim/api/CaretRegisterStorage;", "getRegisterStorage", "()Lcom/maddyhome/idea/vim/api/CaretRegisterStorage;", "selectionEnd", "", "getSelectionEnd", "()I", "selectionStart", "getSelectionStart", "vimInsertStart", "Lcom/maddyhome/idea/vim/common/LiveRange;", "getVimInsertStart", "()Lcom/maddyhome/idea/vim/common/LiveRange;", "setVimInsertStart", "(Lcom/maddyhome/idea/vim/common/LiveRange;)V", "value", "vimLastColumn", "getVimLastColumn", "setVimLastColumn", "(I)V", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "vimLastVisualOperatorRange", "getVimLastVisualOperatorRange", "()Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "setVimLastVisualOperatorRange", "(Lcom/maddyhome/idea/vim/group/visual/VisualChange;)V", "vimLine", "getVimLine", "vimSelectionStart", "getVimSelectionStart", "setVimSelectionStart", "visualLineStart", "getVisualLineStart", "equals", "other", "", "getBufferPosition", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "getLine", "Lcom/maddyhome/idea/vim/common/EditorLine$Pointer;", "getVisualPosition", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "hasSelection", "hashCode", "moveToBufferPosition", "", "position", "moveToInlayAwareOffset", "Lcom/maddyhome/idea/vim/api/VimCaret;", "newOffset", "moveToOffsetNative", "moveToVisualPosition", "removeSelection", "resetLastColumn", "setSelection", "start", "end", "setVimLastColumnAndGetCaret", "col", "vimSelectionStartClear", "fleet.plugins.vim.frontend"})
public final class FleetVimCaret
extends VimCaretBase {
    @NotNull
    private final Caret caret;
    @NotNull
    private final FleetMutableVimEditor editor;
    @NotNull
    private final MutableEditor mutableEditor;
    @NotNull
    private SelectionInfo lastSelectionInfo;
    @NotNull
    private final LocalMarkStorage markStorage;
    @NotNull
    private final CaretRegisterStorage registerStorage;
    @NotNull
    private LiveRange vimInsertStart;

    public FleetVimCaret(@NotNull Caret caret, @NotNull FleetMutableVimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.caret = caret;
        this.editor = editor;
        this.mutableEditor = this.getEditor().getMutableEditor();
        this.lastSelectionInfo = new SelectionInfo(null, null, SelectionType.CHARACTER_WISE);
        this.markStorage = new LocalMarkStorage((ImmutableVimCaret)this);
        this.registerStorage = (CaretRegisterStorage)new FleetVimCaretRegisterStorage(this);
        this.vimInsertStart = this.getEditor().createLiveMarker(this.getOffset(), this.getOffset());
    }

    @NotNull
    public final Caret getCaret() {
        return this.caret;
    }

    @NotNull
    public FleetMutableVimEditor getEditor() {
        return this.editor;
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public SelectionInfo getLastSelectionInfo() {
        return this.lastSelectionInfo;
    }

    public void setLastSelectionInfo(@NotNull SelectionInfo selectionInfo) {
        Intrinsics.checkNotNullParameter((Object)selectionInfo, (String)"<set-?>");
        this.lastSelectionInfo = selectionInfo;
    }

    @NotNull
    public LocalMarkStorage getMarkStorage() {
        return this.markStorage;
    }

    @NotNull
    public Offset getOffset() {
        return VimRangeKt.getOffset((int)((int)this.caret.getOffset()));
    }

    @NotNull
    public CaretRegisterStorage getRegisterStorage() {
        return this.registerStorage;
    }

    public int getSelectionEnd() {
        return (int)this.caret.getSelection().getEnd();
    }

    public int getSelectionStart() {
        return (int)this.caret.getSelection().getStart();
    }

    @NotNull
    public LiveRange getVimInsertStart() {
        return this.vimInsertStart;
    }

    public void setVimInsertStart(@NotNull LiveRange liveRange) {
        Intrinsics.checkNotNullParameter((Object)liveRange, (String)"<set-?>");
        this.vimInsertStart = liveRange;
    }

    public int getVimLastColumn() {
        TextLine line = Text.lineAtCharOffset$default((Text)this.mutableEditor.getDocument().getText(), (long)this.caret.getOffset(), (boolean)false, (int)2, null);
        boolean bl = false;
        return FleetVimKt.graphemeCount((CharSequence)line.asCharSequence(), 0, (int)(this.caret.getOffset() - line.getFromChar()));
    }

    public void setVimLastColumn(int value) {
        float vCol = (float)value * this.getEditor().getMonospacedFontMetrics().getCharWidth-D9Ej5fM();
        EditorExtKt.moveCarets((MutableEditor)this.mutableEditor, (List)CollectionsKt.listOf((Object)Caret.copy$default((Caret)this.caret, null, null, (Float)Float.valueOf(vCol), (int)3, null)));
    }

    public void resetLastColumn() {
        EditorExtKt.moveCarets((MutableEditor)this.mutableEditor, (List)CollectionsKt.listOf((Object)Caret.copy$default((Caret)this.caret, null, null, null, (int)3, null)));
    }

    @Nullable
    public VisualChange getVimLastVisualOperatorRange() {
        FleetVimKt.TODOUNIT();
        return null;
    }

    public void setVimLastVisualOperatorRange(@Nullable VisualChange value) {
    }

    public void vimSelectionStartClear() {
        FleetVimCaretKt.access$set_vimSelectionStart$p(null);
    }

    public void setSelection(@NotNull Offset start, @NotNull Offset end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        int offset = RangesKt.coerceIn((int)this.getOffset().getPoint(), (int)start.getPoint(), (int)end.getPoint());
        EditorExtKt.moveCarets((MutableEditor)this.mutableEditor, (List)CollectionsKt.listOf((Object)Caret.move$default((Caret)this.caret, (CaretPosition)new CaretPosition((long)offset, (long)start.getPoint(), (long)end.getPoint()), null, (int)2, null)));
    }

    public void removeSelection() {
        EditorExtKt.dropSelection((MutableEditor)this.mutableEditor, (Caret)this.caret);
    }

    public int getVimLine() {
        FleetVimKt.TODOUNIT();
        return 0;
    }

    public boolean isPrimary() {
        return Intrinsics.areEqual((Object)this.mutableEditor.getMultiCaret().getPrimaryCaret().getCaretId(), (Object)this.caret.getCaretId());
    }

    @NotNull
    public BufferPosition getBufferPosition() {
        return FleetVimKt.offsetToBufferPosition(this.caret.getOffset(), (Editor)this.mutableEditor);
    }

    public int getVimSelectionStart() {
        Integer selectionStart = FleetVimCaretKt.access$get_vimSelectionStart$p();
        if (selectionStart == null) {
            this.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset((ImmutableVimCaret)((ImmutableVimCaret)this)));
            return EngineVisualGroupKt.getVimLeadSelectionOffset((ImmutableVimCaret)((ImmutableVimCaret)this));
        }
        return selectionStart;
    }

    public void setVimSelectionStart(int value) {
        FleetVimCaretKt.access$set_vimSelectionStart$p(value);
    }

    public int getVisualLineStart() {
        FleetVimKt.TODOUNIT();
        return 0;
    }

    @NotNull
    public EditorLine.Pointer getLine() {
        return new EditorLine.Pointer((int)Text.lineAtCharOffset$default((Text)this.mutableEditor.getDocument().getText(), (long)this.caret.getOffset(), (boolean)false, (int)2, null).getLineNumber());
    }

    @NotNull
    public VimVisualPosition getVisualPosition() {
        TextLine line = Text.lineAtCharOffset$default((Text)this.mutableEditor.getDocument().getText(), (long)this.caret.getOffset(), (boolean)false, (int)2, null);
        return new VimVisualPosition((int)line.getLineNumber(), FleetVimKt.graphemeCount((CharSequence)line.asCharSequence(), 0, (int)this.caret.getOffset() - (int)line.getFromChar()), false, 4, null);
    }

    public boolean hasSelection() {
        return this.caret.hasSelection();
    }

    @NotNull
    public VimCaret moveToInlayAwareOffset(int newOffset) {
        Text text = this.mutableEditor.getDocument().getText();
        float vCol = CaretActionsKt.offsetToVCol((EditorLayout)this.mutableEditor.getLayout(), (Text)text, (long)newOffset, null);
        Caret caretAfterMove = this.caret.move(new CaretPosition((long)newOffset), Float.valueOf(vCol));
        this.mutableEditor.command(EditorCommandType.NAVIGATION, (UndoGroupKey)this.getEditor().getCurrentUndoGroupKey(), (Function1)new Function1<UndoScope, Unit>(this, caretAfterMove){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ Caret $caretAfterMove;
            {
                this.this$0 = $receiver;
                this.$caretAfterMove = $caretAfterMove;
                super(1);
            }

            public final void invoke(@NotNull UndoScope $this$command) {
                Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                EditorExtKt.moveCarets((MutableEditor)FleetVimCaret.access$getMutableEditor$p(this.this$0), (List)CollectionsKt.listOf((Object)this.$caretAfterMove));
            }
        });
        return (VimCaret)new FleetVimCaret(caretAfterMove, this.getEditor());
    }

    public void moveToBufferPosition(@NotNull BufferPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Text text = this.mutableEditor.getDocument().getText();
        long offset = Text.lines$default((Text)text, (boolean)false, (int)1, null).lineStartOffset((long)position.getLine()) + (long)position.getColumn();
        float vCol = CaretActionsKt.offsetToVCol((EditorLayout)this.mutableEditor.getLayout(), (Text)text, (long)offset, null);
        this.mutableEditor.command(EditorCommandType.NAVIGATION, (UndoGroupKey)this.getEditor().getCurrentUndoGroupKey(), (Function1)new Function1<UndoScope, Unit>(this, offset, vCol){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ long $offset;
            final /* synthetic */ float $vCol;
            {
                this.this$0 = $receiver;
                this.$offset = $offset;
                this.$vCol = $vCol;
                super(1);
            }

            public final void invoke(@NotNull UndoScope $this$command) {
                Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                EditorExtKt.moveCarets((MutableEditor)FleetVimCaret.access$getMutableEditor$p(this.this$0), (List)CollectionsKt.listOf((Object)this.this$0.getCaret().move(new CaretPosition(this.$offset), Float.valueOf(this.$vCol))));
            }
        });
    }

    public void moveToOffsetNative(int offset) {
        CaretPosition caretPosition;
        long offsetAsLong = offset;
        if (EditorExtensionsKt.getInVisualMode((VimEditor)((VimEditor)this.getEditor())) || EditorExtensionsKt.getInSelectMode((VimEditor)((VimEditor)this.getEditor()))) {
            long l;
            long l2 = this.caret.getOffset();
            if (l2 == this.caret.getSelection().getStart()) {
                l = this.caret.getSelection().getEnd();
            } else if (l2 == this.caret.getSelection().getEnd()) {
                l = this.caret.getSelection().getStart();
            } else {
                throw new IllegalStateException("Caret unexpectedly positioned neither at the start nor at the end of the selection".toString());
            }
            long selectionAnchor = l;
            Object[] objectArray = new Long[]{selectionAnchor, offset};
            List list = CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])objectArray));
            long selectionStart = ((Number)list.get(0)).longValue();
            long selectionEnd = ((Number)list.get(1)).longValue();
            caretPosition = new CaretPosition(offsetAsLong, selectionStart, selectionEnd);
        } else {
            caretPosition = new CaretPosition(offsetAsLong);
        }
        CaretPosition newCaretPosition = caretPosition;
        Text text = this.mutableEditor.getDocument().getText();
        float vCol = CaretActionsKt.offsetToVCol((EditorLayout)this.mutableEditor.getLayout(), (Text)text, (long)offset, null);
        this.mutableEditor.command(EditorCommandType.NAVIGATION, (UndoGroupKey)this.getEditor().getCurrentUndoGroupKey(), (Function1)new Function1<UndoScope, Unit>(this, newCaretPosition, vCol){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ CaretPosition $newCaretPosition;
            final /* synthetic */ float $vCol;
            {
                this.this$0 = $receiver;
                this.$newCaretPosition = $newCaretPosition;
                this.$vCol = $vCol;
                super(1);
            }

            public final void invoke(@NotNull UndoScope $this$command) {
                Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                EditorExtKt.moveCarets((MutableEditor)FleetVimCaret.access$getMutableEditor$p(this.this$0), (List)CollectionsKt.listOf((Object)this.this$0.getCaret().move(this.$newCaretPosition, Float.valueOf(this.$vCol))));
            }
        });
    }

    public void moveToVisualPosition(@NotNull VimVisualPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        FleetVimKt.TODOUNIT();
    }

    @NotNull
    public VimCaret setVimLastColumnAndGetCaret(int col) {
        float vCol = (float)col * this.getEditor().getMonospacedFontMetrics().getCharWidth-D9Ej5fM();
        Caret newCaret = Caret.copy$default((Caret)this.caret, null, null, (Float)Float.valueOf(vCol), (int)3, null);
        EditorExtKt.moveCarets((MutableEditor)this.mutableEditor, (List)CollectionsKt.listOf((Object)newCaret));
        return (VimCaret)new FleetVimCaret(newCaret, this.getEditor());
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof FleetVimCaret && Intrinsics.areEqual((Object)this.caret.getCaretId(), (Object)((FleetVimCaret)((Object)other)).caret.getCaretId());
    }

    public int hashCode() {
        return this.caret.getCaretId().hashCode();
    }

    public static final /* synthetic */ MutableEditor access$getMutableEditor$p(FleetVimCaret $this) {
        return $this.mutableEditor;
    }
}

