/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay.jwt;

import fleet.rpc.relay.jwt.JWK;
import fleet.rpc.relay.jwt.JWS;
import fleet.rpc.relay.jwt.KeyPair;
import fleet.rpc.relay.jwt.PrivateKey;
import fleet.rpc.relay.jwt.PublicKey;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002\u00a8\u0006\u001a"}, d2={"generateKeyPair", "Lfleet/rpc/relay/jwt/KeyPair;", "jwk", "Lfleet/rpc/relay/jwt/JWK;", "publicKey", "Lfleet/rpc/relay/jwt/PublicKey;", "jws", "Lfleet/rpc/relay/jwt/JWS;", "payload", "Lkotlinx/serialization/json/JsonObject;", "keyPair", "jwtBase64Decode", "", "base64", "", "jwtBase64Encode", "content", "x509certificate", "Ljava/security/cert/X509Certificate;", "signContent", "key", "Lfleet/rpc/relay/jwt/PrivateKey;", "verifyJWS", "", "verifySignature", "signature", "fleet.rpc.relay"})
@SourceDebugExtension(value={"SMAP\nJWT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWT.kt\nfleet/rpc/relay/jwt/JWTKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class JWTKt {
    private static final String jwtBase64Encode(byte[] content) {
        String string = Base64.getUrlEncoder().encodeToString(content);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        char[] cArray = new char[]{'='};
        return StringsKt.trim((String)string, (char[])cArray);
    }

    private static final byte[] jwtBase64Decode(String base64) {
        byte[] byArray = Base64.getUrlDecoder().decode(base64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @NotNull
    public static final KeyPair generateKeyPair() {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator it = keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        it.initialize(2048);
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        java.security.KeyPair subjectKeyPair = keyPairGenerator2.genKeyPair();
        java.security.PublicKey publicKey = subjectKeyPair.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        RSAPublicKey it2 = (RSAPublicKey)publicKey;
        boolean bl2 = false;
        byte[] byArray = it2.getPublicExponent().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = it2.getModulus().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        PublicKey publicKey2 = new PublicKey(byArray, byArray2);
        java.security.PrivateKey privateKey = subjectKeyPair.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        RSAPrivateKey it3 = (RSAPrivateKey)privateKey;
        boolean bl3 = false;
        byte[] byArray3 = it3.getPrivateExponent().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
        byte[] byArray4 = it3.getModulus().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"toByteArray(...)");
        PrivateKey privateKey2 = new PrivateKey(byArray3, byArray4);
        return new KeyPair(publicKey2, privateKey2);
    }

    @NotNull
    public static final JWK jwk(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return new JWK("RSA", "RS512", JWTKt.jwtBase64Encode(publicKey.getPublicExponent()), JWTKt.jwtBase64Encode(publicKey.getModulus()));
    }

    @NotNull
    public static final PublicKey publicKey(@NotNull X509Certificate x509certificate) {
        Intrinsics.checkNotNullParameter((Object)x509certificate, (String)"x509certificate");
        if (!Intrinsics.areEqual((Object)x509certificate.getPublicKey().getAlgorithm(), (Object)"RSA")) {
            boolean $i$a$-require-JWTKt$publicKey$22 = false;
            String $i$a$-require-JWTKt$publicKey$22 = "Only RSA key type is supported";
            throw new IllegalArgumentException($i$a$-require-JWTKt$publicKey$22.toString());
        }
        java.security.PublicKey publicKey = x509certificate.getPublicKey();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        RSAPublicKey it = (RSAPublicKey)publicKey;
        boolean bl = false;
        byte[] byArray = it.getPublicExponent().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = it.getModulus().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        return new PublicKey(byArray, byArray2);
    }

    @NotNull
    public static final JWS jws(@NotNull JsonObject payload, @NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Base64.Encoder base64 = Base64.getUrlEncoder();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"alg", (Object)JsonElementKt.JsonPrimitive((String)"RS512")), TuplesKt.to((Object)"jwk", (Object)Json.Default.encodeToJsonElement((SerializationStrategy)JWK.Companion.serializer(), (Object)JWTKt.jwk(keyPair.getPublic())))};
        JsonObject header = new JsonObject(MapsKt.mapOf((Pair[])pairArray));
        String payloadString = JWTKt.jws$encodeJson(base64, payload);
        String headerString = JWTKt.jws$encodeJson(base64, header);
        String signingInput = headerString + "." + payloadString;
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] byArray = signingInput.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] signature = JWTKt.signContent(privateKey, byArray);
        String signatureString = base64.encodeToString(signature);
        Intrinsics.checkNotNull((Object)signatureString);
        return new JWS(headerString, payloadString, signatureString);
    }

    public static final boolean verifyJWS(@NotNull JWS jws, @NotNull JWK jwk) {
        Intrinsics.checkNotNullParameter((Object)jws, (String)"jws");
        Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
        JsonObject headerJson = (JsonObject)Json.Default.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), new String(JWTKt.jwtBase64Decode(jws.getHeader()), Charsets.UTF_8));
        JsonElement it = (JsonElement)headerJson.get((Object)"alg");
        boolean bl = false;
        Object object = it instanceof JsonPrimitive ? (JsonPrimitive)it : null;
        if (object == null || (object = object.getContent()) == null) {
            throw new IllegalStateException(("Invalid \"alg\" value " + it).toString());
        }
        Object jwsAlg = object;
        if (!Intrinsics.areEqual((Object)jwk.getKty(), (Object)"RSA")) {
            boolean $i$a$-check-JWTKt$verifyJWS$42 = false;
            String $i$a$-check-JWTKt$verifyJWS$42 = "Only RSA key type is supported";
            throw new IllegalStateException($i$a$-check-JWTKt$verifyJWS$42.toString());
        }
        if (!Intrinsics.areEqual((Object)jwsAlg, (Object)"RS512")) {
            boolean $i$a$-check-JWTKt$verifyJWS$52 = false;
            String $i$a$-check-JWTKt$verifyJWS$52 = "Only RS512 algorithm is supported";
            throw new IllegalStateException($i$a$-check-JWTKt$verifyJWS$52.toString());
        }
        if (!Intrinsics.areEqual((Object)jwsAlg, (Object)jwk.getAlg())) {
            boolean $i$a$-check-JWTKt$verifyJWS$62 = false;
            String $i$a$-check-JWTKt$verifyJWS$62 = "JWS algorithm does not match JWK algorithm: " + (String)jwsAlg + " vs " + jwk.getAlg();
            throw new IllegalStateException($i$a$-check-JWTKt$verifyJWS$62.toString());
        }
        byte[] byArray = (jws.getHeader() + "." + jws.getPayload()).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] signingInput = byArray;
        byte[] signatureBytes = JWTKt.jwtBase64Decode(jws.getSignature());
        byte[] byArray2 = JWTKt.jwtBase64Decode(jwk.getModulus());
        byte[] byArray3 = JWTKt.jwtBase64Decode(jwk.getExponent());
        PublicKey publicKey = new PublicKey(byArray3, byArray2);
        return JWTKt.verifySignature(publicKey, signingInput, signatureBytes);
    }

    private static final byte[] signContent(PrivateKey key, byte[] content) {
        Signature signature;
        Signature $this$signContent_u24lambda_u249 = signature = Signature.getInstance("SHA512withRSA");
        boolean bl = false;
        $this$signContent_u24lambda_u249.initSign(key.key$fleet_rpc_relay());
        $this$signContent_u24lambda_u249.update(content);
        byte[] byArray = signature.sign();
        Intrinsics.checkNotNull((Object)byArray);
        return byArray;
    }

    private static final boolean verifySignature(PublicKey key, byte[] content, byte[] signature) {
        Signature signature2;
        Signature $this$verifySignature_u24lambda_u2410 = signature2 = Signature.getInstance("SHA512withRSA");
        boolean bl = false;
        $this$verifySignature_u24lambda_u2410.initVerify(key.key$fleet_rpc_relay());
        $this$verifySignature_u24lambda_u2410.update(content);
        return signature2.verify(signature);
    }

    private static final String jws$encodeJson(Base64.Encoder base64, JsonObject json) {
        String jsonString = Json.Default.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)json);
        byte[] byArray = jsonString.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string = base64.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    public static final /* synthetic */ byte[] access$jwtBase64Decode(String base64) {
        return JWTKt.jwtBase64Decode(base64);
    }

    public static final /* synthetic */ String access$jwtBase64Encode(byte[] content) {
        return JWTKt.jwtBase64Encode(content);
    }
}

