/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.javascript.common;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"unquoteAndUnescapeString", "", "content", "isQuotedString", "", "s", "unquoteString", "parseStringCharacters", "chars", "outChars", "Ljava/lang/StringBuilder;", "regExp", "escapeBacktick", "fleet.plugins.javascript.common"})
public final class JSStringUtilKt {
    @NotNull
    public static final String unquoteAndUnescapeString(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String stringContent = JSStringUtilKt.unquoteString(content);
        StringBuilder builder = new StringBuilder();
        JSStringUtilKt.parseStringCharacters(stringContent, builder, false, false);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String possibleParent = string;
        return possibleParent;
    }

    private static final boolean isQuotedString(String s) {
        int length = s.length();
        if (length <= 1) {
            return false;
        }
        char firstChar = s.charAt(0);
        if (firstChar != '\'' && firstChar != '\"') {
            return false;
        }
        return firstChar == s.charAt(length - 1);
    }

    private static final String unquoteString(String s) {
        String string;
        if (JSStringUtilKt.isQuotedString(s)) {
            String string2 = s.substring(1, s.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = s;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean parseStringCharacters(String chars, StringBuilder outChars, boolean regExp, boolean escapeBacktick) {
        if (StringsKt.indexOf$default((CharSequence)chars, (char)'\\', (int)0, (boolean)false, (int)6, null) < 0) {
            outChars.append(chars);
            return true;
        }
        int index = 0;
        boolean result = true;
        while (index < chars.length()) {
            StringBuilder stringBuilder;
            char c;
            if ((c = chars.charAt(index++)) != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            if (escapeBacktick && c == '`') {
                stringBuilder = outChars.append(c);
                continue;
            }
            if (regExp) {
                if (c != '/') {
                    outChars.append('\\');
                }
                stringBuilder = outChars.append(c);
                continue;
            }
            switch (c) {
                case 'b': {
                    stringBuilder = outChars.append('\b');
                    break;
                }
                case 't': {
                    stringBuilder = outChars.append('\t');
                    break;
                }
                case '\n': 
                case 'n': {
                    stringBuilder = outChars.append('\n');
                    break;
                }
                case 'r': {
                    stringBuilder = outChars.append('\r');
                    break;
                }
                case '\"': {
                    stringBuilder = outChars.append('\"');
                    break;
                }
                case '/': {
                    stringBuilder = outChars.append('/');
                    break;
                }
                case '\'': {
                    stringBuilder = outChars.append('\'');
                    break;
                }
                case '\\': {
                    stringBuilder = outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v2 = c - 48;
                    if (index < chars.length()) {
                        if (Intrinsics.compare((int)48, (int)(c = chars.charAt(index++))) <= 0 && Intrinsics.compare((int)c, (int)55) <= 0) {
                            v2 <<= 3;
                            v2 += c - 48;
                            if (Intrinsics.compare((int)startC, (int)51) <= 0 && index < chars.length()) {
                                if (Intrinsics.compare((int)48, (int)(c = chars.charAt(index++))) <= 0 && Intrinsics.compare((int)c, (int)55) <= 0) {
                                    v2 <<= 3;
                                    v2 += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    stringBuilder = outChars.append((char)v2);
                    break;
                }
                case 'x': {
                    int v;
                    if (index + 2 > chars.length()) return false;
                    try {
                        String string = chars.substring(index, index + 2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        v = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                        outChars.append((char)v);
                        index += 2;
                    }
                    catch (Exception e) {
                        return false;
                    }
                    stringBuilder = Unit.INSTANCE;
                    break;
                }
                case 'u': {
                    int v;
                    int v2;
                    if (index + 3 <= chars.length() && chars.charAt(index) == '{') {
                        int end = StringsKt.indexOf$default((CharSequence)chars, (char)'}', (int)(index + 1), (boolean)false, (int)4, null);
                        if (end < 0) {
                            return false;
                        }
                        try {
                            String string = chars.substring(index + 1, end);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            v2 = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                            c = chars.charAt(index + 1);
                            switch (c) {
                                case '+': 
                                case '-': {
                                    return false;
                                }
                                default: {
                                    outChars.appendCodePoint(v2);
                                    index = end + 1;
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    if (index + 4 > chars.length()) return false;
                    try {
                        String string = chars.substring(index, index + 4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        v = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                        c = chars.charAt(index);
                        switch (c) {
                            case '+': 
                            case '-': {
                                return false;
                            }
                            default: {
                                outChars.append((char)v);
                                index += 4;
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                    stringBuilder = Unit.INSTANCE;
                    break;
                }
                default: {
                    stringBuilder = outChars.append(c);
                }
            }
        }
        return result;
    }

    static /* synthetic */ boolean parseStringCharacters$default(String string, StringBuilder stringBuilder, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return JSStringUtilKt.parseStringCharacters(string, stringBuilder, bl, bl2);
    }
}

