/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.run.impl.terminal;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.Os;
import fleet.api.PlatformKt;
import fleet.common.run.api.RunNodeEntity;
import fleet.common.run.api.StdinCommand;
import fleet.frontend.run.api.terminal.ShellName;
import fleet.frontend.run.impl.terminal.CapturedExecutionUnit;
import fleet.frontend.run.impl.terminal.TerminalContextEntity;
import fleet.frontend.run.impl.terminal.TerminalExecutionUnitsKt;
import fleet.kernel.TransactorKt;
import fleet.rpc.core.Blob;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ6\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001bJ.\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001aJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010#J,\u0010$\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c2\u0003J7\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010*\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010 \u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lfleet/frontend/run/impl/terminal/TerminalContext;", "", "runNodeEntity", "Lfleet/common/run/api/RunNodeEntity;", "shellName", "Lfleet/frontend/run/api/terminal/ShellName;", "os", "Lfleet/api/Os;", "input", "Lkotlinx/coroutines/channels/SendChannel;", "Lfleet/common/run/api/StdinCommand;", "<init>", "(Lfleet/common/run/api/RunNodeEntity;Lfleet/frontend/run/api/terminal/ShellName;Lfleet/api/Os;Lkotlinx/coroutines/channels/SendChannel;)V", "getRunNodeEntity", "()Lfleet/common/run/api/RunNodeEntity;", "getShellName", "()Lfleet/frontend/run/api/terminal/ShellName;", "getOs", "()Lfleet/api/Os;", "sendInput", "", "text", "", "append", "", "meta", "", "(Ljava/lang/String;ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trySendInput", "captureExecutionUnits", "Lkotlin/sequences/Sequence;", "Lfleet/frontend/run/impl/terminal/CapturedExecutionUnit;", "isImmutable", "()Ljava/lang/Boolean;", "setImmutable", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildCommand", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "fleet.run.frontend"})
public final class TerminalContext {
    @NotNull
    private final RunNodeEntity runNodeEntity;
    @NotNull
    private final ShellName shellName;
    @NotNull
    private final Os os;
    @NotNull
    private final SendChannel<StdinCommand> input;

    public TerminalContext(@NotNull RunNodeEntity runNodeEntity, @NotNull ShellName shellName, @NotNull Os os2, @NotNull SendChannel<? super StdinCommand> input2) {
        Intrinsics.checkNotNullParameter((Object)runNodeEntity, (String)"runNodeEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)shellName), (String)"shellName");
        Intrinsics.checkNotNullParameter((Object)os2, (String)"os");
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        this.runNodeEntity = runNodeEntity;
        this.shellName = shellName;
        this.os = os2;
        this.input = input2;
    }

    @NotNull
    public final RunNodeEntity getRunNodeEntity() {
        return this.runNodeEntity;
    }

    @NotNull
    public final ShellName getShellName() {
        return this.shellName;
    }

    @NotNull
    public final Os getOs() {
        return this.os;
    }

    @Nullable
    public final Object sendInput(@NotNull String text, boolean append, @NotNull Map<String, String> meta, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.input.send((Object)this.buildCommand(text, append, meta), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object sendInput$default(TerminalContext terminalContext2, String string, boolean bl, Map map2, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return terminalContext2.sendInput(string, bl, map2, (Continuation<? super Unit>)continuation);
    }

    public final void trySendInput(@NotNull String text, boolean append, @NotNull Map<String, String> meta) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        this.input.trySend-JP2dKIU((Object)this.buildCommand(text, append, meta));
    }

    public static /* synthetic */ void trySendInput$default(TerminalContext terminalContext2, String string, boolean bl, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        terminalContext2.trySendInput(string, bl, map2);
    }

    @NotNull
    public final Sequence<CapturedExecutionUnit> captureExecutionUnits() {
        return TerminalExecutionUnitsKt.captureExecutionUnits(this.runNodeEntity);
    }

    @Nullable
    public final Boolean isImmutable() {
        TerminalContextEntity terminalContextEntity = (TerminalContextEntity)EntityAttributeKt.entityOnNonUniqueAttribute((EntityAttribute)((EntityAttribute)TerminalContextEntity.Companion.getRunNodeEntityAttr()), (Object)this.runNodeEntity);
        return terminalContextEntity != null ? Boolean.valueOf(terminalContextEntity.isImmutable()) : null;
    }

    @Nullable
    public final Object setImmutable(boolean isImmutable2, @NotNull Continuation<? super Unit> $completion) {
        TerminalContextEntity terminalContextEntity = (TerminalContextEntity)EntityAttributeKt.entityOnNonUniqueAttribute((EntityAttribute)((EntityAttribute)TerminalContextEntity.Companion.getRunNodeEntityAttr()), (Object)this.runNodeEntity);
        if (terminalContextEntity == null) {
            return Unit.INSTANCE;
        }
        TerminalContextEntity entity2 = terminalContextEntity;
        Object object = TransactorKt.change((Function1)((Function1)new Function1<ChangeScope, Unit>(entity2, isImmutable2){
            final /* synthetic */ TerminalContextEntity $entity;
            final /* synthetic */ boolean $isImmutable;
            {
                this.$entity = $entity;
                this.$isImmutable = $isImmutable;
                super(1);
            }

            public final void invoke(ChangeScope $this$change) {
                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                $this$change.set((Entity)this.$entity, TerminalContextEntity.Companion.getIsImmutableAttr(), (Object)this.$isImmutable);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final StdinCommand buildCommand(String text, boolean append, Map<String, String> meta) {
        String command;
        String string = command = append ? text : (PlatformKt.isWindows((Os)this.os) && this.shellName == ShellName.pwsh ? "\u001b[1;5H" + text : "\u0015\u0015" + text);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new StdinCommand(new Blob(byArray), meta);
    }

    @NotNull
    public final RunNodeEntity component1() {
        return this.runNodeEntity;
    }

    @NotNull
    public final ShellName component2() {
        return this.shellName;
    }

    @NotNull
    public final Os component3() {
        return this.os;
    }

    private final SendChannel<StdinCommand> component4() {
        return this.input;
    }

    @NotNull
    public final TerminalContext copy(@NotNull RunNodeEntity runNodeEntity, @NotNull ShellName shellName, @NotNull Os os2, @NotNull SendChannel<? super StdinCommand> input2) {
        Intrinsics.checkNotNullParameter((Object)runNodeEntity, (String)"runNodeEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)shellName), (String)"shellName");
        Intrinsics.checkNotNullParameter((Object)os2, (String)"os");
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        return new TerminalContext(runNodeEntity, shellName, os2, input2);
    }

    public static /* synthetic */ TerminalContext copy$default(TerminalContext terminalContext2, RunNodeEntity runNodeEntity, ShellName shellName, Os os2, SendChannel sendChannel, int n, Object object) {
        if ((n & 1) != 0) {
            runNodeEntity = terminalContext2.runNodeEntity;
        }
        if ((n & 2) != 0) {
            shellName = terminalContext2.shellName;
        }
        if ((n & 4) != 0) {
            os2 = terminalContext2.os;
        }
        if ((n & 8) != 0) {
            sendChannel = terminalContext2.input;
        }
        return terminalContext2.copy(runNodeEntity, shellName, os2, sendChannel);
    }

    @NotNull
    public String toString() {
        return "TerminalContext(runNodeEntity=" + this.runNodeEntity + ", shellName=" + this.shellName + ", os=" + this.os + ", input=" + this.input + ")";
    }

    public int hashCode() {
        int result = this.runNodeEntity.hashCode();
        result = result * 31 + this.shellName.hashCode();
        result = result * 31 + this.os.hashCode();
        result = result * 31 + this.input.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerminalContext)) {
            return false;
        }
        TerminalContext terminalContext2 = (TerminalContext)other;
        if (!Intrinsics.areEqual((Object)this.runNodeEntity, (Object)terminalContext2.runNodeEntity)) {
            return false;
        }
        if (this.shellName != terminalContext2.shellName) {
            return false;
        }
        if (this.os != terminalContext2.os) {
            return false;
        }
        return Intrinsics.areEqual(this.input, terminalContext2.input);
    }
}

