/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.LegacyEntity;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.api.BackendProgressId;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.HostId;
import fleet.api.ProcessCommand;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.DocumentFileEntity;
import fleet.common.fs.SharedWorkspaceRootEntity;
import fleet.common.topology.HostEntity;
import fleet.common.topology.HostKt;
import fleet.git.common.GitHostService;
import fleet.git.common.SharedRepositoryEntity;
import fleet.git.frontend.GitCommand;
import fleet.git.frontend.GitFilesLayoutKt;
import fleet.git.frontend.GitHead;
import fleet.git.frontend.GitHeadWatcherKt;
import fleet.git.frontend.GitQueueKt;
import fleet.git.frontend.RepositoryCommandsExecutor;
import fleet.git.frontend.RepositoryEntity;
import fleet.git.frontend.RepositoryEntityKt;
import fleet.git.protocol.VcsAuthor;
import fleet.util.UID;
import io.lacuna.bifurcan.Set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u0006\u001a\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012\u001a\u001a\u0010 \u001a\u00020\u0002*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\u001a\u000e\u0010&\u001a\u0004\u0018\u00010'*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0015\u0010\r\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\"\u0018\u0010\u000f\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0004\"!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u00020\u00138F\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001c\"\u0015\u0010\u001d\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\b\u00a8\u0006("}, d2={"belongsToAWorkspaceRoot", "", "Lfleet/git/frontend/RepositoryEntity;", "getBelongsToAWorkspaceRoot", "(Lfleet/git/frontend/RepositoryEntity;)Z", "configPath", "Lfleet/api/FileAddress;", "getConfigPath", "(Lfleet/git/frontend/RepositoryEntity;)Lfleet/api/FileAddress;", "dotGitPath", "getDotGitPath", "headPath", "getHeadPath", "indexPath", "getIndexPath", "locked", "getLocked", "repositories", "", "Lfleet/common/fs/SharedWorkspaceRootEntity;", "getRepositories$annotations", "(Lfleet/common/fs/SharedWorkspaceRootEntity;)V", "getRepositories", "(Lfleet/common/fs/SharedWorkspaceRootEntity;)Ljava/util/Set;", "repository", "getRepository", "(Lfleet/api/FileAddress;)Lfleet/git/frontend/RepositoryEntity;", "Lfleet/common/document/DocumentEntity;", "(Lfleet/common/document/DocumentEntity;)Lfleet/git/frontend/RepositoryEntity;", "worktree", "getWorktree", "findRepository", "RepositoryEntity", "Lcom/jetbrains/rhizomedb/ChangeScope;", "shared", "Lfleet/git/common/SharedRepositoryEntity;", "head", "Lfleet/git/frontend/GitHead;", "hostApi", "Lfleet/git/common/GitHostService;", "fleet.git.frontend"})
@SourceDebugExtension(value={"SMAP\nRepositoryEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryEntity.kt\nfleet/git/frontend/RepositoryEntityKt\n+ 2 Host.kt\nfleet/common/topology/HostKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n+ 5 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n194#2:111\n1603#3,9:112\n1855#3:121\n1856#3:135\n1612#3:136\n766#3:149\n857#3,2:150\n287#4,2:122\n287#4,2:137\n287#4,2:152\n49#5,10:124\n49#5,10:139\n49#5,10:154\n1#6:134\n1#6:164\n*S KotlinDebug\n*F\n+ 1 RepositoryEntity.kt\nfleet/git/frontend/RepositoryEntityKt\n*L\n68#1:111\n81#1:112,9\n81#1:121\n81#1:135\n81#1:136\n102#1:149\n102#1:150,2\n81#1:122,2\n94#1:137,2\n108#1:152,2\n81#1:124,10\n94#1:139,10\n108#1:154,10\n81#1:134\n*E\n"})
public final class RepositoryEntityKt {
    @NotNull
    public static final RepositoryEntity RepositoryEntity(@NotNull ChangeScope $this$RepositoryEntity, @NotNull SharedRepositoryEntity shared, @NotNull GitHead head) {
        Intrinsics.checkNotNullParameter((Object)$this$RepositoryEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shared, (String)"shared");
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        RepositoryEntity repository2 = (RepositoryEntity)ChangeScope.DefaultImpls.new$default((ChangeScope)$this$RepositoryEntity, (KClass)Reflection.getOrCreateKotlinClass(RepositoryEntity.class), (int)0, (Function1)((Function1)new Function1<RepositoryEntity, Unit>(shared, $this$RepositoryEntity, head){
            final /* synthetic */ SharedRepositoryEntity $shared;
            final /* synthetic */ ChangeScope $this_RepositoryEntity;
            final /* synthetic */ GitHead $head;
            {
                this.$shared = $shared;
                this.$this_RepositoryEntity = $receiver;
                this.$head = $head;
                super(1);
            }

            public final void invoke(@NotNull RepositoryEntity $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setShared(this.$shared);
                $this$new.setAuthors((Set<VcsAuthor>)new Set());
                $this$new.setRemotes(CollectionsKt.emptyList());
                $this$new.setHead(GitHeadWatcherKt.createHeadEntity(this.$this_RepositoryEntity, $this$new, this.$head));
            }
        }), (int)2, null);
        Channel queue = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        ChangeScope.DefaultImpls.new$default((ChangeScope)$this$RepositoryEntity, (KClass)Reflection.getOrCreateKotlinClass(RepositoryCommandsExecutor.class), (int)0, (Function1)((Function1)new Function1<RepositoryCommandsExecutor, Unit>(repository2, (Channel<GitCommand>)queue){
            final /* synthetic */ RepositoryEntity $repository;
            final /* synthetic */ Channel<GitCommand> $queue;
            {
                this.$repository = $repository;
                this.$queue = $queue;
                super(1);
            }

            public final void invoke(@NotNull RepositoryCommandsExecutor $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setRepository(this.$repository);
                $this$new.setCommandsQueue(this.$queue);
                $this$new.setLocks((PersistentSet<UID>)ExtensionsKt.persistentHashSetOf());
                $this$new.setControls((PersistentMap<BackendProgressId, ? extends SendChannel<? super ProcessCommand>>)ExtensionsKt.persistentHashMapOf());
            }
        }), (int)2, null);
        return repository2;
    }

    @NotNull
    public static final FileAddress getWorktree(@NotNull RepositoryEntity $this$worktree) {
        Intrinsics.checkNotNullParameter((Object)$this$worktree, (String)"<this>");
        return $this$worktree.getShared().getWorktree();
    }

    @NotNull
    public static final FileAddress getDotGitPath(@NotNull RepositoryEntity $this$dotGitPath) {
        Intrinsics.checkNotNullParameter((Object)$this$dotGitPath, (String)"<this>");
        return $this$dotGitPath.getShared().getDotGitPath();
    }

    @NotNull
    public static final FileAddress getHeadPath(@NotNull RepositoryEntity $this$headPath) {
        Intrinsics.checkNotNullParameter((Object)$this$headPath, (String)"<this>");
        return GitFilesLayoutKt.headPath(RepositoryEntityKt.getDotGitPath($this$headPath));
    }

    @NotNull
    public static final FileAddress getIndexPath(@NotNull RepositoryEntity $this$indexPath) {
        Intrinsics.checkNotNullParameter((Object)$this$indexPath, (String)"<this>");
        return GitFilesLayoutKt.indexPath(RepositoryEntityKt.getDotGitPath($this$indexPath));
    }

    @NotNull
    public static final FileAddress getConfigPath(@NotNull RepositoryEntity $this$configPath) {
        Intrinsics.checkNotNullParameter((Object)$this$configPath, (String)"<this>");
        return GitFilesLayoutKt.configPath(RepositoryEntityKt.getDotGitPath($this$configPath));
    }

    @Nullable
    public static final GitHostService hostApi(@NotNull RepositoryEntity $this$hostApi) {
        GitHostService gitHostService;
        Intrinsics.checkNotNullParameter((Object)$this$hostApi, (String)"<this>");
        HostEntity hostEntity = HostKt.hostOrNull((HostId)RepositoryEntityKt.getWorktree($this$hostApi).getHostId());
        if (hostEntity != null) {
            HostEntity $this$service$iv = hostEntity;
            boolean $i$f$service = false;
            gitHostService = (GitHostService)HostKt.service((HostEntity)$this$service$iv, (KClass)Reflection.getOrCreateKotlinClass(GitHostService.class));
        } else {
            gitHostService = null;
        }
        return gitHostService;
    }

    public static final boolean getLocked(@NotNull RepositoryEntity $this$locked) {
        Intrinsics.checkNotNullParameter((Object)$this$locked, (String)"<this>");
        return GitQueueKt.getBusy(GitQueueKt.getExecutor($this$locked));
    }

    public static final boolean getBelongsToAWorkspaceRoot(@NotNull RepositoryEntity $this$belongsToAWorkspaceRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$belongsToAWorkspaceRoot, (String)"<this>");
        return $this$belongsToAWorkspaceRoot.getShared().getBelongsToWorkspaceRoot();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final java.util.Set<RepositoryEntity> getRepositories(@NotNull SharedWorkspaceRootEntity $this$repositories) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$repositories, (String)"<this>");
        Iterable $this$mapNotNull$iv = SharedRepositoryEntity.Companion.byDiscoverer((Entity)$this$repositories);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RepositoryEntity it$iv$iv;
            void $this$singleOrNullOrThrowWithMessage$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SharedRepositoryEntity shared = (SharedRepositoryEntity)element$iv$iv;
            boolean bl2 = false;
            KMutableProperty1 prop$iv = (KMutableProperty1)repositories.1.1.INSTANCE;
            boolean $i$f$lookupOne = false;
            Iterable iterable2 = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)prop$iv), (Object)shared, (KClass)Reflection.getOrCreateKotlinClass(RepositoryEntity.class));
            boolean $i$f$singleOrNullOrThrowWithMessage = false;
            Object single$iv$iv = null;
            boolean found$iv$iv = false;
            for (Object element$iv$iv2 : $this$singleOrNullOrThrowWithMessage$iv$iv) {
                if (found$iv$iv) {
                    Object t = element$iv$iv2;
                    Object var23_25 = single$iv$iv;
                    boolean bl3 = false;
                    String string = " searched prop " + prop$iv + " and value " + shared;
                    String string2 = "Collection contains more than one matching element: " + var23_25 + ", " + t + " " + string;
                    throw new IllegalArgumentException(string2);
                }
                single$iv$iv = element$iv$iv2;
                found$iv$iv = true;
            }
            if ((RepositoryEntity)((LegacyEntity)single$iv$iv) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ void getRepositories$annotations(SharedWorkspaceRootEntity sharedWorkspaceRootEntity) {
    }

    @Nullable
    public static final RepositoryEntity getRepository(@NotNull DocumentEntity $this$repository) {
        Intrinsics.checkNotNullParameter((Object)$this$repository, (String)"<this>");
        DocumentFileEntity documentFileEntity = DocumentEntityKt.getDocumentFileEntity((DocumentEntity)$this$repository);
        return documentFileEntity != null && (documentFileEntity = documentFileEntity.getCanonicalAddress()) != null ? RepositoryEntityKt.getRepository((FileAddress)documentFileEntity) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RepositoryEntity getRepository(@Nullable FileAddress $this$repository) {
        RepositoryEntity repositoryEntity;
        block7: {
            FileAddress fileAddress = $this$repository;
            if (fileAddress != null && (fileAddress = FileAddressKt.getSelfAndParents((FileAddress)fileAddress)) != null) {
                for (FileAddress it : fileAddress) {
                    RepositoryEntity repositoryEntity2;
                    RepositoryEntity repositoryEntity3;
                    boolean bl = false;
                    if (SharedRepositoryEntity.Companion.byWorktree(it) != null) {
                        void $this$singleOrNullOrThrowWithMessage$iv$iv;
                        SharedRepositoryEntity shared;
                        boolean bl2 = false;
                        KMutableProperty1 prop$iv = (KMutableProperty1)repository.1.1.1.INSTANCE;
                        boolean $i$f$lookupOne = false;
                        Iterable iterable = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)prop$iv), (Object)shared, (KClass)Reflection.getOrCreateKotlinClass(RepositoryEntity.class));
                        boolean $i$f$singleOrNullOrThrowWithMessage = false;
                        Object single$iv$iv = null;
                        boolean found$iv$iv = false;
                        for (Object element$iv$iv : $this$singleOrNullOrThrowWithMessage$iv$iv) {
                            if (found$iv$iv) {
                                Object t = element$iv$iv;
                                Object var15_15 = single$iv$iv;
                                boolean bl3 = false;
                                String string = " searched prop " + prop$iv + " and value " + shared;
                                String string2 = "Collection contains more than one matching element: " + var15_15 + ", " + t + " " + string;
                                throw new IllegalArgumentException(string2);
                            }
                            single$iv$iv = element$iv$iv;
                            found$iv$iv = true;
                        }
                        repositoryEntity3 = (RepositoryEntity)((LegacyEntity)single$iv$iv);
                    } else {
                        repositoryEntity3 = null;
                    }
                    if ((repositoryEntity2 = repositoryEntity3) == null) continue;
                    repositoryEntity = repositoryEntity2;
                    break block7;
                }
                repositoryEntity = null;
            } else {
                repositoryEntity = null;
            }
        }
        return repositoryEntity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final java.util.Set<RepositoryEntity> repositories() {
        void var3_3;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = EntitiesKt.byEntityType((KClass)Reflection.getOrCreateKotlinClass(RepositoryEntity.class));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RepositoryEntity it = (RepositoryEntity)element$iv$iv;
            boolean bl = false;
            if (!RepositoryEntityKt.getBelongsToAWorkspaceRoot(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RepositoryEntity findRepository(@NotNull FileAddress worktree) {
        RepositoryEntity repositoryEntity;
        Intrinsics.checkNotNullParameter((Object)worktree, (String)"worktree");
        SharedRepositoryEntity sharedRepositoryEntity = SharedRepositoryEntity.Companion.byWorktree(worktree);
        if (sharedRepositoryEntity != null) {
            void $this$singleOrNullOrThrowWithMessage$iv$iv;
            SharedRepositoryEntity shared = sharedRepositoryEntity;
            boolean bl = false;
            KMutableProperty1 prop$iv = (KMutableProperty1)findRepository.1.1.INSTANCE;
            boolean $i$f$lookupOne = false;
            Iterable iterable = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)prop$iv), (Object)shared, (KClass)Reflection.getOrCreateKotlinClass(RepositoryEntity.class));
            boolean $i$f$singleOrNullOrThrowWithMessage = false;
            Object single$iv$iv = null;
            boolean found$iv$iv = false;
            for (Object element$iv$iv : $this$singleOrNullOrThrowWithMessage$iv$iv) {
                if (found$iv$iv) {
                    Object t = element$iv$iv;
                    Object var12_14 = single$iv$iv;
                    boolean bl2 = false;
                    String string = " searched prop " + prop$iv + " and value " + shared;
                    String string2 = "Collection contains more than one matching element: " + var12_14 + ", " + t + " " + string;
                    throw new IllegalArgumentException(string2);
                }
                single$iv$iv = element$iv$iv;
                found$iv$iv = true;
            }
            RepositoryEntity repositoryEntity2 = (RepositoryEntity)((LegacyEntity)single$iv$iv);
            if (repositoryEntity2 != null) {
                RepositoryEntity repositoryEntity3;
                RepositoryEntity it = repositoryEntity3 = repositoryEntity2;
                boolean bl3 = false;
                repositoryEntity = RepositoryEntityKt.getBelongsToAWorkspaceRoot(it) ? repositoryEntity3 : null;
            } else {
                repositoryEntity = null;
            }
        } else {
            repositoryEntity = null;
        }
        return repositoryEntity;
    }
}

