/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import com.jetbrains.rhizomedb.Entity;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.compose.theme.components.MenuItem;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.layout.LayoutEntityKt;
import fleet.frontend.layout.ShowOpts;
import fleet.frontend.layout.WindowEntity;
import fleet.frontend.navigation.ViewEntity;
import fleet.frontend.navigation.ViewKt;
import fleet.frontend.ui.gotoPanel.GotoPanelKt;
import fleet.git.frontend.GitBranchCreateNewKt;
import fleet.git.frontend.GitBranchEntity;
import fleet.git.frontend.GitChangesTabLocation;
import fleet.git.frontend.GitCommitEntity;
import fleet.git.frontend.GitDataKeys;
import fleet.git.frontend.GitNavigationKt;
import fleet.git.frontend.GitRefEntity;
import fleet.git.frontend.GitWindowHeaderKt;
import fleet.git.frontend.HeaderData;
import fleet.git.frontend.InProgressOperation;
import fleet.git.frontend.RepositoryEntity;
import fleet.git.frontend.RepositoryEntityKt;
import fleet.kernel.SagaKt;
import fleet.kernel.plugins.PluginScope;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import noria.model.ActionContext;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\r\u000eJ\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lfleet/git/frontend/DiscoveryResult;", "", "address", "Lfleet/api/FileAddress;", "getAddress", "()Lfleet/api/FileAddress;", "toBranchPopupItems", "", "Lfleet/compose/theme/components/MenuItem;", "withAddress", "", "toHeaderData", "Lfleet/git/frontend/HeaderData;", "DiscoveredRepository", "DiscoveryFailed", "Lfleet/git/frontend/DiscoveryResult$DiscoveredRepository;", "Lfleet/git/frontend/DiscoveryResult$DiscoveryFailed;", "fleet.git.frontend"})
interface DiscoveryResult {
    @NotNull
    public FileAddress getAddress();

    @NotNull
    public List<MenuItem> toBranchPopupItems(boolean var1);

    @NotNull
    public HeaderData toHeaderData();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lfleet/git/frontend/DiscoveryResult$DiscoveredRepository;", "Lfleet/git/frontend/DiscoveryResult;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "repository", "Lfleet/git/frontend/RepositoryEntity;", "(Lfleet/kernel/plugins/PluginScope;Lfleet/git/frontend/RepositoryEntity;)V", "address", "Lfleet/api/FileAddress;", "getAddress", "()Lfleet/api/FileAddress;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toBranchPopupItems", "", "Lfleet/compose/theme/components/MenuItem;", "withAddress", "toHeaderData", "Lfleet/git/frontend/HeaderData;", "toString", "", "fleet.git.frontend"})
    public static final class DiscoveredRepository
    implements DiscoveryResult {
        @NotNull
        private final PluginScope pluginScope;
        @NotNull
        private final RepositoryEntity repository;

        public DiscoveredRepository(@NotNull PluginScope pluginScope, @NotNull RepositoryEntity repository2) {
            Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            this.pluginScope = pluginScope;
            this.repository = repository2;
        }

        @Override
        @NotNull
        public FileAddress getAddress() {
            return RepositoryEntityKt.getWorktree(this.repository);
        }

        @Override
        @NotNull
        public List<MenuItem> toBranchPopupItems(boolean withAddress) {
            ArrayList<Object> menuItems = new ArrayList<Object>();
            if (this.repository.getInProgressOperation() != null) {
                if (withAddress) {
                    HeaderData headerData = this.toHeaderData();
                    menuItems.add(new MenuItem.Header(FileAddressKt.getName((FileAddress)RepositoryEntityKt.getWorktree(this.repository)) + ": " + headerData.getTitle(), null, null, null, 14, null));
                }
                menuItems.add(new MenuItem.Action("Resolve Conflicts\u2026", false, null, null, null, null, null, null, null, false, null, false, null, null, (Function1)new Function1<ActionContext, Unit>(this){
                    final /* synthetic */ DiscoveredRepository this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionContext it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Entity[] entityArray = new Entity[]{DiscoveredRepository.access$getRepository$p(this.this$0)};
                        SagaKt.saga$default((CoroutineScope)((CoroutineScope)DiscoveredRepository.access$getPluginScope$p(this.this$0)), (Entity[])entityArray, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ViewEntity<GitChangesTabLocation>>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DiscoveredRepository this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        GitChangesTabLocation.Repository location = new GitChangesTabLocation.Repository(RepositoryEntityKt.getWorktree(DiscoveredRepository.access$getRepository$p(this.this$0)));
                                        WindowEntity windowEntity = LayoutEntityKt.lastFocusedWindow();
                                        this.label = 1;
                                        Object object3 = ViewKt.navigate(GitNavigationKt.getGitChangesTabViewTypeId(), (Object)location, (ShowOpts)new ShowOpts(false, false, false, false, true, false, null, false, null, false, true, null, windowEntity, 3055, null), (Continuation)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ViewEntity<GitChangesTabLocation>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)6, null);
                    }
                }, 16382, null));
            } else {
                if (withAddress) {
                    MenuItem.Header header;
                    GitRefEntity gitRefEntity = this.repository.getHead();
                    if (gitRefEntity instanceof GitCommitEntity) {
                        HeaderData headerData = this.toHeaderData();
                        header = new MenuItem.Header(FileAddressKt.getName((FileAddress)RepositoryEntityKt.getWorktree(this.repository)), headerData.getTooltip(), headerData.getIcon(), null, 8, null);
                    } else if (gitRefEntity instanceof GitBranchEntity) {
                        header = new MenuItem.Header(FileAddressKt.getName((FileAddress)RepositoryEntityKt.getWorktree(this.repository)), null, null, null, 14, null);
                    } else {
                        throw new IllegalStateException("unreachable".toString());
                    }
                    MenuItem.Header header2 = header;
                    menuItems.add(header2);
                }
                menuItems.add(new MenuItem.Action("Create New Branch", false, null, null, null, null, null, null, IconKeys.INSTANCE.getAdd(), false, null, false, null, null, (Function1)new Function1<ActionContext, Unit>(this){
                    final /* synthetic */ DiscoveredRepository this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionContext it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        GotoPanelKt.performGotoPanelAction$default((List)CollectionsKt.listOf((Object)GitBranchCreateNewKt.getGitNewBranchFactoryID()), (PluginScope)DiscoveredRepository.access$getPluginScope$p(this.this$0), (ActionContext)it.put(GitDataKeys.INSTANCE.getRepositoryEntityKey(), (Object)DiscoveredRepository.access$getRepository$p(this.this$0)), null, null, (int)24, null);
                    }
                }, 16126, null));
                menuItems.addAll(GitWindowHeaderKt.access$repositoryBranches(this.pluginScope, this.repository));
            }
            return menuItems;
        }

        @Override
        @NotNull
        public HeaderData toHeaderData() {
            HeaderData headerData;
            if (this.repository.getInProgressOperation() != null) {
                InProgressOperation inProgressOperation = this.repository.getInProgressOperation();
                Intrinsics.checkNotNull((Object)inProgressOperation);
                headerData = GitWindowHeaderKt.access$toHeaderData(inProgressOperation);
            } else {
                GitRefEntity head = this.repository.getHead();
                if (head instanceof GitCommitEntity) {
                    headerData = new HeaderData(head.presentable(), "HEAD detached at " + ((GitCommitEntity)head).getId().getOid(), (ThemeKey<String>)IconKeys.INSTANCE.getWarning());
                } else if (head instanceof GitBranchEntity) {
                    String name = head.presentable();
                    headerData = new HeaderData(name, "Current Branch: " + name, (ThemeKey<String>)IconKeys.Vcs.INSTANCE.getVcs());
                } else {
                    throw new IllegalStateException("unknown HEAD type".toString());
                }
            }
            return headerData;
        }

        private final PluginScope component1() {
            return this.pluginScope;
        }

        private final RepositoryEntity component2() {
            return this.repository;
        }

        @NotNull
        public final DiscoveredRepository copy(@NotNull PluginScope pluginScope, @NotNull RepositoryEntity repository2) {
            Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            return new DiscoveredRepository(pluginScope, repository2);
        }

        public static /* synthetic */ DiscoveredRepository copy$default(DiscoveredRepository discoveredRepository, PluginScope pluginScope, RepositoryEntity repositoryEntity, int n, Object object) {
            if ((n & 1) != 0) {
                pluginScope = discoveredRepository.pluginScope;
            }
            if ((n & 2) != 0) {
                repositoryEntity = discoveredRepository.repository;
            }
            return discoveredRepository.copy(pluginScope, repositoryEntity);
        }

        @NotNull
        public String toString() {
            return "DiscoveredRepository(pluginScope=" + this.pluginScope + ", repository=" + this.repository + ")";
        }

        public int hashCode() {
            int result2 = this.pluginScope.hashCode();
            result2 = result2 * 31 + this.repository.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiscoveredRepository)) {
                return false;
            }
            DiscoveredRepository discoveredRepository = (DiscoveredRepository)other;
            if (!Intrinsics.areEqual((Object)this.pluginScope, (Object)discoveredRepository.pluginScope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repository, (Object)discoveredRepository.repository);
        }

        public static final /* synthetic */ PluginScope access$getPluginScope$p(DiscoveredRepository $this) {
            return $this.pluginScope;
        }

        public static final /* synthetic */ RepositoryEntity access$getRepository$p(DiscoveredRepository $this) {
            return $this.repository;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lfleet/git/frontend/DiscoveryResult$DiscoveryFailed;", "Lfleet/git/frontend/DiscoveryResult;", "address", "Lfleet/api/FileAddress;", "error", "", "(Lfleet/api/FileAddress;Ljava/lang/String;)V", "getAddress", "()Lfleet/api/FileAddress;", "getError", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toBranchPopupItems", "", "Lfleet/compose/theme/components/MenuItem;", "withAddress", "toHeaderData", "Lfleet/git/frontend/HeaderData;", "toString", "fleet.git.frontend"})
    public static final class DiscoveryFailed
    implements DiscoveryResult {
        @NotNull
        private final FileAddress address;
        @Nullable
        private final String error;

        public DiscoveryFailed(@NotNull FileAddress address, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.address = address;
            this.error = error;
        }

        @Override
        @NotNull
        public FileAddress getAddress() {
            return this.address;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @Override
        @NotNull
        public List<MenuItem> toBranchPopupItems(boolean withAddress) {
            List list;
            if (withAddress) {
                HeaderData headerData = this.toHeaderData();
                MenuItem.Header item = new MenuItem.Header(FileAddressKt.getName((FileAddress)this.getAddress()), headerData.getTooltip(), headerData.getIcon(), null, 8, null);
                list = CollectionsKt.listOf((Object)item);
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @Override
        @NotNull
        public HeaderData toHeaderData() {
            String string = this.error;
            if (string == null) {
                string = "Unknown error";
            }
            String tooltip = string;
            return new HeaderData("Failed to detect git", tooltip, (ThemeKey<String>)IconKeys.INSTANCE.getError());
        }

        @NotNull
        public final FileAddress component1() {
            return this.address;
        }

        @Nullable
        public final String component2() {
            return this.error;
        }

        @NotNull
        public final DiscoveryFailed copy(@NotNull FileAddress address, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            return new DiscoveryFailed(address, error);
        }

        public static /* synthetic */ DiscoveryFailed copy$default(DiscoveryFailed discoveryFailed, FileAddress fileAddress, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fileAddress = discoveryFailed.address;
            }
            if ((n & 2) != 0) {
                string = discoveryFailed.error;
            }
            return discoveryFailed.copy(fileAddress, string);
        }

        @NotNull
        public String toString() {
            return "DiscoveryFailed(address=" + this.address + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result2 = this.address.hashCode();
            result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiscoveryFailed)) {
                return false;
            }
            DiscoveryFailed discoveryFailed = (DiscoveryFailed)other;
            if (!Intrinsics.areEqual((Object)this.address, (Object)discoveryFailed.address)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)discoveryFailed.error);
        }
    }
}

