/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.common;

import andel.editor.TextExtKt;
import andel.operation.Op;
import andel.operation.Operation;
import andel.text.Text;
import andel.text.TextLine;
import andel.text.TextLines;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import fleet.diff.common.DiffFragmentReader;
import fleet.diff.common.DiffFragmentType;
import fleet.diff.common.SideBySideDiff;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"toOperation", "Landel/operation/Operation;", "Lfleet/diff/common/SideBySideDiff;", "leftText", "Landel/text/Text;", "rightText", "lineRange", "Landel/text/TextRange;", "lines", "Landel/text/TextLines;", "startLine", "", "lineCount", "fleet.diff.common"})
@SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nfleet/diff/common/OperationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1863#2,2:114\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nfleet/diff/common/OperationKt\n*L\n67#1:114,2\n*E\n"})
public final class OperationKt {
    @NotNull
    public static final Operation toOperation(@NotNull SideBySideDiff $this$toOperation, @NotNull Text leftText, @NotNull Text rightText) {
        Intrinsics.checkNotNullParameter((Object)$this$toOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
        Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
        Pair<DiffFragmentReader, DiffFragmentReader> pair = $this$toOperation.readers(leftText, rightText);
        DiffFragmentReader leftReader = (DiffFragmentReader)pair.component1();
        DiffFragmentReader rightReader = (DiffFragmentReader)pair.component2();
        TextLines rightLines = TextViewExtKt.textLines((TextView)rightText.view(), (boolean)false);
        TextLines leftLines = TextViewExtKt.textLines((TextView)leftText.view(), (boolean)false);
        ArrayList<Op> ops = new ArrayList<Op>();
        Ref.IntRef curLeftLine = new Ref.IntRef();
        Ref.IntRef curRightLine = new Ref.IntRef();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)$this$toOperation.getSize());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            OperationKt.toOperation$flushLinesUpToPosition(leftLines, curLeftLine, rightLines, curRightLine, ops, leftReader.startLine(index), rightReader.startLine(index));
            TextRange leftRange = OperationKt.lineRange(leftLines, leftReader.startLine(index), leftReader.lineCount(index));
            TextRange rightRange = OperationKt.lineRange(rightLines, rightReader.startLine(index), rightReader.lineCount(index));
            if (leftReader.fragmentType(index) == DiffFragmentType.UNCHANGED) {
                if (!(leftRange.getLength() == rightRange.getLength())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (leftRange.getLength() > 0L) {
                    ops.add((Op)new Op.Retain(leftRange.getLength()));
                }
            } else if (leftRange.getLength() > 0L || rightRange.getLength() > 0L) {
                ops.add((Op)new Op.Replace(TextExtKt.substring((Text)leftText, (TextRange)leftRange), TextExtKt.substring((Text)rightText, (TextRange)rightRange)));
            }
            int nextLeftLine = leftReader.startLine(index) + leftReader.lineCount(index);
            int nextRightLine = rightReader.startLine(index) + rightReader.lineCount(index);
            curLeftLine.element = Math.max(curLeftLine.element, nextLeftLine - 1);
            curRightLine.element = Math.max(curRightLine.element, nextRightLine - 1);
            OperationKt.toOperation$setPositionAtLines(curLeftLine, curRightLine, rightLines, leftLines, ops, nextLeftLine, nextRightLine);
        }
        OperationKt.toOperation$flushLinesUpToPosition(leftLines, curLeftLine, rightLines, curRightLine, ops, leftLines.size(), rightLines.size());
        return andel.operation.OperationKt.normalizeSoft((Operation)new Operation((List)ops));
    }

    private static final TextRange lineRange(TextLines lines, int startLine, int lineCount) {
        if (startLine >= lines.size()) {
            if (!(lineCount == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new TextRange(((TextLine)CollectionsKt.last((List)((List)lines))).getToChar(), ((TextLine)CollectionsKt.last((List)((List)lines))).getToChar());
        }
        long from = ((TextLine)lines.get(startLine)).getFromChar();
        long to = lineCount == 0 ? from : ((TextLine)lines.get(startLine + lineCount - 1)).getToChar();
        return new TextRange(from, to);
    }

    /*
     * Unable to fully structure code
     */
    private static final void toOperation$setPositionAtLines(Ref.IntRef curLeftLine, Ref.IntRef curRightLine, TextLines rightLines, TextLines leftLines, ArrayList<Op> ops, int leftStart, int rightStart) {
        v0 = curLeftLine.element <= leftStart ? leftStart <= curLeftLine.element + 1 : false;
        if (!v0) ** GOTO lbl-1000
        v1 = curRightLine.element <= rightStart ? rightStart <= curRightLine.element + 1 : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            var8_7 = "Check failed.";
            throw new IllegalStateException(var8_7.toString());
        }
        newLineAtRight = rightStart > curRightLine.element && rightStart != rightLines.size();
        newLineAtLeft = leftStart > curLeftLine.element && leftStart != leftLines.size();
        if (newLineAtLeft && newLineAtRight) {
            ops.add((Op)new Op.Retain(1L));
        } else if (newLineAtLeft) {
            ops.add((Op)new Op.Replace("\n", ""));
        } else if (newLineAtRight) {
            ops.add((Op)new Op.Replace("", "\n"));
        }
        curLeftLine.element = leftStart;
        curRightLine.element = rightStart;
    }

    private static final void toOperation$flushLinesUpToPosition(TextLines leftLines, Ref.IntRef curLeftLine, TextLines rightLines, Ref.IntRef curRightLine, ArrayList<Op> ops, int leftStart, int rightStart) {
        TextRange leftRange = OperationKt.lineRange(leftLines, curLeftLine.element, leftStart - curLeftLine.element);
        TextRange rightRange = OperationKt.lineRange(rightLines, curRightLine.element, rightStart - curRightLine.element);
        if (!(leftRange.getLength() == rightRange.getLength())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (leftRange.getLength() > 0L) {
            ops.add((Op)new Op.Retain(leftRange.getLength()));
        }
        curLeftLine.element = Math.max(curLeftLine.element, leftStart - 1);
        curRightLine.element = Math.max(curRightLine.element, rightStart - 1);
        OperationKt.toOperation$setPositionAtLines(curLeftLine, curRightLine, rightLines, leftLines, ops, leftStart, rightStart);
    }
}

