/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.common;

import andel.text.LineEnding;
import andel.text.TextRange;
import fleet.diff.common.LineTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016J\u0013\u0010\u001f\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lfleet/diff/common/FileText;", "", "text", "", "<init>", "(Ljava/lang/CharSequence;)V", "getText", "()Ljava/lang/CharSequence;", "lines", "", "Lfleet/diff/common/FileText$Line;", "getLines", "()Ljava/util/List;", "lineEnding", "Landel/text/LineEnding;", "getLineEnding$fleet_diff_common", "()Landel/text/LineEnding;", "isEmpty", "", "isEmpty$fleet_diff_common", "()Z", "fromLine", "", "toLine", "getText$fleet_diff_common", "getLine", "i", "getLineSafe", "getLineSafe$fleet_diff_common", "offsetToLine", "offset", "equals", "other", "hashCode", "Line", "Companion", "fleet.diff.common"})
public final class FileText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence text;
    @NotNull
    private final List<Line> lines;
    @Nullable
    private final LineEnding lineEnding;
    private final boolean isEmpty;
    @NotNull
    private static final FileText Empty = new FileText("");

    public FileText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        ArrayList<Line> lines = new ArrayList<Line>(this.text.length() / 36);
        LineTokenizer lineTokenizer = new LineTokenizer(this.text);
        LineEnding lastLineSeparator = null;
        HashSet<LineEnding> lineSeparators = new HashSet<LineEnding>();
        while (!lineTokenizer.getAtEnd()) {
            int start = lineTokenizer.getOffset();
            int end = start + lineTokenizer.getLength();
            lines.add(new Line(this, lines.size(), start, end));
            lastLineSeparator = lineTokenizer.getLineSeparator();
            if (lastLineSeparator != null) {
                lineSeparators.add(lastLineSeparator);
            }
            lineTokenizer.advance();
        }
        if (lines.size() > 0 && lastLineSeparator != null) {
            lines.add(new Line(this, lines.size(), this.text.length(), this.text.length()));
        }
        this.lines = lines;
        this.lineEnding = (LineEnding)CollectionsKt.singleOrNull((Iterable)lineSeparators);
        this.isEmpty = this.text.length() == 0;
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    @NotNull
    public final List<Line> getLines() {
        return this.lines;
    }

    @Nullable
    public final LineEnding getLineEnding$fleet_diff_common() {
        return this.lineEnding;
    }

    public final boolean isEmpty$fleet_diff_common() {
        return this.isEmpty;
    }

    @NotNull
    public final CharSequence getText$fleet_diff_common(int fromLine, int toLine) {
        if (!(fromLine >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(toLine <= this.lines.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(fromLine < toLine)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.text.subSequence(this.lines.get(fromLine).getStart(), this.lines.get(toLine - 1).getEnd());
    }

    @NotNull
    public final Line getLine(int i) {
        if (i >= this.lines.size()) {
            return new Line(this, i, this.text.length(), this.text.length());
        }
        return this.lines.get(i);
    }

    @Nullable
    public final Line getLineSafe$fleet_diff_common(int i) {
        if (i < 0 || i >= this.lines.size()) {
            return null;
        }
        return this.lines.get(i);
    }

    public final int offsetToLine(int offset) {
        if (this.lines.isEmpty()) {
            return 0;
        }
        int low = 0;
        int high = this.lines.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Line line = this.lines.get(mid);
            if (line.getEnd() < offset) {
                low = mid + 1;
                continue;
            }
            if (offset < line.getStart()) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return this.lines.size() - 1;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileText)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)((FileText)other).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lfleet/diff/common/FileText$Companion;", "", "<init>", "()V", "Empty", "Lfleet/diff/common/FileText;", "getEmpty", "()Lfleet/diff/common/FileText;", "fleet.diff.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileText getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0015J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0015J\b\u0010!\u001a\u00020\u0005H\u0016J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0018J\b\u0010%\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006&"}, d2={"Lfleet/diff/common/FileText$Line;", "", "file", "Lfleet/diff/common/FileText;", "lineNumber", "", "start", "end", "<init>", "(Lfleet/diff/common/FileText;III)V", "getLineNumber", "()I", "getStart", "getEnd", "fileText", "", "getFileText", "()Ljava/lang/CharSequence;", "lineText", "getLineText", "isEmptyOrBlank", "", "()Z", "range", "Landel/text/TextRange;", "getRange", "()Landel/text/TextRange;", "length", "getLength", "equals", "other", "line", "ignoreWhiteSpaces", "hashCode", "subStr", "", "textRange", "toString", "fleet.diff.common"})
    @SourceDebugExtension(value={"SMAP\nFileText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileText.kt\nfleet/diff/common/FileText$Line\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1734#2,3:229\n*S KotlinDebug\n*F\n+ 1 FileText.kt\nfleet/diff/common/FileText$Line\n*L\n95#1:229,3\n*E\n"})
    public static final class Line {
        @NotNull
        private final FileText file;
        private final int lineNumber;
        private final int start;
        private final int end;

        public Line(@NotNull FileText file, int lineNumber, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.lineNumber = lineNumber;
            this.start = start;
            this.end = end;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        private final CharSequence getFileText() {
            return this.file.getText();
        }

        @NotNull
        public final CharSequence getLineText() {
            return this.getFileText().subSequence(this.start, this.end);
        }

        public final boolean isEmptyOrBlank() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = (Iterable)RangesKt.until((int)this.start, (int)this.end);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (CharsKt.isWhitespace((char)this.getFileText().charAt(it))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public final TextRange getRange() {
            return new TextRange((long)this.start, (long)this.end);
        }

        public final int getLength() {
            return this.end - this.start;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Line)) {
                return false;
            }
            return this.equals((Line)other, false);
        }

        public final boolean equals(@NotNull Line line, boolean ignoreWhiteSpaces) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            CharSequence fti = this.getFileText();
            CharSequence ftj = line.getFileText();
            if (ignoreWhiteSpaces) {
                int i = this.start;
                for (int j = line.start; i < this.end || j < line.end; ++i, ++j) {
                    while (i < this.end && CharsKt.isWhitespace((char)fti.charAt(i))) {
                        ++i;
                    }
                    while (j < line.end && CharsKt.isWhitespace((char)ftj.charAt(j))) {
                        ++j;
                    }
                    if (i < this.end && j < line.end && fti.charAt(i) != ftj.charAt(j)) {
                        return false;
                    }
                    if ((i != this.end || j >= line.end) && (i >= this.end || j != line.end)) continue;
                    return false;
                }
            } else {
                if (this.end - this.start != line.end - line.start) {
                    return false;
                }
                int i = this.start;
                for (int j = line.start; i < this.end && j < line.end; ++i, ++j) {
                    if (fti.charAt(i) == ftj.charAt(j)) continue;
                    return false;
                }
            }
            return true;
        }

        public final int hashCode(boolean ignoreWhiteSpaces) {
            int hashCode = 0;
            CharSequence ft = this.getFileText();
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                char ch = ft.charAt(i);
                if (ignoreWhiteSpaces && CharsKt.isWhitespace((char)ch)) continue;
                hashCode = hashCode * 19 + ch * 17;
            }
            return hashCode;
        }

        public int hashCode() {
            return this.hashCode(false);
        }

        @NotNull
        public final String subStr(@NotNull TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            if (!(textRange.getStart() >= 0L && textRange.getEnd() <= (long)this.getLength())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return ((Object)this.getFileText().subSequence(this.start + (int)textRange.getStart(), this.start + (int)textRange.getEnd())).toString();
        }

        @NotNull
        public String toString() {
            return ((Object)this.getLineText()).toString();
        }
    }
}

