/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.code.snippets;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlParser;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.api.workspace.document.LanguageId;
import fleet.common.document.EditorEntity;
import fleet.frontend.code.snippets.ExternalSnippetsProvider;
import fleet.frontend.code.snippets.ExternalSnippetsProviderEntity;
import fleet.frontend.code.snippets.SnippetDescriptor;
import fleet.frontend.code.snippets.SnippetDescriptorKt;
import fleet.frontend.code.snippets.SnippetsEntity;
import fleet.kernel.plugins.ContributionScope;
import fleet.util.logging.KLogger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u001e\u0010\u0000\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00060\u0005\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a&\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\b*\u0004\u0018\u00010\u0019H\u0002\u001a \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\u0006\u0010\u001b\u001a\u00020\u001c\"\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"snippets", "", "Lfleet/kernel/plugins/ContributionScope;", "languageId", "Lfleet/api/workspace/document/LanguageId;", "Lkotlin/Function0;", "", "", "", "Lfleet/frontend/code/snippets/SnippetDescriptor;", "externalSnippetsProvider", "provider", "Lfleet/frontend/code/snippets/ExternalSnippetsProvider;", "snippetsByLanguage", "availableExternalSnippetsProvider", "editorEntity", "Lfleet/common/document/EditorEntity;", "lineTextUpToCaret", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "asListOfStrings", "", "readSnippetsFromToml", "inputStream", "Ljava/io/InputStream;", "fleet.code.frontend"})
@SourceDebugExtension(value={"SMAP\nSnippetDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnippetDescriptor.kt\nfleet/frontend/code/snippets/SnippetDescriptorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,134:1\n1#2:135\n1#2:158\n1557#3:136\n1628#3,3:137\n295#3,2:140\n1611#3,9:146\n1863#3:155\n1864#3:159\n1620#3:160\n1485#3:161\n1510#3,3:162\n1513#3,3:172\n1246#3,2:177\n1053#3:179\n1249#3:180\n18#4,2:142\n38#4,2:144\n38#4,2:156\n38#4,2:181\n381#5,7:165\n462#5:175\n412#5:176\n*S KotlinDebug\n*F\n+ 1 SnippetDescriptor.kt\nfleet/frontend/code/snippets/SnippetDescriptorKt\n*L\n76#1:158\n35#1:136\n35#1:137,3\n35#1:140,2\n76#1:146,9\n76#1:155\n76#1:159\n76#1:160\n88#1:161\n88#1:162,3\n88#1:172,3\n89#1:177,2\n90#1:179\n89#1:180\n60#1:142,2\n66#1:144,2\n85#1:156,2\n94#1:181,2\n88#1:165,7\n89#1:175\n89#1:176\n*E\n"})
public final class SnippetDescriptorKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    public static final void snippets(@NotNull ContributionScope $this$snippets, @NotNull LanguageId languageId, @NotNull Function0<? extends Map<String, ? extends List<SnippetDescriptor>>> snippets) {
        Intrinsics.checkNotNullParameter((Object)$this$snippets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter(snippets, (String)"snippets");
        $this$snippets.new((EntityType)SnippetsEntity.Companion, arg_0 -> SnippetDescriptorKt.snippets$lambda$0(languageId, snippets, arg_0));
    }

    public static final void externalSnippetsProvider(@NotNull ContributionScope $this$externalSnippetsProvider, @NotNull ExternalSnippetsProvider provider) {
        Intrinsics.checkNotNullParameter((Object)$this$externalSnippetsProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        $this$externalSnippetsProvider.new((EntityType)ExternalSnippetsProviderEntity.Companion, arg_0 -> SnippetDescriptorKt.externalSnippetsProvider$lambda$1(provider, arg_0));
    }

    @Nullable
    public static final Map<String, List<SnippetDescriptor>> snippetsByLanguage(@Nullable LanguageId languageId) {
        Map<String, List<SnippetDescriptor>> map2;
        LanguageId languageId2 = languageId;
        if (languageId2 != null) {
            LanguageId it = languageId2;
            boolean bl = false;
            SnippetsEntity snippetsEntity = (SnippetsEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)SnippetsEntity.Companion.getLanguageIdAttr()), (Object)it);
            map2 = snippetsEntity != null ? snippetsEntity.getSnippets() : null;
        } else {
            map2 = null;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ExternalSnippetsProvider availableExternalSnippetsProvider(@NotNull EditorEntity editorEntity, @NotNull String lineTextUpToCaret) {
        Object v0;
        block2: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)editorEntity, (String)"editorEntity");
            Intrinsics.checkNotNullParameter((Object)lineTextUpToCaret, (String)"lineTextUpToCaret");
            Iterable $this$map$iv = ExternalSnippetsProviderEntity.Companion.all();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExternalSnippetsProviderEntity externalSnippetsProviderEntity = (ExternalSnippetsProviderEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getProvider());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ExternalSnippetsProvider it = (ExternalSnippetsProvider)element$iv;
                boolean bl = false;
                if (!it.isAvailable(editorEntity, lineTextUpToCaret)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    private static final List<String> asListOfStrings(Object $this$asListOfStrings) {
        Object object;
        try {
            List list;
            object = $this$asListOfStrings;
            if (object instanceof List) {
                Object object2 = $this$asListOfStrings;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                list = (List)object2;
            } else if (object instanceof String) {
                list = CollectionsKt.listOf((Object)$this$asListOfStrings);
            } else {
                KLogger this_$iv = SnippetDescriptorKt.getLogger();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    kLogger.warn((Object)("Can't convert " + $this$asListOfStrings + " into a list of strings"));
                }
                list = CollectionsKt.emptyList();
            }
            object = list;
        }
        catch (Exception e) {
            KLogger this_$iv = SnippetDescriptorKt.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Can't convert " + $this$asListOfStrings + " into a list of strings";
                kLogger.warn(throwable, (Object)string);
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<SnippetDescriptor>> readSnippetsFromToml(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Object object = inputStream;
        Charset charset = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)object, charset);
        int n = 8192;
        String content = TextStreamsKt.readText((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)));
        try {
            void $this$mapValuesTo$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Set set = ((CommentedConfig)new TomlParser().parse(content)).entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            object2 = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Map it$iv$iv;
                Object map2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                CommentedConfig.Entry e = (CommentedConfig.Entry)element$iv$iv;
                boolean bl2 = false;
                try {
                    map2 = ((Config)e.getValue()).valueMap();
                    String string = (String)CollectionsKt.firstOrNull(SnippetDescriptorKt.asListOfStrings(map2.get("prefix")));
                    if (string == null) {
                        string = "";
                    }
                    String string2 = CollectionsKt.joinToString$default((Iterable)SnippetDescriptorKt.asListOfStrings(map2.get("body")), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    String string3 = e.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
                    map2 = new SnippetDescriptor(string, string2, string3, (String)map2.get("description"), false, 16, null);
                }
                catch (Exception e2) {
                    KLogger this_$iv = SnippetDescriptorKt.getLogger();
                    boolean $i$f$warn = false;
                    if (this_$iv.isWarnEnabled()) {
                        Throwable throwable = e2;
                        KLogger kLogger = this_$iv;
                        boolean bl3 = false;
                        String string = "Can't parse snippets";
                        kLogger.warn(throwable, (Object)string);
                    }
                    map2 = null;
                }
                if (map2 == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            $this$forEach$iv$iv$iv = $this$groupByTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object object3;
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                SnippetDescriptor it = (SnippetDescriptor)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getPrefix();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Object object5 = object4;
                boolean bl6 = false;
                List values = (List)entry.getValue();
                Iterable $this$sortedBy$iv = values;
                boolean $i$f$sortedBy = false;
                List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SnippetDescriptor it = (SnippetDescriptor)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getKey());
                        it = (SnippetDescriptor)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey())));
                    }
                });
                object5.put(k, list);
            }
            object = destination$iv$iv;
        }
        catch (ParsingException e) {
            KLogger this_$iv = SnippetDescriptorKt.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Can't parse snippets";
                kLogger.warn(throwable, (Object)string);
            }
            return MapsKt.emptyMap();
        }
        return object;
    }

    private static final void snippets$lambda$0(LanguageId $languageId, Function0 $snippets, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(SnippetsEntity.Companion.getLanguageIdAttr(), (Object)$languageId);
        it.set(SnippetsEntity.Companion.getSnippetsAttr(), $snippets.invoke());
    }

    private static final void externalSnippetsProvider$lambda$1(ExternalSnippetsProvider $provider, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(ExternalSnippetsProviderEntity.Companion.getProviderAttr(), (Object)$provider);
    }
}

