/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.test.parsers.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.research.testspark.core.data.JUnitVersion;
import org.jetbrains.research.testspark.core.test.data.TestCaseGeneratedByLLM;
import org.jetbrains.research.testspark.core.test.data.TestSuiteGeneratedByLLM;
import org.jetbrains.research.testspark.core.test.parsers.TestSuiteParser;
import org.jetbrains.research.testspark.core.test.parsers.java.JUnitTestCaseParser;
import org.jetbrains.research.testspark.core.test.parsers.java.JUnitTestSuiteParser;
import org.jetbrains.research.testspark.core.test.parsers.java.TestCaseParseResult;
import org.jetbrains.research.testspark.core.utils.PatternsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/research/testspark/core/test/parsers/java/JUnitTestSuiteParser;", "Lorg/jetbrains/research/testspark/core/test/parsers/TestSuiteParser;", "packageName", "", "junitVersion", "Lorg/jetbrains/research/testspark/core/data/JUnitVersion;", "(Ljava/lang/String;Lorg/jetbrains/research/testspark/core/data/JUnitVersion;)V", "parseTestSuite", "Lorg/jetbrains/research/testspark/core/test/data/TestSuiteGeneratedByLLM;", "rawText", "core"})
@SourceDebugExtension(value={"SMAP\nJUnitTestSuiteParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitTestSuiteParser.kt\norg/jetbrains/research/testspark/core/test/parsers/java/JUnitTestSuiteParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1#2:176\n1855#3,2:177\n*S KotlinDebug\n*F\n+ 1 JUnitTestSuiteParser.kt\norg/jetbrains/research/testspark/core/test/parsers/java/JUnitTestSuiteParser\n*L\n49#1:177,2\n*E\n"})
public final class JUnitTestSuiteParser
implements TestSuiteParser {
    @NotNull
    private final String packageName;
    @NotNull
    private final JUnitVersion junitVersion;

    public JUnitTestSuiteParser(@NotNull String packageName, @NotNull JUnitVersion junitVersion) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)((Object)junitVersion), (String)"junitVersion");
        this.packageName = packageName;
        this.junitVersion = junitVersion;
    }

    @Override
    @Nullable
    public TestSuiteGeneratedByLLM parseTestSuite(@NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        if (StringsKt.isBlank((CharSequence)rawText)) {
            return null;
        }
        try {
            CharSequence charSequence;
            String rawCode = rawText;
            if (StringsKt.contains$default((CharSequence)rawText, (CharSequence)"```", (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{"```"};
                rawCode = (String)StringsKt.split$default((CharSequence)rawText, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            }
            Set imports2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)PatternsKt.getImportPattern().findAll((CharSequence)rawCode, 0), (Function1)parseTestSuite.imports.1.INSTANCE));
            String string = this.junitVersion.getRunWithAnnotationMeta().extract(rawCode);
            if (string == null) {
                string = "";
            }
            String runWith = string;
            String[] stringArray = new String[]{"@Test"};
            List testSet = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)rawCode, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            JUnitTestSuiteParser $this$parseTestSuite_u24lambda_u241 = this;
            boolean bl = false;
            String[] stringArray2 = new String[]{"public class"};
            CharSequence charSequence2 = (CharSequence)StringsKt.split$default((CharSequence)((CharSequence)testSet.remove(0)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(1);
            stringArray2 = new String[]{"{"};
            List otherInfoList = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)charSequence2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            CollectionsKt.removeFirst((List)otherInfoList);
            String otherInfo = ((Object)StringsKt.trimEnd((CharSequence)CollectionsKt.joinToString$default((Iterable)otherInfoList, (CharSequence)"{", null, null, (int)0, null, null, (int)62, null))).toString() + "\n\n";
            CharSequence charSequence3 = otherInfo;
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                boolean bl2 = false;
                charSequence = "";
            } else {
                charSequence = charSequence3;
            }
            String otherInfo2 = (String)charSequence;
            List testCases = new ArrayList();
            JUnitTestCaseParser testCaseParser = new JUnitTestCaseParser();
            Iterable $this$forEach$iv = testSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestCaseGeneratedByLLM currentTest;
                boolean isLastTestCaseInTestSuite;
                String it = (String)element$iv;
                boolean bl3 = false;
                String rawTest = "@Test" + it;
                TestCaseParseResult result = testCaseParser.parse(rawTest, isLastTestCaseInTestSuite = testCases.size() == testSet.size() - 1);
                if (result.getErrorOccurred()) {
                    System.out.println((Object)("WARNING: " + result.getErrorMessage()));
                    continue;
                }
                Intrinsics.checkNotNull((Object)result.getTestCase());
                System.out.println((Object)("New test case: " + currentTest));
                testCases.add(currentTest);
            }
            TestSuiteGeneratedByLLM testSuite = new TestSuiteGeneratedByLLM(imports2, this.packageName, runWith, otherInfo2, testCases);
            return testSuite;
        }
        catch (Exception e) {
            return null;
        }
    }
}

