/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.test;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.research.testspark.core.test.TestCasesCompilationResult;
import org.jetbrains.research.testspark.core.test.TestCompiler;
import org.jetbrains.research.testspark.core.test.data.TestCaseGeneratedByLLM;
import org.jetbrains.research.testspark.core.utils.CommandLineRunner;
import org.jetbrains.research.testspark.core.utils.DataFilesUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J*\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/research/testspark/core/test/TestCompiler;", "", "javaHomeDirectoryPath", "", "libPaths", "", "junitLibPaths", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "compileCode", "Lkotlin/Pair;", "", "path", "projectBuildPath", "compileTestCases", "Lorg/jetbrains/research/testspark/core/test/TestCasesCompilationResult;", "generatedTestCasesPaths", "buildPath", "testCases", "", "Lorg/jetbrains/research/testspark/core/test/data/TestCaseGeneratedByLLM;", "getPath", "core"})
public class TestCompiler {
    @NotNull
    private final String javaHomeDirectoryPath;
    @NotNull
    private final List<String> libPaths;
    @NotNull
    private final List<String> junitLibPaths;
    @NotNull
    private final KLogger log;

    public TestCompiler(@NotNull String javaHomeDirectoryPath, @NotNull List<String> libPaths, @NotNull List<String> junitLibPaths) {
        Intrinsics.checkNotNullParameter((Object)javaHomeDirectoryPath, (String)"javaHomeDirectoryPath");
        Intrinsics.checkNotNullParameter(libPaths, (String)"libPaths");
        Intrinsics.checkNotNullParameter(junitLibPaths, (String)"junitLibPaths");
        this.javaHomeDirectoryPath = javaHomeDirectoryPath;
        this.libPaths = libPaths;
        this.junitLibPaths = junitLibPaths;
        this.log = KotlinLogging.INSTANCE.logger((Function0)new Function0<Unit>(this){
            final /* synthetic */ TestCompiler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getClass();
            }
        });
    }

    @NotNull
    public final TestCasesCompilationResult compileTestCases(@NotNull List<String> generatedTestCasesPaths, @NotNull String buildPath, @NotNull List<TestCaseGeneratedByLLM> testCases) {
        Intrinsics.checkNotNullParameter(generatedTestCasesPaths, (String)"generatedTestCasesPaths");
        Intrinsics.checkNotNullParameter((Object)buildPath, (String)"buildPath");
        Intrinsics.checkNotNullParameter(testCases, (String)"testCases");
        boolean allTestCasesCompilable = true;
        Set compilableTestCases = new LinkedHashSet();
        int n = generatedTestCasesPaths.size();
        for (int index = 0; index < n; ++index) {
            boolean compilable = (Boolean)this.compileCode(generatedTestCasesPaths.get(index), buildPath).getFirst();
            boolean bl = allTestCasesCompilable = allTestCasesCompilable && compilable;
            if (!compilable) continue;
            compilableTestCases.add(testCases.get(index));
        }
        return new TestCasesCompilationResult(allTestCasesCompilable, compilableTestCases);
    }

    @NotNull
    public final Pair<Boolean, String> compileCode(@NotNull String path, @NotNull String projectBuildPath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)projectBuildPath, (String)"projectBuildPath");
        File javaCompile2 = (File)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)new File(this.javaHomeDirectoryPath), null, (int)1, null)), (Function1)compileCode.javaCompile.1.INSTANCE));
        if (javaCompile2 == null) {
            String msg = "Cannot find java compiler 'javac' at '" + this.javaHomeDirectoryPath + "'";
            this.log.error((Function0)new Function0<Object>(msg){
                final /* synthetic */ String $msg;
                {
                    this.$msg = $msg;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$msg;
                }
            });
            throw new RuntimeException(msg);
        }
        System.out.println((Object)("javac found at '" + javaCompile2.getAbsolutePath() + "'"));
        Object[] objectArray = new String[4];
        Intrinsics.checkNotNullExpressionValue((Object)javaCompile2.getAbsolutePath(), (String)"getAbsolutePath(...)");
        objectArray[1] = "-cp";
        objectArray[2] = "\"" + this.getPath(projectBuildPath) + "\"";
        objectArray[3] = path;
        String errorMsg = CommandLineRunner.Companion.run(CollectionsKt.arrayListOf((Object[])objectArray));
        this.log.info((Function0)new Function0<Object>(errorMsg){
            final /* synthetic */ String $errorMsg;
            {
                this.$errorMsg = $errorMsg;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Error message: '" + this.$errorMsg + "'";
            }
        });
        String classFilePath = StringsKt.replace$default((String)path, (String)".java", (String)".class", (boolean)false, (int)4, null);
        return new Pair((Object)new File(classFilePath).exists(), (Object)errorMsg);
    }

    @NotNull
    public final String getPath(@NotNull String buildPath) {
        Intrinsics.checkNotNullParameter((Object)buildPath, (String)"buildPath");
        char separator = DataFilesUtil.Companion.getClasspathSeparator();
        String dependencyLibPath = CollectionsKt.joinToString$default((Iterable)this.libPaths, (CharSequence)String.valueOf(separator), null, null, (int)0, null, null, (int)62, null);
        String junitPath = CollectionsKt.joinToString$default((Iterable)this.junitLibPaths, (CharSequence)String.valueOf(separator), null, null, (int)0, null, null, (int)62, null);
        String path = junitPath + separator + dependencyLibPath + separator + buildPath;
        System.out.println((Object)("[TestCompiler]: the path is: " + path));
        return path;
    }
}

