/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.generation.llm.prompt;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tj\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/research/testspark/core/generation/llm/prompt/PromptKeyword;", "", "text", "", "description", "mandatory", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Z)V", "getDescription", "()Ljava/lang/String;", "getMandatory", "()Z", "getText", "variable", "getVariable", "getOffsets", "Lkotlin/Pair;", "", "prompt", "NAME", "CODE", "LANGUAGE", "TESTING_PLATFORM", "MOCKING_FRAMEWORK", "METHODS", "POLYMORPHISM", "TEST_SAMPLE", "core"})
public final class PromptKeyword
extends Enum<PromptKeyword> {
    @NotNull
    private final String text;
    @NotNull
    private final String description;
    private final boolean mandatory;
    public static final /* enum */ PromptKeyword NAME = new PromptKeyword("NAME", "The name of the code under test (Class name, method name, line number)", true);
    public static final /* enum */ PromptKeyword CODE = new PromptKeyword("CODE", "The code under test (Class, method, or line)", true);
    public static final /* enum */ PromptKeyword LANGUAGE = new PromptKeyword("LANGUAGE", "Programming language of the project under test (only Java supported at this point)", true);
    public static final /* enum */ PromptKeyword TESTING_PLATFORM = new PromptKeyword("TESTING_PLATFORM", "Testing platform used in the project (Only JUnit 4 is supported at this point)", true);
    public static final /* enum */ PromptKeyword MOCKING_FRAMEWORK = new PromptKeyword("MOCKING_FRAMEWORK", "Mock framework that can be used in generated test (Only Mockito is supported at this point)", false);
    public static final /* enum */ PromptKeyword METHODS = new PromptKeyword("METHODS", "Signature of methods used in the code under tests", false);
    public static final /* enum */ PromptKeyword POLYMORPHISM = new PromptKeyword("POLYMORPHISM", "Polymorphism relations between classes involved in the code under test", false);
    public static final /* enum */ PromptKeyword TEST_SAMPLE = new PromptKeyword("TEST_SAMPLE", "Test samples for LLM for test generation", false);
    private static final /* synthetic */ PromptKeyword[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PromptKeyword(String text, String description, boolean mandatory) {
        this.text = text;
        this.description = description;
        this.mandatory = mandatory;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final boolean getMandatory() {
        return this.mandatory;
    }

    @Nullable
    public final Pair<Integer, Integer> getOffsets(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String textToHighlight = "$" + this.text;
        if (!StringsKt.contains$default((CharSequence)prompt, (CharSequence)textToHighlight, (boolean)false, (int)2, null)) {
            return null;
        }
        int startOffset = StringsKt.indexOf$default((CharSequence)prompt, (String)textToHighlight, (int)0, (boolean)false, (int)6, null);
        int endOffset = startOffset + textToHighlight.length();
        return new Pair((Object)startOffset, (Object)endOffset);
    }

    @NotNull
    public final String getVariable() {
        return "$" + this.text;
    }

    public static PromptKeyword[] values() {
        return (PromptKeyword[])$VALUES.clone();
    }

    public static PromptKeyword valueOf(String value) {
        return Enum.valueOf(PromptKeyword.class, value);
    }

    @NotNull
    public static EnumEntries<PromptKeyword> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = promptKeywordArray = new PromptKeyword[]{PromptKeyword.NAME, PromptKeyword.CODE, PromptKeyword.LANGUAGE, PromptKeyword.TESTING_PLATFORM, PromptKeyword.MOCKING_FRAMEWORK, PromptKeyword.METHODS, PromptKeyword.POLYMORPHISM, PromptKeyword.TEST_SAMPLE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

