/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.generation.llm.prompt;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.testspark.core.generation.llm.prompt.PromptBuilder;
import org.jetbrains.research.testspark.core.generation.llm.prompt.configuration.ClassRepresentation;
import org.jetbrains.research.testspark.core.generation.llm.prompt.configuration.MethodRepresentation;
import org.jetbrains.research.testspark.core.generation.llm.prompt.configuration.PromptGenerationContext;
import org.jetbrains.research.testspark.core.generation.llm.prompt.configuration.PromptTemplates;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bJ,\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bJ$\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/research/testspark/core/generation/llm/prompt/PromptGenerator;", "", "context", "Lorg/jetbrains/research/testspark/core/generation/llm/prompt/configuration/PromptGenerationContext;", "promptTemplates", "Lorg/jetbrains/research/testspark/core/generation/llm/prompt/configuration/PromptTemplates;", "(Lorg/jetbrains/research/testspark/core/generation/llm/prompt/configuration/PromptGenerationContext;Lorg/jetbrains/research/testspark/core/generation/llm/prompt/configuration/PromptTemplates;)V", "generatePromptForClass", "", "interestingClasses", "", "Lorg/jetbrains/research/testspark/core/generation/llm/prompt/configuration/ClassRepresentation;", "testSamplesCode", "generatePromptForLine", "lineUnderTest", "method", "Lorg/jetbrains/research/testspark/core/generation/llm/prompt/configuration/MethodRepresentation;", "interestingClassesFromMethod", "generatePromptForMethod", "core"})
public final class PromptGenerator {
    @NotNull
    private final PromptGenerationContext context;
    @NotNull
    private final PromptTemplates promptTemplates;

    public PromptGenerator(@NotNull PromptGenerationContext context, @NotNull PromptTemplates promptTemplates) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)promptTemplates, (String)"promptTemplates");
        this.context = context;
        this.promptTemplates = promptTemplates;
    }

    @NotNull
    public final String generatePromptForClass(@NotNull List<ClassRepresentation> interestingClasses, @NotNull String testSamplesCode) {
        Intrinsics.checkNotNullParameter(interestingClasses, (String)"interestingClasses");
        Intrinsics.checkNotNullParameter((Object)testSamplesCode, (String)"testSamplesCode");
        String prompt = new PromptBuilder(this.promptTemplates.getClassPrompt()).insertLanguage(this.context.getPromptConfiguration().getDesiredLanguage()).insertName(this.context.getCut().getQualifiedName()).insertTestingPlatform(this.context.getPromptConfiguration().getDesiredTestingPlatform()).insertMockingFramework(this.context.getPromptConfiguration().getDesiredMockingFramework()).insertCodeUnderTest(this.context.getCut().getFullText(), this.context.getClassesToTest()).insertMethodsSignatures(interestingClasses).insertPolymorphismRelations(this.context.getPolymorphismRelations()).insertTestSample(testSamplesCode).build();
        return prompt;
    }

    @NotNull
    public final String generatePromptForMethod(@NotNull MethodRepresentation method, @NotNull List<ClassRepresentation> interestingClassesFromMethod, @NotNull String testSamplesCode) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(interestingClassesFromMethod, (String)"interestingClassesFromMethod");
        Intrinsics.checkNotNullParameter((Object)testSamplesCode, (String)"testSamplesCode");
        String prompt = new PromptBuilder(this.promptTemplates.getMethodPrompt()).insertLanguage(this.context.getPromptConfiguration().getDesiredLanguage()).insertName(this.context.getCut().getQualifiedName() + "." + method.getName()).insertTestingPlatform(this.context.getPromptConfiguration().getDesiredTestingPlatform()).insertMockingFramework(this.context.getPromptConfiguration().getDesiredMockingFramework()).insertCodeUnderTest(method.getText(), this.context.getClassesToTest()).insertMethodsSignatures(interestingClassesFromMethod).insertPolymorphismRelations(this.context.getPolymorphismRelations()).insertTestSample(testSamplesCode).build();
        return prompt;
    }

    @NotNull
    public final String generatePromptForLine(@NotNull String lineUnderTest, @NotNull MethodRepresentation method, @NotNull List<ClassRepresentation> interestingClassesFromMethod, @NotNull String testSamplesCode) {
        Intrinsics.checkNotNullParameter((Object)lineUnderTest, (String)"lineUnderTest");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(interestingClassesFromMethod, (String)"interestingClassesFromMethod");
        Intrinsics.checkNotNullParameter((Object)testSamplesCode, (String)"testSamplesCode");
        String prompt = new PromptBuilder(this.promptTemplates.getLinePrompt()).insertLanguage(this.context.getPromptConfiguration().getDesiredLanguage()).insertName(((Object)StringsKt.trim((CharSequence)lineUnderTest)).toString()).insertTestingPlatform(this.context.getPromptConfiguration().getDesiredTestingPlatform()).insertMockingFramework(this.context.getPromptConfiguration().getDesiredMockingFramework()).insertCodeUnderTest(method.getText(), this.context.getClassesToTest()).insertMethodsSignatures(interestingClassesFromMethod).insertPolymorphismRelations(this.context.getPolymorphismRelations()).insertTestSample(testSamplesCode).build();
        return prompt;
    }
}

