/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.generation.llm.prompt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.testspark.core.generation.llm.prompt.PromptKeyword;
import org.jetbrains.research.testspark.core.generation.llm.prompt.configuration.ClassRepresentation;
import org.jetbrains.research.testspark.core.generation.llm.prompt.configuration.MethodRepresentation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u001c\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\tJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\u0014\u0010\u0017\u001a\u00020\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\tJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0003J \u0010\u001d\u001a\u00020\u00002\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\t0\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/research/testspark/core/generation/llm/prompt/PromptBuilder;", "", "promptTemplate", "", "(Ljava/lang/String;)V", "insertedKeywordValues", "Ljava/util/EnumMap;", "Lorg/jetbrains/research/testspark/core/generation/llm/prompt/PromptKeyword;", "templateKeywords", "", "build", "containsPromptKeyword", "", "keyword", "insert", "", "value", "insertCodeUnderTest", "classFullText", "classesToTest", "Lorg/jetbrains/research/testspark/core/generation/llm/prompt/configuration/ClassRepresentation;", "insertLanguage", "language", "insertMethodsSignatures", "interestingClasses", "insertMockingFramework", "mockingFrameworkName", "insertName", "classDisplayName", "insertPolymorphismRelations", "polymorphismRelations", "", "insertTestSample", "testSamplesCode", "insertTestingPlatform", "testingPlatformName", "validatePromptKeyword", "core"})
@SourceDebugExtension(value={"SMAP\nPromptBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptBuilder.kt\norg/jetbrains/research/testspark/core/generation/llm/prompt/PromptBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,143:1\n215#2,2:144\n*S KotlinDebug\n*F\n+ 1 PromptBuilder.kt\norg/jetbrains/research/testspark/core/generation/llm/prompt/PromptBuilder\n*L\n125#1:144,2\n*E\n"})
public final class PromptBuilder {
    @NotNull
    private final String promptTemplate;
    @NotNull
    private final EnumMap<PromptKeyword, String> insertedKeywordValues;
    @NotNull
    private final List<PromptKeyword> templateKeywords;

    public PromptBuilder(@NotNull String promptTemplate) {
        Intrinsics.checkNotNullParameter((Object)promptTemplate, (String)"promptTemplate");
        this.promptTemplate = promptTemplate;
        this.insertedKeywordValues = new EnumMap(PromptKeyword.class);
        this.templateKeywords = new ArrayList();
        for (PromptKeyword keyword : EntriesMappings.entries$0) {
            if (!this.containsPromptKeyword(keyword)) continue;
            this.templateKeywords.add(keyword);
        }
    }

    private final boolean containsPromptKeyword(PromptKeyword keyword) {
        return StringsKt.contains$default((CharSequence)this.promptTemplate, (CharSequence)keyword.getVariable(), (boolean)false, (int)2, null);
    }

    private final void validatePromptKeyword(PromptKeyword keyword) {
        if (!((Map)this.insertedKeywordValues).containsKey((Object)keyword) && keyword.getMandatory()) {
            throw new IllegalStateException("The prompt must contain " + keyword.getText());
        }
    }

    @NotNull
    public final String build() {
        String populatedPrompt = this.promptTemplate;
        for (Map.Entry<PromptKeyword, String> entry : this.insertedKeywordValues.entrySet()) {
            Intrinsics.checkNotNull(entry);
            PromptKeyword keyword = entry.getKey();
            String value = entry.getValue();
            String string = keyword.getVariable();
            Intrinsics.checkNotNull((Object)value);
            populatedPrompt = StringsKt.replace((String)populatedPrompt, (String)string, (String)value, (boolean)false);
        }
        for (PromptKeyword keyword : this.templateKeywords) {
            this.validatePromptKeyword(keyword);
        }
        return populatedPrompt;
    }

    private final void insert(PromptKeyword keyword, String value) {
        if (!this.templateKeywords.contains((Object)keyword) && keyword.getMandatory()) {
            throw new IllegalArgumentException("Prompt template does not contain mandatory " + keyword.getText());
        }
        ((Map)this.insertedKeywordValues).put(keyword, value);
    }

    @NotNull
    public final PromptBuilder insertLanguage(@NotNull String language) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        PromptBuilder $this$insertLanguage_u24lambda_u240 = promptBuilder = this;
        boolean bl = false;
        $this$insertLanguage_u24lambda_u240.insert(PromptKeyword.LANGUAGE, language);
        return promptBuilder;
    }

    @NotNull
    public final PromptBuilder insertName(@NotNull String classDisplayName) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter((Object)classDisplayName, (String)"classDisplayName");
        PromptBuilder $this$insertName_u24lambda_u241 = promptBuilder = this;
        boolean bl = false;
        $this$insertName_u24lambda_u241.insert(PromptKeyword.NAME, classDisplayName);
        return promptBuilder;
    }

    @NotNull
    public final PromptBuilder insertTestingPlatform(@NotNull String testingPlatformName) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter((Object)testingPlatformName, (String)"testingPlatformName");
        PromptBuilder $this$insertTestingPlatform_u24lambda_u242 = promptBuilder = this;
        boolean bl = false;
        $this$insertTestingPlatform_u24lambda_u242.insert(PromptKeyword.TESTING_PLATFORM, testingPlatformName);
        return promptBuilder;
    }

    @NotNull
    public final PromptBuilder insertMockingFramework(@NotNull String mockingFrameworkName) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter((Object)mockingFrameworkName, (String)"mockingFrameworkName");
        PromptBuilder $this$insertMockingFramework_u24lambda_u243 = promptBuilder = this;
        boolean bl = false;
        $this$insertMockingFramework_u24lambda_u243.insert(PromptKeyword.MOCKING_FRAMEWORK, mockingFrameworkName);
        return promptBuilder;
    }

    @NotNull
    public final PromptBuilder insertCodeUnderTest(@NotNull String classFullText, @NotNull List<ClassRepresentation> classesToTest) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter((Object)classFullText, (String)"classFullText");
        Intrinsics.checkNotNullParameter(classesToTest, (String)"classesToTest");
        PromptBuilder $this$insertCodeUnderTest_u24lambda_u244 = promptBuilder = this;
        boolean bl = false;
        String fullText = "```\n" + classFullText + "\n```\n";
        int i = 2;
        int n = classesToTest.size();
        if (i <= n) {
            while (true) {
                ClassRepresentation subClass = classesToTest.get(i - 2);
                ClassRepresentation superClass = classesToTest.get(i - 1);
                fullText = fullText + subClass.getQualifiedName() + " extends " + superClass.getQualifiedName() + ". The source code of " + superClass.getQualifiedName() + " is:\n```\n" + superClass.getFullText() + "\n```\n";
                if (i == n) break;
                ++i;
            }
        }
        $this$insertCodeUnderTest_u24lambda_u244.insert(PromptKeyword.CODE, fullText);
        return promptBuilder;
    }

    @NotNull
    public final PromptBuilder insertMethodsSignatures(@NotNull List<ClassRepresentation> interestingClasses) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter(interestingClasses, (String)"interestingClasses");
        PromptBuilder $this$insertMethodsSignatures_u24lambda_u245 = promptBuilder = this;
        boolean bl = false;
        Object fullText = "";
        if (!((Collection)interestingClasses).isEmpty()) {
            fullText = (String)fullText + "Here are some information about other methods and classes used by the class under test. Only use them for creating objects, not your own ideas.\n";
        }
        for (ClassRepresentation interestingClass : interestingClasses) {
            if (StringsKt.startsWith$default((String)interestingClass.getQualifiedName(), (String)"java", (boolean)false, (int)2, null)) continue;
            fullText = (String)fullText + "=== methods in " + interestingClass.getQualifiedName() + ":\n";
            for (MethodRepresentation method : interestingClass.getAllMethods()) {
                if (StringsKt.startsWith$default((String)method.getContainingClassQualifiedName(), (String)"java", (boolean)false, (int)2, null)) continue;
                fullText = (String)fullText + " - " + method.getSignature() + "\n";
            }
        }
        $this$insertMethodsSignatures_u24lambda_u245.insert(PromptKeyword.METHODS, (String)fullText);
        return promptBuilder;
    }

    @NotNull
    public final PromptBuilder insertPolymorphismRelations(@NotNull Map<ClassRepresentation, ? extends List<ClassRepresentation>> polymorphismRelations) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter(polymorphismRelations, (String)"polymorphismRelations");
        PromptBuilder $this$insertPolymorphismRelations_u24lambda_u247 = promptBuilder = this;
        boolean bl = false;
        Object fullText = null;
        fullText = "";
        Map<ClassRepresentation, ? extends List<ClassRepresentation>> $this$forEach$iv = polymorphismRelations;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ClassRepresentation, ? extends List<ClassRepresentation>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ClassRepresentation, ? extends List<ClassRepresentation>> element$iv;
            Map.Entry<ClassRepresentation, ? extends List<ClassRepresentation>> entry = element$iv = iterator.next();
            boolean bl2 = false;
            for (ClassRepresentation currentSubClass : entry.getValue()) {
                fullText = fullText + currentSubClass.getQualifiedName() + " is a sub-class of " + entry.getKey().getQualifiedName() + ".\n";
            }
        }
        $this$insertPolymorphismRelations_u24lambda_u247.insert(PromptKeyword.POLYMORPHISM, (String)fullText);
        return promptBuilder;
    }

    @NotNull
    public final PromptBuilder insertTestSample(@NotNull String testSamplesCode) {
        PromptBuilder promptBuilder;
        Intrinsics.checkNotNullParameter((Object)testSamplesCode, (String)"testSamplesCode");
        PromptBuilder $this$insertTestSample_u24lambda_u248 = promptBuilder = this;
        boolean bl = false;
        Object fullText = testSamplesCode;
        if (!StringsKt.isBlank((CharSequence)((CharSequence)fullText))) {
            fullText = "Use this test samples:\n" + (String)fullText + "\n";
        }
        $this$insertTestSample_u24lambda_u248.insert(PromptKeyword.TEST_SAMPLE, (String)fullText);
        return promptBuilder;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<PromptKeyword> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])PromptKeyword.values());
        }
    }
}

