/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay.jwt;

import fleet.rpc.relay.jwt.JWK;
import fleet.rpc.relay.jwt.JWSCompactSerializer;
import fleet.rpc.relay.jwt.JWTKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=JWSCompactSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001c"}, d2={"Lfleet/rpc/relay/jwt/JWS;", "", "header", "", "payload", "signature", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHeader", "()Ljava/lang/String;", "getPayload", "getSignature", "deserializePayload", "Lkotlinx/serialization/json/JsonObject;", "jwk", "Lfleet/rpc/relay/jwt/JWK;", "compact", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "fleet.rpc.relay"})
@SourceDebugExtension(value={"SMAP\nJWT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWT.kt\nfleet/rpc/relay/jwt/JWS\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class JWS {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String header;
    @NotNull
    private final String payload;
    @NotNull
    private final String signature;

    public JWS(@NotNull String header, @NotNull String payload, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    @NotNull
    public final String getHeader() {
        return this.header;
    }

    @NotNull
    public final String getPayload() {
        return this.payload;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    @NotNull
    public final JsonObject deserializePayload() {
        byte[] bytes = JWTKt.access$jwtBase64Decode(this.payload);
        return (JsonObject)Json.Default.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), new String(bytes, Charsets.UTF_8));
    }

    @Nullable
    public final JWK jwk() {
        JWK jWK;
        JsonObject headerJson = (JsonObject)Json.Default.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), new String(JWTKt.access$jwtBase64Decode(this.header), Charsets.UTF_8));
        JsonElement jsonElement = (JsonElement)headerJson.get((Object)"jwk");
        if (jsonElement != null) {
            JsonElement it = jsonElement;
            boolean bl = false;
            jWK = (JWK)Json.Default.decodeFromJsonElement((DeserializationStrategy)JWK.Companion.serializer(), it);
        } else {
            jWK = null;
        }
        return jWK;
    }

    @NotNull
    public final String compact() {
        return this.header + "." + this.payload + "." + this.signature;
    }

    @NotNull
    public final String component1() {
        return this.header;
    }

    @NotNull
    public final String component2() {
        return this.payload;
    }

    @NotNull
    public final String component3() {
        return this.signature;
    }

    @NotNull
    public final JWS copy(@NotNull String header, @NotNull String payload, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return new JWS(header, payload, signature);
    }

    public static /* synthetic */ JWS copy$default(JWS jWS, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = jWS.header;
        }
        if ((n & 2) != 0) {
            string2 = jWS.payload;
        }
        if ((n & 4) != 0) {
            string3 = jWS.signature;
        }
        return jWS.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "JWS(header=" + this.header + ", payload=" + this.payload + ", signature=" + this.signature + ")";
    }

    public int hashCode() {
        int result2 = this.header.hashCode();
        result2 = result2 * 31 + this.payload.hashCode();
        result2 = result2 * 31 + this.signature.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JWS)) {
            return false;
        }
        JWS jWS = (JWS)other;
        if (!Intrinsics.areEqual((Object)this.header, (Object)jWS.header)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.payload, (Object)jWS.payload)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signature, (Object)jWS.signature);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lfleet/rpc/relay/jwt/JWS$Companion;", "", "<init>", "()V", "fromCompact", "Lfleet/rpc/relay/jwt/JWS;", "compact", "", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.rpc.relay"})
    @SourceDebugExtension(value={"SMAP\nJWT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWT.kt\nfleet/rpc/relay/jwt/JWS$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JWS fromCompact(@NotNull String compact) {
            Intrinsics.checkNotNullParameter((Object)compact, (String)"compact");
            char[] cArray = new char[]{'.'};
            List components = StringsKt.split$default((CharSequence)compact, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (!(components.size() == 3)) {
                boolean $i$a$-check-JWS$Companion$fromCompact$22 = false;
                String $i$a$-check-JWS$Companion$fromCompact$22 = "Wrong number of components in JWT string \"" + compact + "\"";
                throw new IllegalStateException($i$a$-check-JWS$Companion$fromCompact$22.toString());
            }
            String header = (String)components.get(0);
            String payload = (String)components.get(1);
            String signature = (String)components.get(2);
            return new JWS(header, payload, signature);
        }

        @NotNull
        public final KSerializer<JWS> serializer() {
            return (KSerializer)new JWSCompactSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

