/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay.end2end;

import fleet.rpc.relay.end2end.Certificate;
import java.math.BigInteger;
import java.nio.channels.ByteChannel;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import tlschannel.ClientTlsChannel;
import tlschannel.ServerTlsChannel;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a*\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0015\u0012\u0004\u0012\u00020\r0\u0014H\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"x509Certificate", "Ljava/security/cert/X509Certificate;", "public", "Lfleet/rpc/relay/jwt/PublicKey;", "private", "Lfleet/rpc/relay/jwt/PrivateKey;", "subjectNameString", "", "KEY_ALIAS", "tlsChannel", "Ljava/nio/channels/ByteChannel;", "byteChannel", "server", "", "certificate", "Lfleet/rpc/relay/end2end/Certificate;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "X509TrustManager", "trusted", "Lkotlin/Function1;", "", "fleet.rpc.relay"})
@SourceDebugExtension(value={"SMAP\nEncryption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encryption.kt\nfleet/rpc/relay/end2end/EncryptionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class EncryptionKt {
    @NotNull
    private static final String KEY_ALIAS = "KEY_ALIAS";

    @NotNull
    public static final X509Certificate x509Certificate(@NotNull fleet.rpc.relay.jwt.PublicKey publicKey, @NotNull fleet.rpc.relay.jwt.PrivateKey privateKey, @NotNull String subjectNameString) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"public");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"private");
        Intrinsics.checkNotNullParameter((Object)subjectNameString, (String)"subjectNameString");
        RSAPublicKeySpec publicKeySpec = publicKey.keySpec$fleet_rpc_relay();
        RSAPrivateKeySpec privateKeySpec = privateKey.keySpec$fleet_rpc_relay();
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey publicKey2 = factory.generatePublic(publicKeySpec);
        PrivateKey privateKey2 = factory.generatePrivate(privateKeySpec);
        int days = 365;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Instant now = instant;
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(Duration.ofDays(days)));
        X500Name subjectName = new X500Name("CN=" + StringsKt.replace$default((String)subjectNameString, (String)"=", (String)"\\=", (boolean)false, (int)4, null));
        X500Principal subjectPrincipal = new X500Principal(subjectName.getEncoded());
        BigInteger subjectSerial = BigInteger.valueOf(now.toEpochMilli());
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(X500Name.getInstance((Object)subjectPrincipal.getEncoded()), subjectSerial, notBefore, notAfter, Locale.ENGLISH, X500Name.getInstance((Object)subjectPrincipal.getEncoded()), SubjectPublicKeyInfo.getInstance((Object)publicKey2.getEncoded()));
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA512WithRSA").build(privateKey2);
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateBuilder.build(contentSigner));
        if (x509Certificate == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return x509Certificate;
    }

    @NotNull
    public static final ByteChannel tlsChannel(@NotNull ByteChannel byteChannel, boolean server, @NotNull Certificate certificate, @NotNull X509TrustManager trustManager2) {
        ByteChannel byteChannel2;
        X509TrustManager[] x509TrustManagerArray;
        SSLContext sSLContext;
        Intrinsics.checkNotNullParameter((Object)byteChannel, (String)"byteChannel");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)trustManager2, (String)"trustManager");
        SSLContext ctx = sSLContext = SSLContext.getInstance("TLSv1.3");
        boolean bl = false;
        X509TrustManager[] it = x509TrustManagerArray = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        boolean bl2 = false;
        it.init(certificate.getKeyStore(), certificate.getKeyPassword());
        X509TrustManager[] keyManagerFactory = x509TrustManagerArray;
        x509TrustManagerArray = new X509TrustManager[]{trustManager2};
        ctx.init(keyManagerFactory.getKeyManagers(), x509TrustManagerArray, null);
        SSLContext sslContext = sSLContext;
        boolean bl3 = server;
        if (bl3) {
            ServerTlsChannel serverTlsChannel = ServerTlsChannel.newBuilder((ByteChannel)byteChannel, (SSLContext)sslContext).withEngineFactory(EncryptionKt::tlsChannel$lambda$2).build();
            Intrinsics.checkNotNullExpressionValue((Object)serverTlsChannel, (String)"build(...)");
            byteChannel2 = (ByteChannel)serverTlsChannel;
        } else if (!bl3) {
            ClientTlsChannel clientTlsChannel = ClientTlsChannel.newBuilder((ByteChannel)byteChannel, (SSLContext)sslContext).build();
            Intrinsics.checkNotNullExpressionValue((Object)clientTlsChannel, (String)"build(...)");
            byteChannel2 = (ByteChannel)clientTlsChannel;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byteChannel2;
    }

    @NotNull
    public static final X509TrustManager X509TrustManager(boolean server, @NotNull Function1<? super List<? extends X509Certificate>, Boolean> trusted) {
        Intrinsics.checkNotNullParameter(trusted, (String)"trusted");
        return new X509TrustManager(server, trusted){
            final /* synthetic */ boolean $server;
            final /* synthetic */ Function1<List<? extends X509Certificate>, Boolean> $trusted;
            {
                this.$server = $server;
                this.$trusted = $trusted;
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                if (!this.$server) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!((Boolean)this.$trusted.invoke((Object)ArraysKt.asList((Object[])chain))).booleanValue()) {
                    throw new CertificateException("Certificate chain is not trusted");
                }
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                if (!(!this.$server)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!((Boolean)this.$trusted.invoke((Object)ArraysKt.asList((Object[])chain))).booleanValue()) {
                    throw new CertificateException("Certificate chain is not trusted");
                }
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private static final SSLEngine tlsChannel$lambda$2(SSLContext it) {
        SSLEngine sslEngine = it.createSSLEngine();
        sslEngine.setUseClientMode(false);
        sslEngine.setNeedClientAuth(true);
        return sslEngine;
    }
}

