/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.css.descriptor;

import fleet.com.intellij.util.ArrayUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public enum CssContextType {
    ANY("any", "everywhere", true),
    NONE("none", "root of file", true),
    NONAME("noname", "regular ruleset", true),
    PAGE("@page", "@page", false),
    JQUERY("@jquery", "jquery selector", true),
    KEYFRAMES("@keyframes", "@keyframes", true),
    CHARSET("@charset", "@charset", true),
    MEDIA("@media", "@media", true),
    PROPERTY("@property", "@property", false),
    CONTAINER("@container", "@container", true),
    LAYER("@layer", "@layer", true),
    NAMESPACE("@namespace", "@namespace", true),
    FONTFACE("@font-face", "@font-face", false),
    FONT_PALETTE_VALUES("@font-palette-values", "@font-palette-values", false),
    VIEWPORT("@viewport", "@viewport", false),
    SUPPORTS("@supports", "@supports", false),
    PAGE_MARGIN("page-margin", "page margin rule", false),
    COLOR_PROFILE("@color-profile", "@color-profile", false),
    COUNTER_STYLE("@counter-style", "@counter-style", false),
    UNKNOWN("unknown", "unknown", false);

    public static final String[] PAGE_MARGIN_RULES;
    public static final Comparator<? super CssContextType> COMPARATOR;
    private final String myName;
    @NotNull
    private final String myPresentationName;
    public static final CssContextType[] EMPTY_ARRAY;
    private final boolean mySubsetOfAny;

    private CssContextType(String name, String presentationName, boolean isSubsetOfAny) {
        this.myName = name;
        this.myPresentationName = presentationName;
        this.mySubsetOfAny = isSubsetOfAny;
    }

    @NotNull
    public static CssContextType fromString(@NotNull String s) {
        for (CssContextType type : CssContextType.values()) {
            if (!s.equals(type.getName())) continue;
            return type;
        }
        if (ArrayUtil.contains((String)s, (String[])PAGE_MARGIN_RULES)) {
            return PAGE_MARGIN;
        }
        throw new IllegalArgumentException("Unknown context type '" + s + "'");
    }

    private String getName() {
        return this.myName;
    }

    public boolean isSubsetOfAny() {
        return this.mySubsetOfAny;
    }

    @NotNull
    private String getPresentationName() {
        return this.myPresentationName;
    }

    @NotNull
    public String toString() {
        return this.getPresentationName();
    }

    static {
        PAGE_MARGIN_RULES = new String[]{"@top-left-corner", "@top-left", "@top-center", "@top-right", "@top-right-corner", "@bottom-left-corner", "@bottom-left", "@bottom-center", "@bottom-right", "@bottom-right-corner", "@left-top", "@left-middle", "@left-bottom", "@right-top", "@right-middle", "@right-bottom"};
        COMPARATOR = (o1, o2) -> o2.getName().compareTo(o1.getName());
        EMPTY_ARRAY = new CssContextType[0];
    }
}

