/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.css.descriptor;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class BrowserVersion {
    public static final BrowserVersion[] EMPTY_ARRAY = new BrowserVersion[0];
    public static final Comparator<BrowserVersion> COMPARATOR = (o1, o2) -> o1.getBrowser().getPresentableName().compareTo(o2.getBrowser().getPresentableName());
    @NotNull
    private final Browser myBrowser;
    @NotNull
    private final String myVersion;

    public BrowserVersion(@NotNull Browser browser, @NotNull String version) {
        this.myBrowser = browser;
        this.myVersion = version;
    }

    @NotNull
    public String toString() {
        return this.myBrowser.getPresentableName() + " " + this.myVersion;
    }

    @NotNull
    public String getVersion() {
        return this.myVersion;
    }

    @NotNull
    public Browser getBrowser() {
        return this.myBrowser;
    }

    @NotNull
    public static BrowserVersion fromString(@NotNull String string) {
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case 'C': {
                    return new BrowserVersion(Browser.CHROME, string.substring(1));
                }
                case 'F': {
                    return new BrowserVersion(Browser.FIREFOX, string.substring(2));
                }
                case 'I': {
                    return new BrowserVersion(Browser.IE, string.substring(2));
                }
                case 'O': {
                    return new BrowserVersion(Browser.OPERA, string.substring(1));
                }
                case 'S': {
                    return new BrowserVersion(Browser.SAFARI, string.substring(1));
                }
                case 'E': {
                    return new BrowserVersion(Browser.EDGE, string.substring(1));
                }
            }
        }
        throw new IllegalArgumentException("Can't create browser version for " + string);
    }

    public static enum Browser {
        CHROME("Chrome"),
        FIREFOX("Firefox"),
        SAFARI("Safari"),
        OPERA("Opera"),
        IE("IE"),
        EDGE("Edge");

        @NotNull
        private final String myPresentableName;

        private Browser(String presentableName) {
            this.myPresentableName = presentableName;
        }

        @NotNull
        public String getPresentableName() {
            return this.myPresentableName;
        }
    }
}

