/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.workspace.logcat;

import fleet.api.exec.Line;
import fleet.api.exec.LineBuilder;
import fleet.api.exec.TerminalColor;
import fleet.api.exec.TerminalProtoKt;
import fleet.mercury.protocol.logcat.LogLevel;
import fleet.mercury.protocol.logcat.LogcatMessage;
import fleet.mercury.workspace.logcat.LogcatColorsKt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\u001a4\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0000\u001a*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\u0017\u001a\u00020\u0013H\u0002\u001a?\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u001c\u0010 \u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001c\u0010!\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a$\u0010$\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001c\u0010%\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0001H\u0002\u001a\u001c\u0010'\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a:\u0010(\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010)\u001a\u00020\u00132\b\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u0010H\u0002\u001a\u0014\u0010+\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"APP_NAME_LENGTH", "", "APP_NAME_PREFIX_LEN", "DATE_TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "ELLIPSIS_LEN", "HEADER_WIDTH", "TAG_LENGTH", "formatMessage", "", "Lfleet/api/exec/Line;", "message", "Lfleet/mercury/protocol/logcat/LogcatMessage;", "prevMessage", "isLightTheme", "", "isWrapped", "shortenTextWithEllipsis", "", "text", "maxLength", "suffixLength", "symbol", "addAppName", "", "Lfleet/api/exec/LineBuilder;", "appName", "pid", "previousPid", "hideDuplicates", "(Lfleet/api/exec/LineBuilder;Ljava/lang/String;ILjava/lang/Integer;IZ)V", "addChunk", "addLogLevel", "logLevel", "Lfleet/mercury/protocol/logcat/LogLevel;", "addMessage", "addProcessThread", "tid", "addSystemMessage", "addTag", "tag", "previousTag", "addTimestamp", "timestamp", "", "fleet.plugins.mercury.workspace"})
@SourceDebugExtension(value={"SMAP\nLogcatMessageFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatMessageFormat.kt\nfleet/mercury/workspace/logcat/LogcatMessageFormatKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1855#2,2:142\n*S KotlinDebug\n*F\n+ 1 LogcatMessageFormat.kt\nfleet/mercury/workspace/logcat/LogcatMessageFormatKt\n*L\n49#1:142,2\n*E\n"})
public final class LogcatMessageFormatKt {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).appendLiteral(' ').toFormatter(Locale.ROOT);
    private static final int TAG_LENGTH = 23;
    private static final int ELLIPSIS_LEN = 3;
    private static final int HEADER_WIDTH = 101;
    private static final int APP_NAME_LENGTH = 35;
    private static final int APP_NAME_PREFIX_LEN = 6;

    @NotNull
    public static final List<Line> formatMessage(@NotNull LogcatMessage message, @Nullable LogcatMessage prevMessage, boolean isLightTheme, boolean isWrapped) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List messageLines = StringsKt.lines((CharSequence)message.getMessage());
        if (messageLines.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List $this$formatMessage_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$formatMessage_u24lambda_u241.add(TerminalProtoKt.buildLine((boolean)isWrapped, (Function1)((Function1)new Function1<LineBuilder, Unit>(message, prevMessage, isLightTheme, (List<String>)messageLines){
            final /* synthetic */ LogcatMessage $message;
            final /* synthetic */ LogcatMessage $prevMessage;
            final /* synthetic */ boolean $isLightTheme;
            final /* synthetic */ List<String> $messageLines;
            {
                this.$message = $message;
                this.$prevMessage = $prevMessage;
                this.$isLightTheme = $isLightTheme;
                this.$messageLines = $messageLines;
                super(1);
            }

            public final void invoke(@NotNull LineBuilder $this$buildLine) {
                Intrinsics.checkNotNullParameter((Object)$this$buildLine, (String)"$this$buildLine");
                if (!this.$message.getHeader().isSystem()) {
                    LogcatMessage logcatMessage;
                    LogcatMessage logcatMessage2;
                    LogcatMessageFormatKt.access$addTimestamp($this$buildLine, this.$message.getHeader().getTimestamp());
                    LogcatMessageFormatKt.access$addProcessThread($this$buildLine, this.$message.getHeader().getPid(), this.$message.getHeader().getTid());
                    LogcatMessageFormatKt.addTag$default($this$buildLine, this.$message.getHeader().getTag(), (logcatMessage2 = this.$prevMessage) != null && (logcatMessage2 = logcatMessage2.getHeader()) != null ? logcatMessage2.getTag() : null, this.$isLightTheme, 0, false, 24, null);
                    LogcatMessageFormatKt.addAppName$default($this$buildLine, this.$message.getHeader().getAppName(), this.$message.getHeader().getPid(), (logcatMessage = this.$prevMessage) != null && (logcatMessage = logcatMessage.getHeader()) != null ? Integer.valueOf(logcatMessage.getPid()) : null, 0, false, 24, null);
                    LogcatMessageFormatKt.access$addLogLevel($this$buildLine, this.$message.getHeader().getLogLevel(), this.$isLightTheme);
                    LogcatMessageFormatKt.access$addMessage($this$buildLine, (String)CollectionsKt.first(this.$messageLines), this.$message.getHeader().getLogLevel(), this.$isLightTheme);
                } else {
                    LogcatMessageFormatKt.access$addSystemMessage($this$buildLine, (String)CollectionsKt.first(this.$messageLines), this.$isLightTheme);
                }
            }
        })));
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)messageLines, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl2 = false;
            $this$formatMessage_u24lambda_u241.add(TerminalProtoKt.buildLine((boolean)isWrapped, (Function1)((Function1)new Function1<LineBuilder, Unit>(line, message, isLightTheme){
                final /* synthetic */ String $line;
                final /* synthetic */ LogcatMessage $message;
                final /* synthetic */ boolean $isLightTheme;
                {
                    this.$line = $line;
                    this.$message = $message;
                    this.$isLightTheme = $isLightTheme;
                    super(1);
                }

                public final void invoke(@NotNull LineBuilder $this$buildLine) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildLine, (String)"$this$buildLine");
                    LogcatMessageFormatKt.access$addMessage($this$buildLine, StringsKt.padEnd$default((String)"", (int)101, (char)'\u0000', (int)2, null) + this.$line, this.$message.getHeader().getLogLevel(), this.$isLightTheme);
                }
            })));
        }
        return CollectionsKt.build((List)list2);
    }

    public static /* synthetic */ List formatMessage$default(LogcatMessage logcatMessage, LogcatMessage logcatMessage2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return LogcatMessageFormatKt.formatMessage(logcatMessage, logcatMessage2, bl, bl2);
    }

    private static final LineBuilder addChunk(LineBuilder $this$addChunk, String text, boolean isLightTheme) {
        return LineBuilder.addChunk$default((LineBuilder)$this$addChunk, (String)text, (TerminalColor)LogcatColorsKt.defaultLogColor(isLightTheme), null, (int)4, null);
    }

    private static final LineBuilder addTimestamp(LineBuilder $this$addTimestamp, long timestamp) {
        return LineBuilder.addChunk$default((LineBuilder)$this$addTimestamp, (String)(DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault())) + " "), (TerminalColor)((TerminalColor)LogcatColorsKt.getSecondaryLogColor()), null, (int)4, null);
    }

    private static final LineBuilder addProcessThread(LineBuilder $this$addProcessThread, int pid, int tid) {
        String string = "%5d-%-5d ";
        Object[] objectArray = new Object[]{pid, tid};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return LineBuilder.addChunk$default((LineBuilder)$this$addProcessThread, (String)string2, (TerminalColor)((TerminalColor)LogcatColorsKt.getSecondaryLogColor()), null, (int)4, null);
    }

    private static final void addTag(LineBuilder $this$addTag, String tag, String previousTag, boolean isLightTheme, int maxLength, boolean hideDuplicates) {
        String line = hideDuplicates && Intrinsics.areEqual((Object)tag, (Object)previousTag) ? StringsKt.padEnd$default((String)"", (int)(maxLength + 1), (char)'\u0000', (int)2, null) : (Intrinsics.areEqual((Object)tag, (Object)"") ? StringsKt.padEnd$default((String)"<no-tag>", (int)(maxLength + 1), (char)'\u0000', (int)2, null) : (tag.length() > maxLength ? LogcatMessageFormatKt.shortenTextWithEllipsis$default(tag, maxLength, (maxLength - 3) / 2, null, 8, null) + " " : StringsKt.padEnd$default((String)tag, (int)(maxLength + 1), (char)'\u0000', (int)2, null)));
        LineBuilder.addChunk$default((LineBuilder)$this$addTag, (String)line, (TerminalColor)LogcatColorsKt.tagColor(tag, isLightTheme), null, (int)4, null);
    }

    static /* synthetic */ void addTag$default(LineBuilder lineBuilder, String string, String string2, boolean bl, int n, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 23;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        LogcatMessageFormatKt.addTag(lineBuilder, string, string2, bl, n, bl2);
    }

    /*
     * Unable to fully structure code
     */
    private static final void addAppName(LineBuilder $this$addAppName, String appName, int pid, Integer previousPid, int maxLength, boolean hideDuplicates) {
        if (!hideDuplicates) ** GOTO lbl-1000
        v0 = previousPid;
        if (v0 != null && pid == v0) {
            v1 = StringsKt.padEnd$default((String)"", (int)(maxLength + 1), (char)'\u0000', (int)2, null);
        } else lbl-1000:
        // 2 sources

        {
            v1 = appName.length() > maxLength ? LogcatMessageFormatKt.shortenTextWithEllipsis$default(appName, maxLength, maxLength - 6, null, 8, null) + " " : StringsKt.padEnd$default((String)appName, (int)(maxLength + 1), (char)'\u0000', (int)2, null);
        }
        line = v1;
        LineBuilder.addChunk$default((LineBuilder)$this$addAppName, (String)line, (TerminalColor)((TerminalColor)LogcatColorsKt.getSecondaryLogColor()), null, (int)4, null);
    }

    static /* synthetic */ void addAppName$default(LineBuilder lineBuilder, String string, int n, Integer n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 35;
        }
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        LogcatMessageFormatKt.addAppName(lineBuilder, string, n, n2, n3, bl);
    }

    private static final void addLogLevel(LineBuilder $this$addLogLevel, LogLevel logLevel, boolean isLightTheme) {
        $this$addLogLevel.addChunk(" " + logLevel.getChar() + " ", LogcatColorsKt.fgColor(logLevel, isLightTheme), LogcatColorsKt.bgColor(logLevel, isLightTheme));
        LogcatMessageFormatKt.addChunk($this$addLogLevel, " ", isLightTheme);
    }

    private static final LineBuilder addMessage(LineBuilder $this$addMessage, String message, LogLevel logLevel, boolean isLightTheme) {
        return LineBuilder.addChunk$default((LineBuilder)$this$addMessage, (String)message, (TerminalColor)LogcatColorsKt.messageFgColor(logLevel, isLightTheme), null, (int)4, null);
    }

    private static final LineBuilder addSystemMessage(LineBuilder $this$addSystemMessage, String message, boolean isLightTheme) {
        return LogcatMessageFormatKt.addChunk($this$addSystemMessage, message, isLightTheme);
    }

    private static final String shortenTextWithEllipsis(String text, int maxLength, int suffixLength, String symbol) {
        Object object;
        if (text.length() > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            String string = text.substring(0, prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = text.substring(text.length() - suffixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = string + symbol + string2;
        } else {
            object = text;
        }
        return object;
    }

    static /* synthetic */ String shortenTextWithEllipsis$default(String string, int n, int n2, String string2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            string2 = "...";
        }
        return LogcatMessageFormatKt.shortenTextWithEllipsis(string, n, n2, string2);
    }

    public static final /* synthetic */ LineBuilder access$addMessage(LineBuilder $receiver, String message, LogLevel logLevel, boolean isLightTheme) {
        return LogcatMessageFormatKt.addMessage($receiver, message, logLevel, isLightTheme);
    }

    public static final /* synthetic */ LineBuilder access$addTimestamp(LineBuilder $receiver, long timestamp) {
        return LogcatMessageFormatKt.addTimestamp($receiver, timestamp);
    }

    public static final /* synthetic */ LineBuilder access$addProcessThread(LineBuilder $receiver, int pid, int tid) {
        return LogcatMessageFormatKt.addProcessThread($receiver, pid, tid);
    }

    public static final /* synthetic */ void access$addLogLevel(LineBuilder $receiver, LogLevel logLevel, boolean isLightTheme) {
        LogcatMessageFormatKt.addLogLevel($receiver, logLevel, isLightTheme);
    }

    public static final /* synthetic */ LineBuilder access$addSystemMessage(LineBuilder $receiver, String message, boolean isLightTheme) {
        return LogcatMessageFormatKt.addSystemMessage($receiver, message, isLightTheme);
    }
}

