/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components.awt;

import androidx.compose.ui.text.FontHinting;
import androidx.compose.ui.text.FontRasterizationSettings;
import androidx.compose.ui.text.FontSmoothing;
import fleet.compose.theme.text.FontRasterSettingsFleetDefaults;
import fleet.util.logging.KLogger;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.ui.components.awt.SkiaGraphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.PathFillMode;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Point;
import sun.awt.SunToolkit;
import sun.font.FontUtilities;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a,\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"traceShape", "", "Lorg/jetbrains/skia/Path;", "shape", "Ljava/awt/Shape;", "tracePoints", "xPoints", "", "yPoints", "nPoints", "", "closed", "", "toSkijaPoint", "Lorg/jetbrains/skia/Point;", "Ljava/awt/geom/Point2D;", "toFontRenderContext", "Ljava/awt/font/FontRenderContext;", "Landroidx/compose/ui/text/FontRasterizationSettings;", "getPixelGeometry", "Lorg/jetbrains/skia/PixelGeometry;", "getFontRasterSettings", "Ljava/awt/font/GlyphVector;", "fleet.noria.awt"})
@SourceDebugExtension(value={"SMAP\nSkiaGraphics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaGraphics.kt\nnoria/ui/components/awt/SkiaGraphicsKt\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,789:1\n18#2,2:790\n*S KotlinDebug\n*F\n+ 1 SkiaGraphics.kt\nnoria/ui/components/awt/SkiaGraphicsKt\n*L\n714#1:790,2\n*E\n"})
public final class SkiaGraphicsKt {
    private static final void traceShape(Path $this$traceShape, Shape shape) {
        $this$traceShape.reset();
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] segment = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(segment)) {
                case 0: {
                    $this$traceShape.moveTo(new Point(segment[0], segment[1]));
                    break;
                }
                case 1: {
                    $this$traceShape.lineTo(new Point(segment[0], segment[1]));
                    break;
                }
                case 2: {
                    $this$traceShape.quadTo(segment[0], segment[1], segment[2], segment[3]);
                    break;
                }
                case 3: {
                    $this$traceShape.cubicTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                    break;
                }
                case 4: {
                    $this$traceShape.closePath();
                }
            }
            pathIterator.next();
        }
        Path path = $this$traceShape;
        path.setFillMode(switch (pathIterator.getWindingRule()) {
            case 0 -> PathFillMode.EVEN_ODD;
            case 1 -> PathFillMode.WINDING;
            default -> {
                PathFillMode var4_4;
                PathFillMode var5_5 = var4_4 = PathFillMode.EVEN_ODD;
                Path var11_6 = path;
                boolean $i$a$-also-SkiaGraphicsKt$traceShape$1 = false;
                KLogger this_$iv = SkiaGraphics.Companion.getLogger();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    void it;
                    KLogger var9_10 = this_$iv;
                    boolean $i$a$-warn-SkiaGraphicsKt$traceShape$1$1 = false;
                    var9_10.warn((Object)("Unexpected winding rule: " + pathIterator.getWindingRule() + "; falling back to " + (PathFillMode)it));
                }
                path = var11_6;
                yield var4_4;
            }
        });
    }

    private static final void tracePoints(Path $this$tracePoints, int[] xPoints, int[] yPoints, int nPoints, boolean closed) {
        $this$tracePoints.moveTo((float)xPoints[0], (float)yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            $this$tracePoints.lineTo((float)xPoints[i], (float)yPoints[i]);
        }
        $this$tracePoints.lineTo((float)xPoints[0], (float)yPoints[0]);
        if (closed) {
            $this$tracePoints.closePath();
        }
    }

    private static final Point toSkijaPoint(Point2D $this$toSkijaPoint) {
        return new Point((float)$this$toSkijaPoint.getX(), (float)$this$toSkijaPoint.getY());
    }

    @NotNull
    public static final FontRenderContext toFontRenderContext(@NotNull FontRasterizationSettings $this$toFontRenderContext) {
        Intrinsics.checkNotNullParameter((Object)$this$toFontRenderContext, (String)"<this>");
        AffineTransform transform = null;
        Object antiAliasingHint = switch (WhenMappings.$EnumSwitchMapping$1[$this$toFontRenderContext.getSmoothing().ordinal()]) {
            case 1 -> RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            case 2 -> RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            case 3 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[SkiaGraphicsKt.getPixelGeometry().ordinal()]) {
                    case 1: {
                        yield RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
                    }
                    case 2: {
                        yield RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                    }
                    case 3: {
                        yield RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                    }
                    case 4: {
                        yield RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                    }
                    case 5: {
                        yield RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Object fractionalMetricsHint = $this$toFontRenderContext.getSubpixelPositioning() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        return new FontRenderContext(transform, antiAliasingHint, fractionalMetricsHint);
    }

    private static final PixelGeometry getPixelGeometry() {
        RenderingHints renderingHints = SunToolkit.getDesktopFontHints();
        return Intrinsics.areEqual((Object)renderingHints, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR) ? PixelGeometry.BGR_H : (Intrinsics.areEqual((Object)renderingHints, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB) ? PixelGeometry.RGB_H : (Intrinsics.areEqual((Object)renderingHints, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR) ? PixelGeometry.BGR_V : (Intrinsics.areEqual((Object)renderingHints, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB) ? PixelGeometry.RGB_V : PixelGeometry.UNKNOWN)));
    }

    private static final FontRasterizationSettings getFontRasterSettings(GlyphVector $this$getFontRasterSettings) {
        FontRasterizationSettings defaults = FontRasterSettingsFleetDefaults.INSTANCE.defaultForCurrentPlatform();
        Object object = $this$getFontRasterSettings.getFontRenderContext().getFractionalMetricsHint();
        boolean bl = Intrinsics.areEqual((Object)object, (Object)RenderingHints.VALUE_FRACTIONALMETRICS_OFF) ? false : (Intrinsics.areEqual((Object)object, (Object)RenderingHints.VALUE_FRACTIONALMETRICS_ON) ? true : defaults.getSubpixelPositioning());
        Object object2 = $this$getFontRasterSettings.getFontRenderContext().getAntiAliasingHint();
        object = Intrinsics.areEqual((Object)object2, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) ? FontSmoothing.None : (Intrinsics.areEqual((Object)object2, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR) || Intrinsics.areEqual((Object)object2, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB) || Intrinsics.areEqual((Object)object2, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR) || Intrinsics.areEqual((Object)object2, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB) ? FontSmoothing.SubpixelAntiAlias : (Intrinsics.areEqual((Object)object2, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_GASP) ? (FontUtilities.getFont2D($this$getFontRasterSettings.getFont()).useAAForPtSize($this$getFontRasterSettings.getFont().getSize()) ? (WhenMappings.$EnumSwitchMapping$1[defaults.getSmoothing().ordinal()] == 1 ? FontSmoothing.SubpixelAntiAlias : defaults.getSmoothing()) : FontSmoothing.None) : (Intrinsics.areEqual((Object)object2, (Object)RenderingHints.VALUE_TEXT_ANTIALIAS_ON) ? FontSmoothing.AntiAlias : defaults.getSmoothing())));
        object2 = defaults.getHinting();
        boolean bl2 = defaults.getAutoHintingForced();
        return new FontRasterizationSettings((FontSmoothing)object, (FontHinting)object2, bl, bl2);
    }

    public static final /* synthetic */ void access$traceShape(Path $receiver, Shape shape) {
        SkiaGraphicsKt.traceShape($receiver, shape);
    }

    public static final /* synthetic */ FontRasterizationSettings access$getFontRasterSettings(GlyphVector $receiver) {
        return SkiaGraphicsKt.getFontRasterSettings($receiver);
    }

    public static final /* synthetic */ Point access$toSkijaPoint(Point2D $receiver) {
        return SkiaGraphicsKt.toSkijaPoint($receiver);
    }

    public static final /* synthetic */ void access$tracePoints(Path $receiver, int[] xPoints, int[] yPoints, int nPoints, boolean closed) {
        SkiaGraphicsKt.tracePoints($receiver, xPoints, yPoints, nPoints, closed);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PixelGeometry.values().length];
            try {
                nArray[PixelGeometry.BGR_H.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PixelGeometry.BGR_V.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PixelGeometry.RGB_H.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PixelGeometry.RGB_V.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PixelGeometry.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FontSmoothing.values().length];
            try {
                nArray[FontSmoothing.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontSmoothing.AntiAlias.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontSmoothing.SubpixelAntiAlias.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

