/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko.themes;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import fleet.util.logging.KLogger;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import noria.windowManagement.impl.skiko.themes.ConcurrentHashSet;
import noria.windowManagement.impl.skiko.themes.OsThemeDetector;
import noria.windowManagement.impl.skiko.themes.WindowsThemeDetector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnoria/windowManagement/impl/skiko/themes/WindowsThemeDetector;", "Lnoria/windowManagement/impl/skiko/themes/OsThemeDetector;", "()V", "detectorThread", "Lnoria/windowManagement/impl/skiko/themes/WindowsThemeDetector$DetectorThread;", "isDark", "", "()Z", "listeners", "", "Ljava/util/function/Consumer;", "registerListener", "", "darkThemeListener", "removeAllListeners", "Companion", "DetectorThread", "fleet.noria.windowManagement.impl"})
public final class WindowsThemeDetector
extends OsThemeDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Consumer<Boolean>> listeners = new ConcurrentHashSet();
    @Nullable
    private volatile DetectorThread detectorThread;
    @NotNull
    private static final Lazy<KLogger> logger$delegate = LazyKt.lazy((Function0)Companion.logger.2.INSTANCE);
    @NotNull
    private static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    @NotNull
    private static final String REGISTRY_VALUE = "AppsUseLightTheme";

    @Override
    public boolean isDark() {
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) == 0;
    }

    @Override
    public synchronized void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        boolean threadInterrupted;
        Intrinsics.checkNotNullParameter(darkThemeListener, (String)"darkThemeListener");
        boolean listenerAdded = this.listeners.add(darkThemeListener);
        boolean singleListener = listenerAdded && this.listeners.size() == 1;
        DetectorThread currentDetectorThread = this.detectorThread;
        boolean bl = threadInterrupted = currentDetectorThread != null && currentDetectorThread.isInterrupted();
        if (singleListener || threadInterrupted) {
            DetectorThread newDetectorThread;
            this.detectorThread = newDetectorThread = new DetectorThread(this);
            newDetectorThread.start();
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        this.listeners.clear();
        DetectorThread detectorThread = this.detectorThread;
        if (detectorThread != null) {
            detectorThread.interrupt();
        }
        this.detectorThread = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lnoria/windowManagement/impl/skiko/themes/WindowsThemeDetector$Companion;", "", "()V", "REGISTRY_PATH", "", "REGISTRY_VALUE", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "fleet.noria.windowManagement.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            Lazy lazy = logger$delegate;
            return (KLogger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnoria/windowManagement/impl/skiko/themes/WindowsThemeDetector$DetectorThread;", "Ljava/lang/Thread;", "themeDetector", "Lnoria/windowManagement/impl/skiko/themes/WindowsThemeDetector;", "(Lnoria/windowManagement/impl/skiko/themes/WindowsThemeDetector;)V", "lastValue", "", "run", "", "fleet.noria.windowManagement.impl"})
    private static final class DetectorThread
    extends Thread {
        @NotNull
        private final WindowsThemeDetector themeDetector;
        private boolean lastValue;

        public DetectorThread(@NotNull WindowsThemeDetector themeDetector) {
            Intrinsics.checkNotNullParameter((Object)themeDetector, (String)"themeDetector");
            this.themeDetector = themeDetector;
            this.lastValue = this.themeDetector.isDark();
            this.setName("Windows 10 Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        @Override
        public void run() {
            WinReg.HKEYByReference hkey = new WinReg.HKEYByReference();
            int err = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_CURRENT_USER, WindowsThemeDetector.REGISTRY_PATH, 0, 131097, hkey);
            if (err != 0) {
                throw new Win32Exception(err);
            }
            while (!this.isInterrupted()) {
                err = Advapi32.INSTANCE.RegNotifyChangeKeyValue(hkey.getValue(), false, 4, null, false);
                if (err != 0) {
                    throw new Win32Exception(err);
                }
                boolean currentDetection = this.themeDetector.isDark();
                if (currentDetection == this.lastValue) continue;
                this.lastValue = currentDetection;
                for (Consumer listener : this.themeDetector.listeners) {
                    try {
                        listener.accept(currentDetection);
                    }
                    catch (RuntimeException e) {
                        Companion.getLogger().error((Throwable)e, (Object)"Caught exception during listener notifying ");
                    }
                }
            }
            Advapi32Util.registryCloseKey((WinReg.HKEY)hkey.getValue());
        }
    }
}

