/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema.generation;

import com.jetbrains.fus.reporting.schema.generation.EventDescriptor;
import com.jetbrains.fus.reporting.schema.generation.FieldDescriptor;
import com.jetbrains.fus.reporting.schema.generation.GroupDescriptor;
import com.jetbrains.fus.reporting.schema.generation.ValidationResult;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J&\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J0\u0010 \u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001c2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\u0004H\u0002J&\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J:\u0010(\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010)\u001a\u0004\u0018\u00010\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/fus/reporting/schema/generation/SchemeValidator;", "", "()V", "SYMBOLS_TO_REPLACE_FIELD_NAME", "", "containsChar", "", "str", "c", "", "containsSystemSymbols", "value", "toReplace", "isAscii", "isAsciiControl", "isProhibitedSymbol", "isSymbolToReplace", "isWhiteSpaceToReplace", "unwrapRule", "rule", "validateEventScheme", "Lcom/jetbrains/fus/reporting/schema/generation/ValidationResult;", "eventSchemeGroups", "", "Lcom/jetbrains/fus/reporting/schema/generation/GroupDescriptor;", "validateEvents", "", "schema", "", "Lcom/jetbrains/fus/reporting/schema/generation/EventDescriptor;", "groupId", "errors", "validateFields", "fields", "Lcom/jetbrains/fus/reporting/schema/generation/FieldDescriptor;", "eventId", "validateGroupScheme", "group", "validatedGroupNames", "", "validateRules", "fieldName", "rules", "scheme"})
public final class SchemeValidator {
    @NotNull
    public static final SchemeValidator INSTANCE = new SchemeValidator();
    @NotNull
    private static final String SYMBOLS_TO_REPLACE_FIELD_NAME = ":;, ";

    private SchemeValidator() {
    }

    @NotNull
    public final ValidationResult validateEventScheme(@NotNull List<GroupDescriptor> eventSchemeGroups) {
        Intrinsics.checkNotNullParameter(eventSchemeGroups, (String)"eventSchemeGroups");
        HashSet groupNames = new HashSet();
        ValidationResult errors = new ValidationResult();
        for (GroupDescriptor group : eventSchemeGroups) {
            this.validateGroupScheme(group, groupNames, errors);
        }
        return errors;
    }

    private final void validateGroupScheme(GroupDescriptor group, Set<String> validatedGroupNames, ValidationResult errors) {
        String groupId = group.getId();
        if (StringsKt.isBlank((CharSequence)groupId)) {
            errors.addError(groupId, "Group id is empty");
        }
        if (!validatedGroupNames.add(groupId)) {
            errors.addError(groupId, "Duplicate group");
        }
        if (group.getVersion() <= 0) {
            errors.addError(groupId, "Group version should be not null and > 0");
        }
        this.validateEvents(group.getSchema(), groupId, errors);
    }

    private final void validateEvents(Set<EventDescriptor> schema, String groupId, ValidationResult errors) {
        if (schema.isEmpty()) {
            errors.addError(groupId, "Group should contains at least one event");
        }
        HashSet<String> eventsNames = new HashSet<String>();
        for (EventDescriptor event : schema) {
            String eventId = event.getEvent();
            if (StringsKt.isBlank((CharSequence)eventId)) {
                errors.addError(groupId, "Event id empty");
            } else if (!eventsNames.add(eventId)) {
                errors.addError(groupId, "Duplicate event (eventId=" + eventId + ')');
            }
            if (this.containsSystemSymbols(eventId, null)) {
                errors.addError(groupId, "Only printable ASCII symbols except '\" are allowed in event name (eventId=" + eventId + ')');
            }
            this.validateFields(event.getFields(), errors, groupId, eventId);
        }
    }

    private final void validateFields(Set<FieldDescriptor> fields, ValidationResult errors, String groupId, String eventId) {
        for (FieldDescriptor field : fields) {
            String fieldName = field.getPath();
            if (StringsKt.isBlank((CharSequence)fieldName)) {
                errors.addError(groupId, "Field path is empty (eventId=" + eventId + ')');
            }
            if (this.containsSystemSymbols(fieldName, SYMBOLS_TO_REPLACE_FIELD_NAME)) {
                errors.addError(groupId, "Only printable ASCII symbols except whitespaces and .:;,'\" are allowed in field name (eventId=" + eventId + ", field=" + fieldName + ')');
            }
            this.validateRules(errors, groupId, eventId, fieldName, field.getValue());
        }
    }

    private final void validateRules(ValidationResult errors, String groupId, String eventId, String fieldName, Set<String> rules) {
        if (rules.isEmpty()) {
            errors.addError(groupId, "Validation rules are not specified (eventId=" + eventId + ", field=" + fieldName + ')');
        }
        for (String validationRule : rules) {
            String rule;
            if (StringsKt.isBlank((CharSequence)validationRule)) {
                errors.addError(groupId, "Validation rule is empty (eventId=" + eventId + ", field=" + fieldName + ')');
            }
            if (Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.*}") || Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.+}")) {
                errors.addError(groupId, "Regexp should be more strict to prevent accidentally reporting sensitive data (eventId=" + eventId + ", field=" + fieldName + ')');
            }
            if (!StringsKt.startsWith$default((String)(rule = this.unwrapRule(validationRule)), (String)"enum:", (boolean)false, (int)2, null) || !this.containsSystemSymbols(validationRule, null)) continue;
            errors.addError(groupId, "Only printable ASCII symbols except '\" are allowed in validation rule (eventId=" + eventId + ", field=" + fieldName + ')');
        }
    }

    private final String unwrapRule(String rule) {
        String string;
        String trimmedRule = ((Object)StringsKt.trim((CharSequence)rule)).toString();
        if (StringsKt.startsWith$default((String)trimmedRule, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)trimmedRule, (String)"}", (boolean)false, (int)2, null)) {
            String string2 = trimmedRule.substring(1, trimmedRule.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = rule;
        }
        return string;
    }

    private final boolean containsSystemSymbols(String value, String toReplace) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char element = value.charAt(i);
            if (!this.isAscii(element)) {
                return true;
            }
            if (this.isWhiteSpaceToReplace(element)) {
                return true;
            }
            if (this.isSymbolToReplace(element, toReplace)) {
                return true;
            }
            if (!this.isProhibitedSymbol(element)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private final boolean isSymbolToReplace(char c, String toReplace) {
        return toReplace != null && this.containsChar(toReplace, c) ? true : this.isAsciiControl(c);
    }

    private final boolean isWhiteSpaceToReplace(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    private final boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private final boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private final boolean containsChar(String str, char c) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char element = str.charAt(i);
            if (element != c) continue;
            return true;
        }
        return false;
    }
}

