/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema;

import com.jetbrains.fus.reporting.schema.BaseEventId;
import com.jetbrains.fus.reporting.schema.BaseObjectEventField;
import com.jetbrains.fus.reporting.schema.BaseObjectListEventField;
import com.jetbrains.fus.reporting.schema.EventField;
import com.jetbrains.fus.reporting.schema.EventLogGroup;
import com.jetbrains.fus.reporting.schema.ListEventField;
import com.jetbrains.fus.reporting.schema.PrimitiveEventField;
import com.jetbrains.fus.reporting.schema.StringEventField;
import com.jetbrains.fus.reporting.schema.StringListEventField;
import com.jetbrains.fus.reporting.schema.generation.EventDescriptor;
import com.jetbrains.fus.reporting.schema.generation.EventsScheme;
import com.jetbrains.fus.reporting.schema.generation.FieldDataType;
import com.jetbrains.fus.reporting.schema.generation.FieldDescriptor;
import com.jetbrains.fus.reporting.schema.generation.GroupDescriptor;
import com.jetbrains.fus.reporting.schema.generation.GroupType;
import com.jetbrains.fus.reporting.schema.generation.SchemeValidator;
import com.jetbrains.fus.reporting.schema.generation.ValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ(\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00062\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002\u00a8\u0006 "}, d2={"Lcom/jetbrains/fus/reporting/schema/EventsSchemeBuilder;", "", "()V", "buildEventsScheme", "Lcom/jetbrains/fus/reporting/schema/generation/EventsScheme;", "groups", "", "Lcom/jetbrains/fus/reporting/schema/EventLogGroup;", "buildNumber", "", "buildFields", "Ljava/util/HashSet;", "Lcom/jetbrains/fus/reporting/schema/generation/FieldDescriptor;", "Lkotlin/collections/HashSet;", "event", "Lcom/jetbrains/fus/reporting/schema/BaseEventId;", "groupId", "buildObjectEvenScheme", "", "fieldName", "fields", "Lcom/jetbrains/fus/reporting/schema/EventField;", "eventName", "fieldSchema", "field", "toGroupType", "Lcom/jetbrains/fus/reporting/schema/generation/GroupType;", "type", "Lcom/jetbrains/fus/reporting/schema/EventLogGroup$Type;", "validateRegexp", "", "regexp", "scheme"})
public final class EventsSchemeBuilder {
    @NotNull
    public static final EventsSchemeBuilder INSTANCE = new EventsSchemeBuilder();

    private EventsSchemeBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EventsScheme buildEventsScheme(@NotNull Collection<EventLogGroup> groups, @Nullable String buildNumber) {
        Object eventsDescriptors;
        Iterator<Object> iterator;
        boolean $i$f$mapTo;
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        List result = new ArrayList();
        for (EventLogGroup eventLogGroup : groups) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $this$mapTo$iv22;
            Collection collection;
            void $this$mapTo$iv22;
            Iterable iterable = eventLogGroup.getEvents();
            Collection destination$iv = new HashSet();
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv22) {
                void it;
                BaseEventId entry = (BaseEventId)item$iv;
                collection = destination$iv;
                boolean bl = false;
                collection.add(it.getEventId());
            }
            HashSet distinctEvents = (HashSet)destination$iv;
            boolean bl = $this$mapTo$iv22 = distinctEvents.size() == eventLogGroup.getEvents().size();
            if (_Assertions.ENABLED && !$this$mapTo$iv22) {
                boolean $i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232 = false;
                String $i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232 = "Duplicated events in group " + eventLogGroup.getId();
                throw new AssertionError((Object)$i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232);
            }
            Iterable $i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232 = eventLogGroup.getEvents();
            boolean $i$f$map = false;
            iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void event;
                BaseEventId baseEventId = (BaseEventId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new EventDescriptor(event.getEventId(), INSTANCE.buildFields((BaseEventId)event, eventLogGroup.getId()), event.getDescription(), null, null, 24, null));
            }
            eventsDescriptors = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            GroupDescriptor groupDescriptor = new GroupDescriptor(eventLogGroup.getId(), this.toGroupType(eventLogGroup.getType()), eventLogGroup.getVersion(), (Set)eventsDescriptors, eventLogGroup.getDescription(), null, null, 96, null);
            result.add(groupDescriptor);
        }
        ValidationResult validationResult = SchemeValidator.INSTANCE.validateEventScheme(result);
        if (!validationResult.getErrors().isEmpty()) {
            void $this$mapTo$iv$iv;
            Map<String, Set<String>> map = validationResult.getErrors();
            StringBuilder stringBuilder = new StringBuilder().append("Event scheme is not correct.\n");
            boolean $i$f$map = false;
            eventsDescriptors = map;
            Collection destination$iv$iv = new ArrayList(map.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String group2 = (String)entry.getKey();
                Set errors = (Set)entry.getValue();
                collection.add("groupId=" + group2 + ":\n " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            String string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString();
            throw new IllegalStateException(string);
        }
        return new EventsScheme(buildNumber, result, null, 4, null);
    }

    public static /* synthetic */ EventsScheme buildEventsScheme$default(EventsSchemeBuilder eventsSchemeBuilder, Collection collection, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return eventsSchemeBuilder.buildEventsScheme(collection, string);
    }

    private final GroupType toGroupType(EventLogGroup.Type type) {
        GroupType groupType;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                groupType = GroupType.state;
                break;
            }
            case 2: {
                groupType = GroupType.counter;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return groupType;
    }

    private final Set<FieldDescriptor> fieldSchema(EventField<?> field, String fieldName, String eventName, String groupId) {
        Set set;
        if (StringsKt.contains$default((CharSequence)field.getName(), (CharSequence)".", (boolean)false, (int)2, null)) {
            throw new IllegalStateException("Field name should not contains dots, because dots are used to express hierarchy. Group=" + groupId + ", event=" + eventName + ", field=" + field.getName());
        }
        EventField<?> eventField = field;
        if (eventField instanceof BaseObjectEventField) {
            set = this.buildObjectEvenScheme(fieldName, (Collection)((BaseObjectEventField)field).getObjectFields(), eventName, groupId);
        } else if (eventField instanceof BaseObjectListEventField) {
            set = this.buildObjectEvenScheme(fieldName, (Collection)((BaseObjectListEventField)field).getObjectFields(), eventName, groupId);
        } else if (eventField instanceof ListEventField) {
            if (field instanceof StringListEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringListEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            Object[] objectArray = new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toHashSet((Iterable)((ListEventField)field).getValidationRule()), FieldDataType.ARRAY, field.getShouldBeAnonymized(), field.getDescription())};
            set = SetsKt.hashSetOf((Object[])objectArray);
        } else if (eventField instanceof PrimitiveEventField) {
            if (field instanceof StringEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            Object[] objectArray = new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toHashSet((Iterable)((PrimitiveEventField)field).getValidationRule()), FieldDataType.PRIMITIVE, field.getShouldBeAnonymized(), field.getDescription())};
            set = SetsKt.hashSetOf((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final void validateRegexp(String regexp) {
        if (Intrinsics.areEqual((Object)regexp, (Object)".*")) {
            throw new IllegalStateException("Regexp should be more strict to prevent accidentally reporting sensitive data.");
        }
        Pattern.compile(regexp);
    }

    private final Set<FieldDescriptor> buildObjectEvenScheme(String fieldName, Collection<? extends EventField<?>> fields, String eventName, String groupId) {
        HashSet fieldsDescriptors = new HashSet();
        for (EventField<?> eventField : fields) {
            fieldsDescriptors.addAll(this.fieldSchema(eventField, fieldName + '.' + eventField.getName(), eventName, groupId));
        }
        return fieldsDescriptors;
    }

    /*
     * WARNING - void declaration
     */
    private final HashSet<FieldDescriptor> buildFields(BaseEventId event, String groupId) {
        boolean bl;
        void $this$mapTo$iv;
        void $this$flatMapTo$iv;
        String eventName = event.getEventId();
        Iterable iterable = event.getFields();
        Iterable destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            EventField field = (EventField)element$iv;
            boolean bl2 = false;
            Iterable list$iv = INSTANCE.fieldSchema(field, field.getName(), eventName, groupId);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet fieldDescriptors = (HashSet)destination$iv;
        destination$iv = fieldDescriptors;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FieldDescriptor bl2 = (FieldDescriptor)item$iv;
            Collection collection = destination$iv2;
            boolean bl3 = false;
            collection.add(it.getPath());
        }
        HashSet distinctFields = (HashSet)destination$iv2;
        boolean bl4 = bl = distinctFields.size() == fieldDescriptors.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Duplicated fields in event " + event.getEventId() + ", group " + groupId;
            throw new AssertionError((Object)string);
        }
        return fieldDescriptors;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventLogGroup.Type.values().length];
            nArray[EventLogGroup.Type.STATE.ordinal()] = 1;
            nArray[EventLogGroup.Type.COUNTER.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

