/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.intellij.docker.agent.util.InternalUtilsKt;
import com.intellij.docker.agent.util.Platform;
import com.intellij.docker.agent.util.WslUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/util/WslPath;", "", "distribution", "", "linuxPath", "(Ljava/lang/String;Ljava/lang/String;)V", "getDistribution", "()Ljava/lang/String;", "getLinuxPath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.clouds.docker.agent"})
public final class WslPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String distribution;
    @NotNull
    private final String linuxPath;

    public WslPath(@NotNull String distribution, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        this.distribution = distribution;
        this.linuxPath = linuxPath;
    }

    @NotNull
    public final String getDistribution() {
        return this.distribution;
    }

    @NotNull
    public final String getLinuxPath() {
        return this.linuxPath;
    }

    @NotNull
    public final String component1() {
        return this.distribution;
    }

    @NotNull
    public final String component2() {
        return this.linuxPath;
    }

    @NotNull
    public final WslPath copy(@NotNull String distribution, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        return new WslPath(distribution, linuxPath);
    }

    public static /* synthetic */ WslPath copy$default(WslPath wslPath, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = wslPath.distribution;
        }
        if ((n & 2) != 0) {
            string2 = wslPath.linuxPath;
        }
        return wslPath.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "WslPath(distribution=" + this.distribution + ", linuxPath=" + this.linuxPath + ")";
    }

    public int hashCode() {
        int result2 = this.distribution.hashCode();
        result2 = result2 * 31 + this.linuxPath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WslPath)) {
            return false;
        }
        WslPath wslPath = (WslPath)other;
        if (!Intrinsics.areEqual((Object)this.distribution, (Object)wslPath.distribution)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.linuxPath, (Object)wslPath.linuxPath);
    }

    @JvmStatic
    @Nullable
    public static final WslPath from(@NotNull String windowsUncPath) {
        return Companion.from(windowsUncPath);
    }

    @JvmStatic
    public static final boolean isWsl(@NotNull String windowsUncPath) {
        return Companion.isWsl(windowsUncPath);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/agent/util/WslPath$Companion;", "", "()V", "from", "Lcom/intellij/docker/agent/util/WslPath;", "windowsUncPath", "", "isWsl", "", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final WslPath from(@NotNull String windowsUncPath) {
            int slashIndex;
            Intrinsics.checkNotNullParameter((Object)windowsUncPath, (String)"windowsUncPath");
            if (!Platform.INSTANCE.isWindows()) {
                return null;
            }
            String path = InternalUtilsKt.toSystemDependentName(windowsUncPath);
            if (StringsKt.startsWith$default((String)path, (String)WslUtilsKt.getWSL_PREFIX(), (boolean)false, (int)2, null) && (slashIndex = StringsKt.indexOf$default((CharSequence)path, (char)'\\', (int)WslUtilsKt.getWSL_PREFIX().length(), (boolean)false, (int)4, null)) > WslUtilsKt.getWSL_PREFIX().length()) {
                String string = path.substring(WslUtilsKt.getWSL_PREFIX().length(), slashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string2 = path.substring(slashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                return new WslPath(string, InternalUtilsKt.toSystemIndependentName(string2));
            }
            return null;
        }

        @JvmStatic
        public final boolean isWsl(@NotNull String windowsUncPath) {
            Intrinsics.checkNotNullParameter((Object)windowsUncPath, (String)"windowsUncPath");
            return this.from(windowsUncPath) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

