/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.intellij.docker.agent.util.TarCompressionUtil;
import com.intellij.docker.agent.util.TarEntryWrapper;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u001a+\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\u0016H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\";\u0010\u0003\u001a/\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\")\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"BZIP2", "", "", "COMPRESSION_STRATEGIES", "", "Lkotlin/Function1;", "Ljava/io/InputStream;", "Lkotlin/ParameterName;", "name", "inputStream", "GZIP", "MAX_HEADER_SIZE", "", "UNCOMPRESSED_STRATEGY", "XZ", "tarEntries", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/docker/agent/util/TarEntryWrapper;", "getTarEntries", "(Ljava/io/InputStream;)Lkotlinx/coroutines/flow/Flow;", "decompressStream", "findCompressionStrategy", "Ljava/io/BufferedInputStream;", "intellij.clouds.docker.agent"})
@JvmName(name="TarCompressionUtil")
@SourceDebugExtension(value={"SMAP\nTarCompressionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TarCompressionUtil.kt\ncom/intellij/docker/agent/util/TarCompressionUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n125#2:72\n152#2,3:73\n*S KotlinDebug\n*F\n+ 1 TarCompressionUtil.kt\ncom/intellij/docker/agent/util/TarCompressionUtil\n*L\n26#1:72\n26#1:73,3\n*E\n"})
public final class TarCompressionUtil {
    @NotNull
    private static final List<Byte> BZIP2;
    @NotNull
    private static final List<Byte> GZIP;
    @NotNull
    private static final List<Byte> XZ;
    @NotNull
    private static final Map<List<Byte>, Function1<InputStream, InputStream>> COMPRESSION_STRATEGIES;
    private static final int MAX_HEADER_SIZE;
    @NotNull
    private static final Function1<InputStream, InputStream> UNCOMPRESSED_STRATEGY;

    @NotNull
    public static final InputStream decompressStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InputStream inputStream2 = inputStream;
        int n = 8192;
        return (InputStream)TarCompressionUtil.findCompressionStrategy(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n)).invoke((Object)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Function1<InputStream, InputStream> findCompressionStrategy(BufferedInputStream inputStream) {
        inputStream.mark(MAX_HEADER_SIZE + 1);
        try {
            byte[] buffer = new byte[MAX_HEADER_SIZE];
            int readSize = IOUtils.read((InputStream)inputStream, (byte[])buffer);
            if (readSize <= 0) {
                Function1<InputStream, InputStream> function1 = UNCOMPRESSED_STRATEGY;
                return function1;
            }
            List bufferList = ArraysKt.toList((byte[])buffer).subList(0, readSize);
            for (Map.Entry<List<Byte>, Function1<InputStream, InputStream>> entry : COMPRESSION_STRATEGIES.entrySet()) {
                List<Byte> bytes = entry.getKey();
                Function1<InputStream, InputStream> result2 = entry.getValue();
                if (bytes.size() > bufferList.size() || !Intrinsics.areEqual(bufferList.subList(0, bytes.size()), bytes)) continue;
                Function1<InputStream, InputStream> function1 = result2;
                return function1;
            }
            Iterator<Map.Entry<List<Byte>, Function1<InputStream, InputStream>>> iterator = UNCOMPRESSED_STRATEGY;
            return iterator;
        }
        finally {
            inputStream.reset();
        }
    }

    @NotNull
    public static final Flow<TarEntryWrapper> getTarEntries(@NotNull InputStream $this$tarEntries) {
        Intrinsics.checkNotNullParameter((Object)$this$tarEntries, (String)"<this>");
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super TarEntryWrapper>, Continuation<? super Unit>, Object>($this$tarEntries, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ InputStream $this_tarEntries;
            {
                this.$this_tarEntries = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        var3_4 = this.$this_tarEntries;
                        var4_5 = 8192;
                        stream = new TarArchiveInputStream((InputStream)(var3_4 instanceof BufferedInputStream != false ? (BufferedInputStream)var3_4 : new BufferedInputStream(var3_4, var4_5)));
                        $i$a$-let-TarCompressionUtil$tarEntries$1$1 = false;
                        nextEntry = stream.getNextEntry();
lbl11:
                        // 2 sources

                        while (nextEntry != null) {
                            this.L$0 = $this$flow;
                            this.L$1 = stream;
                            this.label = 1;
                            v0 = $this$flow.emit((Object)new TarEntryWrapper(stream, (TarArchiveEntry)nextEntry), (Continuation)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl26
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-let-TarCompressionUtil$tarEntries$1$1 = false;
                        stream = (TarArchiveInputStream)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        nextEntry = stream.getNextEntry();
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super TarEntryWrapper> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Byte[]{(byte)66, (byte)90, (byte)104};
        BZIP2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Byte[]{(byte)31, (byte)-117, (byte)8};
        GZIP = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Byte[]{(byte)-3, (byte)55, (byte)122, (byte)88, (byte)90, (byte)0};
        XZ = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to(BZIP2, (Object)((Object)COMPRESSION_STRATEGIES.1.INSTANCE)), TuplesKt.to(GZIP, (Object)((Object)COMPRESSION_STRATEGIES.2.INSTANCE)), TuplesKt.to(XZ, (Object)((Object)COMPRESSION_STRATEGIES.3.INSTANCE))};
        COMPRESSION_STRATEGIES = MapsKt.mapOf((Pair[])objectArray);
        Map<List<Byte>, Function1<InputStream, InputStream>> $this$map$iv = COMPRESSION_STRATEGIES;
        boolean $i$f$map = false;
        Map<List<Byte>, Function1<InputStream, InputStream>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((List)it.getKey()).size());
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        MAX_HEADER_SIZE = n != null ? n : 0;
        UNCOMPRESSED_STRATEGY = UNCOMPRESSED_STRATEGY.1.INSTANCE;
    }
}

