/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.intellij.docker.agent.util.PlatformKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/util/Platform;", "", "()V", "OS_NAME", "", "OS_VERSION", "_OS_NAME", "isFreeBSD", "", "()Z", "isLinux", "isMac", "isUnix", "isWindows", "isOsVersionAtLeast", "version", "intellij.clouds.docker.agent"})
public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();
    @NotNull
    private static final String OS_NAME;
    @NotNull
    private static final String OS_VERSION;
    @NotNull
    private static final String _OS_NAME;
    private static final boolean isWindows;
    private static final boolean isMac;
    private static final boolean isLinux;
    private static final boolean isFreeBSD;
    private static final boolean isUnix;

    private Platform() {
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isMac() {
        return isMac;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isFreeBSD() {
        return isFreeBSD;
    }

    public final boolean isUnix() {
        return isUnix;
    }

    public final boolean isOsVersionAtLeast(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return PlatformKt.access$compareVersionNumbers(OS_VERSION, version2) >= 0;
    }

    static {
        String name = null;
        name = System.getProperty("os.name");
        Object version2 = null;
        String string = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        version2 = string2;
        String string3 = name;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element");
        if (StringsKt.startsWith$default((String)string3, (String)"Windows", (boolean)false, (int)2, null)) {
            String string4 = name;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"element");
            Object object = string4;
            if (new Regex("Windows \\d+").matches((CharSequence)object)) {
                object = INSTANCE;
                try {
                    Object $this$_init__u24lambda_u240 = object;
                    boolean bl = false;
                    String string5 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"element");
                    String string6 = string5;
                    int n = 8;
                    String string7 = string6.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                    String version22 = string7 + ".0";
                    if (Float.parseFloat(version22) > Float.parseFloat((String)version2)) {
                        version2 = version22;
                    }
                    Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                name = "Windows";
            }
        }
        String string8 = name;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"element");
        OS_NAME = string8;
        OS_VERSION = version2;
        String string9 = OS_NAME.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        _OS_NAME = string9;
        isWindows = StringsKt.startsWith$default((String)_OS_NAME, (String)"windows", (boolean)false, (int)2, null);
        isMac = StringsKt.startsWith$default((String)_OS_NAME, (String)"mac", (boolean)false, (int)2, null);
        isLinux = StringsKt.startsWith$default((String)_OS_NAME, (String)"linux", (boolean)false, (int)2, null);
        isFreeBSD = StringsKt.startsWith$default((String)_OS_NAME, (String)"freebsd", (boolean)false, (int)2, null);
        isUnix = !isWindows;
    }
}

