/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.intellij.docker.agent.DockerConnectionInfo;
import com.intellij.docker.agent.util.UtilsKt;
import java.io.Closeable;
import java.util.Scanner;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0001\u00a2\u0006\u0002\b\u000fJ\u001a\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011*\u00020\bH\u0002J\u001a\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\b0\u0011*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/util/ExportsListParser;", "", "()V", "EXPORT_ENV_PATTERN", "Lkotlin/text/Regex;", "LOG", "Lorg/slf4j/Logger;", "PROTOCOL_QUALIFIER", "", "UNIX_FILE_SOCKET_PROTOCOL", "parse", "Lcom/intellij/docker/agent/DockerConnectionInfo;", "string", "ignore", "", "parseShellStyleExportsList", "parseExport", "Lkotlin/Pair;", "splitToProtocolAndHost", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nExporsListParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExporsListParser.kt\ncom/intellij/docker/agent/util/ExportsListParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,80:1\n1#2:81\n7#3:82\n*S KotlinDebug\n*F\n+ 1 ExporsListParser.kt\ncom/intellij/docker/agent/util/ExportsListParser\n*L\n13#1:82\n*E\n"})
public final class ExportsListParser {
    @NotNull
    public static final ExportsListParser INSTANCE = new ExportsListParser();
    @NotNull
    private static final String PROTOCOL_QUALIFIER = "://";
    @NotNull
    private static final String UNIX_FILE_SOCKET_PROTOCOL = "unix";
    @NotNull
    private static final Regex EXPORT_ENV_PATTERN = new Regex("^\\s*((export)|(SET))\\s+(?<groupKey>[^=]+)=(?<groupValue>.*)$");
    @NotNull
    private static final Logger LOG;

    private ExportsListParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="parseShellStyleExportsList")
    @NotNull
    public final DockerConnectionInfo parseShellStyleExportsList(@NotNull String string, @NotNull Set<String> ignore) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        Closeable closeable = new Scanner(string);
        Throwable throwable = null;
        try {
            Scanner scanner = (Scanner)closeable;
            boolean bl = false;
            Boolean tls = null;
            String dockerHost = null;
            String dockerCertPath = null;
            block15: while (scanner.hasNextLine()) {
                Pair<String, String> nameValue;
                String string2 = scanner.nextLine();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextLine(...)");
                String line = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (INSTANCE.parseExport(line) == null) continue;
                String name = (String)nameValue.getFirst();
                String value = (String)nameValue.getSecond();
                switch (name) {
                    case "DOCKER_TLS_VERIFY": {
                        tls = Intrinsics.areEqual((Object)"1", (Object)value);
                        continue block15;
                    }
                    case "DOCKER_CERT_PATH": {
                        dockerCertPath = value;
                        continue block15;
                    }
                    case "DOCKER_HOST": {
                        dockerHost = value;
                        continue block15;
                    }
                }
                if (ignore.contains(name)) continue;
                LOG.debug("export for docker CLI returned unknown environment variable: " + name + "=" + value);
            }
            if (dockerHost == null) {
                boolean $i$a$-checkNotNull-ExportsListParser$parse$1$22 = false;
                String $i$a$-checkNotNull-ExportsListParser$parse$1$22 = "DOCKER_HOST is not specified";
                throw new IllegalStateException($i$a$-checkNotNull-ExportsListParser$parse$1$22.toString());
            }
            Pair<String, String> protocolAndHost = INSTANCE.splitToProtocolAndHost(dockerHost);
            String urlProtocol = null;
            String urlHost = (String)protocolAndHost.getSecond();
            if (Intrinsics.areEqual((Object)UNIX_FILE_SOCKET_PROTOCOL, (Object)protocolAndHost.getFirst())) {
                urlProtocol = UNIX_FILE_SOCKET_PROTOCOL;
                dockerCertPath = null;
            } else if (tls != null) {
                urlProtocol = tls != false ? "https" : "http";
            } else {
                String string3;
                if (dockerCertPath == null) {
                    LOG.info("Both DOCKER_TLS_VERIFY and DOCKER_CERT_PATH are not specified, TLS verification disabled");
                    string3 = "http";
                } else {
                    LOG.info("DOCKER_TLS_VERIFY is not specified, TLS verification enabled");
                    string3 = "https";
                }
                urlProtocol = string3;
            }
            String url = urlProtocol + PROTOCOL_QUALIFIER + urlHost;
            DockerConnectionInfo dockerConnectionInfo = new DockerConnectionInfo(url, dockerCertPath);
            return dockerConnectionInfo;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DockerConnectionInfo parseShellStyleExportsList$default(ExportsListParser exportsListParser, String string, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return exportsListParser.parseShellStyleExportsList(string, set);
    }

    private final Pair<String, String> parseExport(String $this$parseExport) {
        MatchResult matchResult = EXPORT_ENV_PATTERN.matchEntire((CharSequence)$this$parseExport);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"groupKey");
        if (matchGroup == null) {
            return null;
        }
        MatchGroup key = matchGroup;
        MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"groupValue");
        if (matchGroup2 == null) {
            return null;
        }
        MatchGroup value = matchGroup2;
        return TuplesKt.to((Object)key.getValue(), (Object)UtilsKt.unquote(value.getValue()));
    }

    private final Pair<String, String> splitToProtocolAndHost(String $this$splitToProtocolAndHost) {
        String protocol = StringsKt.substringBefore((String)$this$splitToProtocolAndHost, (String)PROTOCOL_QUALIFIER, (String)"");
        if (((CharSequence)protocol).length() == 0) {
            LOG.info("DOCKER_HOST is expected to contain protocol prefix but has nothing: " + $this$splitToProtocolAndHost);
            return TuplesKt.to(null, (Object)$this$splitToProtocolAndHost);
        }
        String host = StringsKt.substringAfter((String)$this$splitToProtocolAndHost, (String)PROTOCOL_QUALIFIER, (String)$this$splitToProtocolAndHost);
        return TuplesKt.to((Object)protocol, (Object)host);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = LoggerFactory.getLogger(ExportsListParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        LOG = logger2;
    }
}

