/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.settings;

import com.intellij.docker.agent.settings.DockerPathMapping;
import java.util.Objects;

public class DockerPathMappingImpl
implements DockerPathMapping {
    private String myVirtualMachinePath;
    private String myLocalPath;

    public static DockerPathMappingImpl createMacDefaults() {
        return new DockerPathMappingImpl("/Users", "/Users");
    }

    public static DockerPathMappingImpl createWinDefaults() {
        return new DockerPathMappingImpl("/c/Users", "C:\\Users");
    }

    public DockerPathMappingImpl() {
        this(null, null);
    }

    public DockerPathMappingImpl(DockerPathMapping source) {
        this(source.getVirtualMachinePath(), source.getLocalPath());
    }

    public DockerPathMappingImpl(String name, String path) {
        this.myVirtualMachinePath = name;
        this.myLocalPath = path;
    }

    @Override
    public String getVirtualMachinePath() {
        return this.myVirtualMachinePath;
    }

    public void setVirtualMachinePath(String virtualMachinePath) {
        this.myVirtualMachinePath = virtualMachinePath;
    }

    @Override
    public String getLocalPath() {
        return this.myLocalPath;
    }

    public void setLocalPath(String localPath) {
        this.myLocalPath = localPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerPathMappingImpl mapping = (DockerPathMappingImpl)o;
        if (!Objects.equals(this.myVirtualMachinePath, mapping.myVirtualMachinePath)) {
            return false;
        }
        return Objects.equals(this.myLocalPath, mapping.myLocalPath);
    }

    public int hashCode() {
        int result2 = this.myVirtualMachinePath != null ? this.myVirtualMachinePath.hashCode() : 0;
        result2 = 31 * result2 + (this.myLocalPath != null ? this.myLocalPath.hashCode() : 0);
        return result2;
    }
}

