/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.DockerResponseItemTtyHandler;
import com.intellij.docker.agent.progress.ResponseItemCallbackTemplate;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.util.DockerErrorUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/progress/DockerCallbackWithTtySink;", "RI", "Lcom/github/dockerjava/api/model/ResponseItem;", "Lcom/intellij/docker/agent/progress/ResponseItemCallbackTemplate;", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "ttyHandler", "Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler;", "getTtyHandler", "()Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler;", "doOnError", "", "throwable", "", "ttyReportError", "intellij.clouds.docker.agent"})
public abstract class DockerCallbackWithTtySink<RI extends ResponseItem>
extends ResponseItemCallbackTemplate<RI> {
    @NotNull
    private final TtySink ttySink;
    @NotNull
    private final DockerResponseItemTtyHandler ttyHandler;

    public DockerCallbackWithTtySink(@NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
        this.ttyHandler = new DockerResponseItemTtyHandler(this.ttySink);
    }

    @NotNull
    protected final DockerResponseItemTtyHandler getTtyHandler() {
        return this.ttyHandler;
    }

    @Override
    protected void doOnError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.ttyReportError(throwable);
    }

    private final void ttyReportError(Throwable throwable) {
        String message = DockerErrorUtilKt.dockerUserFriendlyMessage(throwable);
        if (throwable instanceof DockerException) {
            Object[] objectArray = new Object[]{message};
            this.ttySink.coloredTtyPrintln(DockerAgentBundle.Companion.message("DockerCallbackWithTtySink.error.response.from.daemon", objectArray), TtySink.Colors.RED);
        } else {
            Object[] objectArray = new Object[]{message};
            this.ttySink.coloredTtyPrintln(DockerAgentBundle.Companion.message("DockerCallbackWithTtySink.internal.error", objectArray), TtySink.Colors.RED);
        }
    }
}

