/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.impl.OngoingProcessResultCallbackBase;
import com.intellij.docker.agent.impl.ResponseItemAggregator;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PushImageResultCallbackImpl
extends OngoingProcessResultCallbackBase<PushResponseItem> {
    private static final String PUSH_COMPLETE_STATUS = "Pushed";
    private final ResponseItemAggregator myProgressAggregator = new ResponseItemAggregator();
    private final StatusAggregator myStatusAggregator = new StatusAggregator();
    private final String myQualifiedImageReference;

    PushImageResultCallbackImpl(DockerAgentProgressCallback callback2, String qualifiedImageReference) {
        super(callback2);
        this.myQualifiedImageReference = qualifiedImageReference;
    }

    @Override
    protected void onCancel() {
        this.setSuccessMessage("Push cancelled");
    }

    public void onNext(PushResponseItem item) {
        String status2 = item.getStatus();
        String id = item.getId();
        if (item.isErrorIndicated()) {
            this.setErrorMessage(item.getErrorDetail().getMessage());
        } else {
            ResponseItem.AuxDetail aux = item.getAux();
            if (aux != null && aux.getDigest() != null) {
                this.myStatusAggregator.setOverallStatus(MessageFormat.format("{0} pushed successfully", this.myQualifiedImageReference));
            }
        }
        if (status2 == null) {
            return;
        }
        ResponseItemAggregator.ProgressInfo aggregatedProgress = null;
        if (id == null) {
            this.myStatusAggregator.addGeneralStatus(status2);
        } else if (PushImageResultCallbackImpl.hasProgressDetails(item)) {
            aggregatedProgress = this.updateAggregatedProgress(item, status2, id);
        } else {
            this.myStatusAggregator.addLayerStatus(id, status2);
        }
        if (aggregatedProgress != null) {
            this.getAgentCallback().step(status2, aggregatedProgress.getCurrent(), aggregatedProgress.getTotal());
        } else {
            this.getAgentCallback().step(status2, 0L, 0L);
        }
    }

    @Nullable
    private ResponseItemAggregator.ProgressInfo updateAggregatedProgress(@NotNull PushResponseItem item, @NotNull String status2, @NotNull String id) {
        if (item == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(0);
        }
        if (status2 == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(1);
        }
        if (id == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(2);
        }
        if (PUSH_COMPLETE_STATUS.equals(status2)) {
            this.myProgressAggregator.completeProgress(id);
        } else {
            this.myProgressAggregator.updateProgress((ResponseItem)item);
        }
        return this.myProgressAggregator.computeAggregatedProgress();
    }

    private static boolean hasProgressDetails(@NotNull PushResponseItem item) {
        ResponseItem.ProgressDetail detail;
        if (item == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(3);
        }
        return (detail = item.getProgressDetail()) != null && detail.getTotal() != null && detail.getCurrent() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/impl/PushImageResultCallbackImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAggregatedProgress";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProgressDetails";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class StatusAggregator {
        private int ourNextId;
        private static final String AUX_PREFIX = "\u0000_";
        private final LinkedHashMap<String, String> myStatuses = new LinkedHashMap();
        private String myOverallStatus;

        private StatusAggregator() {
        }

        private String nextAuxId() {
            return AUX_PREFIX + this.ourNextId++;
        }

        private static boolean isAuxId(String text) {
            return text != null && text.startsWith(AUX_PREFIX);
        }

        public void setOverallStatus(@NotNull String status2) {
            if (status2 == null) {
                StatusAggregator.$$$reportNull$$$0(0);
            }
            this.myOverallStatus = status2;
            this.updateSuccessMessage();
        }

        public void addLayerStatus(@NotNull String id, @NotNull String status2) {
            if (id == null) {
                StatusAggregator.$$$reportNull$$$0(1);
            }
            if (status2 == null) {
                StatusAggregator.$$$reportNull$$$0(2);
            }
            this.myStatuses.put(id, status2);
            this.updateSuccessMessage();
        }

        public void addGeneralStatus(@NotNull String status2) {
            if (status2 == null) {
                StatusAggregator.$$$reportNull$$$0(3);
            }
            this.myStatuses.put(this.nextAuxId(), status2);
            this.updateSuccessMessage();
        }

        @NotNull
        public List<String> toList() {
            LinkedList<CallSite> result2 = new LinkedList<CallSite>();
            if (this.myOverallStatus != null) {
                result2.add((CallSite)((Object)("<b>" + this.myOverallStatus + "</b><br/>")));
            }
            List list = this.myStatuses.entrySet().stream().map(kv -> StatusAggregator.isAuxId((String)kv.getKey()) ? (String)kv.getValue() : (String)kv.getKey() + ": " + (String)kv.getValue()).collect(Collectors.toCollection(() -> result2));
            if (list == null) {
                StatusAggregator.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public String toAggregatedStatus() {
            String string = String.join((CharSequence)"<br/>", this.toList());
            if (string == null) {
                StatusAggregator.$$$reportNull$$$0(5);
            }
            return string;
        }

        private void updateSuccessMessage() {
            if (!this.isEmpty()) {
                PushImageResultCallbackImpl.this.setSuccessMessage(this.toAggregatedStatus());
            }
        }

        public boolean isEmpty() {
            return this.myStatuses.isEmpty() && this.myOverallStatus == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/impl/PushImageResultCallbackImpl$StatusAggregator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/impl/PushImageResultCallbackImpl$StatusAggregator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toList";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toAggregatedStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setOverallStatus";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addLayerStatus";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addGeneralStatus";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

