/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.HealthState;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.intellij.docker.agent.impl.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import java.util.Optional;

class DockerAgentContainerInspectionImpl
extends DockerAgentContainerConfigImpl
implements DockerAgentContainerInspection {
    private final InspectContainerResponse.ContainerState myContainerState;

    DockerAgentContainerInspectionImpl(CreateContainerCmd cmd, InspectContainerResponse.ContainerState state) {
        super(cmd);
        this.myContainerState = state;
    }

    @Override
    public boolean isRunning() {
        return DockerAgentContainerInspectionImpl.valueOrFalse(this.myContainerState.getRunning());
    }

    @Override
    public String getHealthStatus() {
        return Optional.ofNullable(this.myContainerState.getHealth()).map(HealthState::getStatus).orElse(null);
    }

    private static boolean valueOrFalse(Boolean booleanFromApi) {
        return booleanFromApi != null && booleanFromApi != false;
    }
}

