/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.impl.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.util.DockerUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

final class CreateContainerCmdValueTransfers {
    CreateContainerCmdValueTransfers() {
    }

    public static ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmd, CreateContainerCmd> createMergeForDeploy(DockerAgentPathMapper pathMapper) {
        return CreateContainerCmdValueTransfers.doCreateMerge(false, pathMapper);
    }

    public static ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmd, CreateContainerCmd> createMergeForUpdate(DockerAgentPathMapper pathMapper) {
        return CreateContainerCmdValueTransfers.doCreateMerge(true, pathMapper);
    }

    private static ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmd, CreateContainerCmd> doCreateMerge(boolean replaceNotCombineArrays, DockerAgentPathMapper pathMapper) {
        return new ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmd, CreateContainerCmd>(new FromUiValuesTransfer(replaceNotCombineArrays, pathMapper), CreateContainerCmdValueTransfers.createContainerCmdValueTransfer(pathMapper));
    }

    public static ValueTransfer<CreateContainerCmd, CreateContainerCmd> createContainerCmdValueTransfer(DockerAgentPathMapper pathMapper) {
        return new CreateContainerCmdTransfer(pathMapper);
    }

    static class FromUiValuesTransfer
    extends ValueTransfer.CompositeTransfer<DockerAgentContainerConfigImpl, CreateContainerCmd> {
        FromUiValuesTransfer(boolean replaceNotCombineArrays, DockerAgentPathMapper pathMapper) {
            pathMapper = pathMapper == null ? path -> path : pathMapper;
            VolumeMapper volumeMapper = new VolumeMapper(pathMapper);
            Function<DockerAgentContainerConfigImpl, Bind[]> createCmdVolumeBindings = DockerAgentContainerConfigImpl::createCmdVolumeBindings;
            this.mergeHostConfigArrays(replaceNotCombineArrays, Bind.class, createCmdVolumeBindings.andThen(volumeMapper::expandPath), HostConfig::getBinds, HostConfig::withBinds);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getUser, CreateContainerCmd::withUser);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getCommand, CreateContainerCmd::withCmd);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getEntrypoint, CreateContainerCmd::withEntrypoint);
            this.mergeArrays(replaceNotCombineArrays, String.class, DockerAgentContainerConfigImpl::createCmdEnvVars, CreateContainerCmd::getEnv, CreateContainerCmd::withEnv);
            this.mergeHostConfigArrays(replaceNotCombineArrays, String.class, DockerAgentContainerConfigImpl::getExtraHosts, HostConfig::getExtraHosts, HostConfig::withExtraHosts);
            this.mergeHostConfigArrays(replaceNotCombineArrays, Link.class, DockerAgentContainerConfigImpl::createCmdLinks, HostConfig::getLinks, HostConfig::withLinks);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getNetworkDisabled, CreateContainerCmd::withNetworkDisabled);
            this.mapFromHostConfig(DockerAgentContainerConfigImpl::getNetworkMode, HostConfig::withNetworkMode);
            this.mergeArrays(replaceNotCombineArrays, PortBinding.class, DockerAgentContainerConfigImpl::createCmdPortBindingsArray, FromUiValuesTransfer::getPortBindingsArray, (cmd, array) -> FromUiValuesTransfer.findOrCreateHostConfig(cmd).withPortBindings(array));
            this.mergeArrays(replaceNotCombineArrays, ExposedPort.class, DockerAgentContainerConfigImpl::createCmdExposedPorts, CreateContainerCmd::getExposedPorts, CreateContainerCmd::withExposedPorts);
            this.mapFromHostConfig(DockerAgentContainerConfigImpl::getPublishAllPorts, HostConfig::withPublishAllPorts);
            this.mergeArrays(replaceNotCombineArrays, Volume.class, DockerAgentContainerConfigImpl::createCmdVolumes, CreateContainerCmd::getVolumes, CreateContainerCmd::withVolumes);
            this.mergeHostConfigArrays(replaceNotCombineArrays, VolumesFrom.class, DockerAgentContainerConfigImpl::createCmdVolumesFrom, HostConfig::getVolumesFrom, HostConfig::withVolumesFrom);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getWorkingDir, CreateContainerCmd::withWorkingDir);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getContainerName, CreateContainerCmd::withName);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getStdinOnce, CreateContainerCmd::withStdInOnce);
            this.addValueTransfer(new ValueTransfer<DockerAgentContainerConfigImpl, CreateContainerCmd>(){

                @Override
                public void transferFromTo(DockerAgentContainerConfigImpl source, CreateContainerCmd target) {
                    DockerLabel[] sourceLabels = source.getLabels();
                    if (sourceLabels == null) {
                        return;
                    }
                    HashMap<String, String> targetLabels = target.getLabels();
                    if (targetLabels == null) {
                        targetLabels = new HashMap<String, String>();
                    }
                    for (DockerLabel next : sourceLabels) {
                        if (next.getKey() == null) continue;
                        targetLabels.put(next.getKey(), next.getValue());
                    }
                    target.withLabels(targetLabels);
                }
            });
        }

        private static HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
            if (cmd.getHostConfig() == null) {
                cmd.withHostConfig(new HostConfig());
            }
            return cmd.getHostConfig();
        }

        public <V> void mapFromHostConfig(Function<? super DockerAgentContainerConfigImpl, V> getter, BiConsumer<HostConfig, V> setter) {
            this.mapIfNotNull(getter, (cmd, value) -> setter.accept(FromUiValuesTransfer.findOrCreateHostConfig(cmd), value));
        }

        private <V> void mergeHostConfigArrays(boolean replaceNotCombine, Class<? extends V> valueClass, Function<? super DockerAgentContainerConfigImpl, V[]> sourceGetter, Function<HostConfig, V[]> hostConfigGetter, BiConsumer<HostConfig, V[]> hostConfigSetter) {
            this.mergeArrays(replaceNotCombine, valueClass, sourceGetter, cmd -> Optional.ofNullable(cmd.getHostConfig()).map(hostConfigGetter).orElse(null), (cmd, array) -> hostConfigSetter.accept(FromUiValuesTransfer.findOrCreateHostConfig(cmd), (V[])array));
        }

        private static PortBinding[] getPortBindingsArray(CreateContainerCmd cmd) {
            Ports ports = Optional.ofNullable(cmd.getHostConfig()).map(HostConfig::getPortBindings).orElse(null);
            if (ports == null) {
                return null;
            }
            LinkedList<PortBinding> result2 = new LinkedList<PortBinding>();
            for (Map.Entry entry : ports.getBindings().entrySet()) {
                ExposedPort port = (ExposedPort)entry.getKey();
                Ports.Binding[] bindings = (Ports.Binding[])entry.getValue();
                if (bindings == null) continue;
                for (Ports.Binding next : bindings) {
                    result2.add(new PortBinding(next, port));
                }
            }
            return result2.toArray(new PortBinding[0]);
        }
    }

    static class CreateContainerCmdTransfer
    extends ValueTransfer.CompositeTransfer<CreateContainerCmd, CreateContainerCmd> {
        private final ValueTransfer<HostConfig, HostConfig> myHostConfigTransfer;

        CreateContainerCmdTransfer(DockerAgentPathMapper pathMapper) {
            this.myHostConfigTransfer = new HostConfigValueTransfer(pathMapper);
            this.mapIfNotNull(CreateContainerCmd::getHostName, CreateContainerCmd::withHostName);
            this.mapIfNotNull(CreateContainerCmd::getDomainName, CreateContainerCmd::withDomainName);
            this.mapIfNotNull(CreateContainerCmd::getUser, CreateContainerCmd::withUser);
            this.mapIfNotNull(CreateContainerCmd::isAttachStdin, CreateContainerCmd::withAttachStdin);
            this.mapIfNotNull(CreateContainerCmd::isAttachStdout, CreateContainerCmd::withAttachStdout);
            this.mapIfNotNull(CreateContainerCmd::isAttachStderr, CreateContainerCmd::withAttachStderr);
            this.mapIfNotNull(CreateContainerCmd::getPortSpecs, CreateContainerCmd::withPortSpecs);
            this.mapIfNotNull(CreateContainerCmd::isTty, CreateContainerCmd::withTty);
            this.mapIfNotNull(CreateContainerCmd::isStdinOpen, CreateContainerCmd::withStdinOpen);
            this.mapIfNotNull(CreateContainerCmd::isStdInOnce, CreateContainerCmd::withStdInOnce);
            this.mapIfNotNull(CreateContainerCmd::getEnv, CreateContainerCmd::withEnv);
            this.mapIfNotNull(CreateContainerCmd::getCmd, CreateContainerCmd::withCmd);
            this.mapIfNotNull(CreateContainerCmd::getPlatform, CreateContainerCmd::withPlatform);
            this.mapIfNotNull(CreateContainerCmd::getHealthcheck, CreateContainerCmd::withHealthcheck);
            this.mapIfNotNull(CreateContainerCmd::getArgsEscaped, CreateContainerCmd::withArgsEscaped);
            this.mapIfNotNull(CreateContainerCmd::getEntrypoint, CreateContainerCmd::withEntrypoint);
            this.mapIfNotNull(CreateContainerCmd::getImage, CreateContainerCmd::withImage);
            this.mapIfNotNull(CreateContainerCmd::getVolumes, CreateContainerCmd::withVolumes);
            this.mapIfNotNull(CreateContainerCmd::getWorkingDir, CreateContainerCmd::withWorkingDir);
            this.mapIfNotNull(CreateContainerCmd::getMacAddress, CreateContainerCmd::withMacAddress);
            this.mapIfNotNull(CreateContainerCmd::getOnBuild, CreateContainerCmd::withOnBuild);
            this.mapIfNotNull(CreateContainerCmd::isNetworkDisabled, CreateContainerCmd::withNetworkDisabled);
            this.mapIfNotNull(CreateContainerCmd::getExposedPorts, CreateContainerCmd::withExposedPorts);
            this.mapIfNotNull(CreateContainerCmd::getStopSignal, CreateContainerCmd::withStopSignal);
            this.mapIfNotNull(CreateContainerCmd::getStopTimeout, CreateContainerCmd::withStopTimeout);
            this.mapIfNotNull(CreateContainerCmd::getHostConfig, (cmd, hostConfig) -> {
                if (hostConfig != null) {
                    HostConfig copy = new HostConfig();
                    this.myHostConfigTransfer.transferFromTo((HostConfig)hostConfig, copy);
                    cmd.withHostConfig(copy);
                }
            });
            this.addValueTransfer(new ValueTransfer<CreateContainerCmd, CreateContainerCmd>(){

                @Override
                public void transferFromTo(CreateContainerCmd source, CreateContainerCmd target) {
                    Map sourceLabels = source.getLabels();
                    if (sourceLabels == null) {
                        return;
                    }
                    HashMap targetLabels = target.getLabels();
                    if (targetLabels == null) {
                        targetLabels = new HashMap();
                    }
                    targetLabels.putAll(sourceLabels);
                    target.withLabels(targetLabels);
                }
            });
            this.mapIfNotNull(CreateContainerCmd::getIpv4Address, CreateContainerCmd::withIpv4Address);
            this.mapIfNotNull(CreateContainerCmd::getIpv6Address, CreateContainerCmd::withIpv6Address);
            this.mapIfNotNull(CreateContainerCmd::getAliases, CreateContainerCmd::withAliases);
        }
    }

    private static class MountMapper {
        private final DockerAgentPathMapper pathMapper;

        private MountMapper(DockerAgentPathMapper pathMapper) {
            this.pathMapper = pathMapper;
        }

        private Mount expandPath(Mount mount) {
            String source = mount.getSource();
            if (source != null) {
                mount.withSource(this.pathMapper.mapPath(source));
            }
            return mount;
        }

        public List<Mount> expandPath(List<Mount> mounts) {
            if (mounts == null) {
                return null;
            }
            return mounts.stream().map(this::expandPath).collect(Collectors.toList());
        }
    }

    private static class VolumeMapper {
        private final DockerAgentPathMapper pathMapper;

        private VolumeMapper(DockerAgentPathMapper pathMapper) {
            this.pathMapper = pathMapper;
        }

        private Bind expandPath(Bind bind) {
            return new Bind(this.pathMapper.mapPath(bind.getPath()), bind.getVolume(), bind.getAccessMode(), bind.getSecMode());
        }

        public Bind[] expandPath(Bind[] binds) {
            if (binds == null) {
                return null;
            }
            return DockerUtil.mapArray(binds, Bind.class, this::expandPath);
        }
    }

    static class HostConfigValueTransfer
    extends ValueTransfer.CompositeTransfer<HostConfig, HostConfig> {
        HostConfigValueTransfer(DockerAgentPathMapper pathMapper) {
            pathMapper = pathMapper == null ? path -> path : pathMapper;
            VolumeMapper volumesMapper = new VolumeMapper(pathMapper);
            Function<HostConfig, Bind[]> getBinds = HostConfig::getBinds;
            this.mapIfNotNull(getBinds.andThen(volumesMapper::expandPath), HostConfig::setBinds);
            MountMapper mountsMapper = new MountMapper(pathMapper);
            Function<HostConfig, List> getMounts = HostConfig::getMounts;
            this.mapIfNotNull(getMounts.andThen(mountsMapper::expandPath), HostConfig::withMounts);
            this.mapIfNotNull(HostConfig::getBlkioWeight, HostConfig::withBlkioWeight);
            this.mapIfNotNull(HostConfig::getBlkioWeightDevice, HostConfig::withBlkioWeightDevice);
            this.mapIfNotNull(HostConfig::getBlkioDeviceReadBps, HostConfig::withBlkioDeviceReadBps);
            this.mapIfNotNull(HostConfig::getBlkioDeviceWriteBps, HostConfig::withBlkioDeviceWriteBps);
            this.mapIfNotNull(HostConfig::getBlkioDeviceReadIOps, HostConfig::withBlkioDeviceReadIOps);
            this.mapIfNotNull(HostConfig::getBlkioDeviceWriteIOps, HostConfig::withBlkioDeviceWriteIOps);
            this.mapIfNotNull(HostConfig::getMemorySwappiness, HostConfig::withMemorySwappiness);
            this.mapIfNotNull(HostConfig::getNanoCPUs, HostConfig::withNanoCPUs);
            this.mapIfNotNull(HostConfig::getCapAdd, HostConfig::withCapAdd);
            this.mapIfNotNull(HostConfig::getCapDrop, HostConfig::withCapDrop);
            this.mapIfNotNull(HostConfig::getContainerIDFile, HostConfig::withContainerIDFile);
            this.mapIfNotNull(HostConfig::getCpuPeriod, HostConfig::withCpuPeriod);
            this.mapIfNotNull(HostConfig::getCpuRealtimePeriod, HostConfig::withCpuRealtimePeriod);
            this.mapIfNotNull(HostConfig::getCpuRealtimeRuntime, HostConfig::withCpuRealtimeRuntime);
            this.mapIfNotNull(HostConfig::getCpuShares, HostConfig::withCpuShares);
            this.mapIfNotNull(HostConfig::getCpuQuota, HostConfig::withCpuQuota);
            this.mapIfNotNull(HostConfig::getCpusetCpus, HostConfig::withCpusetCpus);
            this.mapIfNotNull(HostConfig::getCpusetMems, HostConfig::withCpusetMems);
            this.mapIfNotNull(HostConfig::getDevices, HostConfig::withDevices);
            this.mapIfNotNull(HostConfig::getDeviceCgroupRules, HostConfig::withDeviceCgroupRules);
            this.mapIfNotNull(HostConfig::getDeviceRequests, HostConfig::withDeviceRequests);
            this.mapIfNotNull(HostConfig::getDiskQuota, HostConfig::withDiskQuota);
            this.mapIfNotNull(HostConfig::getDns, HostConfig::withDns);
            this.mapIfNotNull(HostConfig::getDnsOptions, HostConfig::withDnsOptions);
            this.mapIfNotNull(HostConfig::getDnsSearch, HostConfig::withDnsSearch);
            this.mapIfNotNull(HostConfig::getExtraHosts, HostConfig::withExtraHosts);
            this.mapIfNotNull(HostConfig::getGroupAdd, HostConfig::withGroupAdd);
            this.mapIfNotNull(HostConfig::getIpcMode, HostConfig::withIpcMode);
            this.mapIfNotNull(HostConfig::getCgroup, HostConfig::withCgroup);
            this.mapIfNotNull(HostConfig::getLinks, HostConfig::setLinks);
            this.mapIfNotNull(HostConfig::getLogConfig, HostConfig::withLogConfig);
            this.mapIfNotNull(HostConfig::getLxcConf, HostConfig::withLxcConf);
            this.mapIfNotNull(HostConfig::getMemory, HostConfig::withMemory);
            this.mapIfNotNull(HostConfig::getMemorySwap, HostConfig::withMemorySwap);
            this.mapIfNotNull(HostConfig::getMemoryReservation, HostConfig::withMemoryReservation);
            this.mapIfNotNull(HostConfig::getKernelMemory, HostConfig::withKernelMemory);
            this.mapIfNotNull(HostConfig::getNetworkMode, HostConfig::withNetworkMode);
            this.mapIfNotNull(HostConfig::getOomKillDisable, HostConfig::withOomKillDisable);
            this.mapIfNotNull(HostConfig::getInit, HostConfig::withInit);
            this.mapIfNotNull(HostConfig::getAutoRemove, HostConfig::withAutoRemove);
            this.mapIfNotNull(HostConfig::getOomScoreAdj, HostConfig::withOomScoreAdj);
            this.mapIfNotNull(HostConfig::getPortBindings, HostConfig::withPortBindings);
            this.mapIfNotNull(HostConfig::getPrivileged, HostConfig::withPrivileged);
            this.mapIfNotNull(HostConfig::getPublishAllPorts, HostConfig::withPublishAllPorts);
            this.mapIfNotNull(HostConfig::getReadonlyRootfs, HostConfig::withReadonlyRootfs);
            this.mapIfNotNull(HostConfig::getRestartPolicy, HostConfig::withRestartPolicy);
            this.mapIfNotNull(HostConfig::getUlimits, HostConfig::withUlimits);
            this.mapIfNotNull(HostConfig::getCpuCount, HostConfig::withCpuCount);
            this.mapIfNotNull(HostConfig::getCpuPercent, HostConfig::withCpuPercent);
            this.mapIfNotNull(HostConfig::getIoMaximumIOps, HostConfig::withIoMaximumIOps);
            this.mapIfNotNull(HostConfig::getIoMaximumBandwidth, HostConfig::withIoMaximumBandwidth);
            this.mapIfNotNull(HostConfig::getVolumesFrom, HostConfig::withVolumesFrom);
            this.mapIfNotNull(HostConfig::getPidMode, HostConfig::withPidMode);
            this.mapIfNotNull(HostConfig::getIsolation, HostConfig::withIsolation);
            this.mapIfNotNull(HostConfig::getSecurityOpts, HostConfig::withSecurityOpts);
            this.mapIfNotNull(HostConfig::getStorageOpt, HostConfig::withStorageOpt);
            this.mapIfNotNull(HostConfig::getCgroupParent, HostConfig::withCgroupParent);
            this.mapIfNotNull(HostConfig::getVolumeDriver, HostConfig::withVolumeDriver);
            this.mapIfNotNull(HostConfig::getShmSize, HostConfig::withShmSize);
            this.mapIfNotNull(HostConfig::getPidsLimit, HostConfig::withPidsLimit);
            this.mapIfNotNull(HostConfig::getRuntime, HostConfig::withRuntime);
            this.mapIfNotNull(HostConfig::getTmpFs, HostConfig::withTmpFs);
            this.mapIfNotNull(HostConfig::getUtSMode, HostConfig::withUtSMode);
            this.mapIfNotNull(HostConfig::getUsernsMode, HostConfig::withUsernsMode);
            this.mapIfNotNull(HostConfig::getSysctls, HostConfig::withSysctls);
            this.mapIfNotNull(HostConfig::getConsoleSize, HostConfig::withConsoleSize);
        }
    }
}

