/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.intellij.docker.agent.devcontainers.feautures.DevcontainerDataExchangeProxy;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeature;
import com.intellij.docker.agent.devcontainers.feautures.DirectTarballFeatureDownloader;
import com.intellij.docker.agent.devcontainers.feautures.LocalFeatureDownloader;
import com.intellij.docker.agent.devcontainers.feautures.OCIFeatureDownloader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureDownloader;", "", "feature", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "workingDir", "Ljava/nio/file/Path;", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "(Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;Ljava/nio/file/Path;Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;)V", "getFeature", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "getProxy", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "getWorkingDir", "()Ljava/nio/file/Path;", "downloadAndExtract", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.clouds.docker.agent"})
public abstract class DevcontainerFeatureDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevcontainerFeature feature;
    @NotNull
    private final Path workingDir;
    @NotNull
    private final DevcontainerDataExchangeProxy proxy;

    public DevcontainerFeatureDownloader(@NotNull DevcontainerFeature feature, @NotNull Path workingDir, @NotNull DevcontainerDataExchangeProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.feature = feature;
        this.workingDir = workingDir;
        this.proxy = proxy;
    }

    @NotNull
    protected final DevcontainerFeature getFeature() {
        return this.feature;
    }

    @NotNull
    protected final Path getWorkingDir() {
        return this.workingDir;
    }

    @NotNull
    protected final DevcontainerDataExchangeProxy getProxy() {
        return this.proxy;
    }

    @Nullable
    public abstract Object downloadAndExtract(@NotNull Continuation<? super Path> var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureDownloader$Companion;", "", "()V", "create", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureDownloader;", "workingDir", "Ljava/nio/file/Path;", "feature", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DevcontainerFeatureDownloader create(@NotNull Path workingDir, @NotNull DevcontainerFeature feature, @NotNull DevcontainerDataExchangeProxy proxy) {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            return switch (WhenMappings.$EnumSwitchMapping$0[feature.getRef().getSource().ordinal()]) {
                case 1 -> new OCIFeatureDownloader(feature, workingDir, proxy);
                case 2 -> new LocalFeatureDownloader(feature, workingDir, proxy);
                case 3 -> new DirectTarballFeatureDownloader(feature, workingDir, proxy);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DevcontainerFeature.FeatureSource.values().length];
                try {
                    nArray[DevcontainerFeature.FeatureSource.OCIRegistry.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DevcontainerFeature.FeatureSource.Local.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DevcontainerFeature.FeatureSource.DirectTarball.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

