/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.compose.beans.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.docker.agent.compose.beans.AccessMode;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeVolumesFromV1;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DockerComposeVolumesFromV2
extends DockerComposeVolumesFromV1 {
    private static final String CONTAINER_PREFIX = "container:";
    private Type myType;

    public DockerComposeVolumesFromV2(Type type, String name, AccessMode accessMode) {
        super(name, accessMode);
        this.myType = type;
    }

    @JsonCreator
    public static DockerComposeVolumesFromV2 parseV2(@NotNull String value) {
        String nameWithAccessMode;
        Type type;
        if (value == null) {
            DockerComposeVolumesFromV2.$$$reportNull$$$0(0);
        }
        if (value.startsWith(CONTAINER_PREFIX)) {
            type = Type.CONTAINER;
            nameWithAccessMode = value.substring(CONTAINER_PREFIX.length());
        } else {
            type = Type.SERVICE;
            nameWithAccessMode = value;
        }
        DockerComposeVolumesFromV1 volumesFromV1 = DockerComposeVolumesFromV1.parseV1(nameWithAccessMode);
        return new DockerComposeVolumesFromV2(type, volumesFromV1.getName(), volumesFromV1.getAccessMode());
    }

    public Type getType() {
        return this.myType;
    }

    public void setType(Type type) {
        this.myType = type;
    }

    @Override
    @JsonValue
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.myType == Type.CONTAINER) {
            sb.append(CONTAINER_PREFIX);
        }
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerComposeVolumesFromV2 v2 = (DockerComposeVolumesFromV2)o;
        return this.myType == v2.myType;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.myType != null ? this.myType.hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/docker/agent/compose/beans/v2/DockerComposeVolumesFromV2", "parseV2"));
    }

    public static enum Type {
        SERVICE,
        CONTAINER;

    }
}

