/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.compose.beans.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DockerComposeBuildV2 {
    private String myContext;
    private String myDockerfile;
    private String myTarget;
    private Map<String, String> myArguments;

    public DockerComposeBuildV2() {
    }

    @JsonCreator
    public DockerComposeBuildV2(String context) {
        this.myContext = context;
    }

    @JsonCreator
    public DockerComposeBuildV2(@JsonProperty(value="context") String context, @JsonProperty(value="dockerfile") String dockerfile) {
        this.myContext = context;
        this.myDockerfile = dockerfile;
    }

    @JsonProperty
    public String getContext() {
        return this.myContext;
    }

    @JsonProperty
    public void setContext(String context) {
        this.myContext = context;
    }

    @JsonProperty
    public String getDockerfile() {
        return this.myDockerfile;
    }

    @JsonProperty
    public void setDockerfile(String dockerfile) {
        this.myDockerfile = dockerfile;
    }

    @JsonProperty
    public String getTarget() {
        return this.myTarget;
    }

    @JsonProperty
    public void setTarget(String target) {
        this.myTarget = target;
    }

    @JsonDeserialize(using=ArgsDeserializer.class)
    @JsonProperty(value="args")
    public Map<String, String> getArguments() {
        return this.myArguments;
    }

    @JsonProperty(value="args")
    public void setArguments(Map<String, String> arguments) {
        this.myArguments = arguments;
    }

    public String toString() {
        return "DockerComposeBuildV2{myContext='" + this.myContext + "', myDockerfile='" + this.myDockerfile + "', myTarget='" + this.myTarget + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeBuildV2 v2 = (DockerComposeBuildV2)o;
        if (!Objects.equals(this.myContext, v2.myContext)) {
            return false;
        }
        if (!Objects.equals(this.myDockerfile, v2.myDockerfile)) {
            return false;
        }
        if (!Objects.equals(this.myTarget, v2.myTarget)) {
            return false;
        }
        return Objects.equals(this.myArguments, v2.myArguments);
    }

    public int hashCode() {
        int result2 = this.myContext != null ? this.myContext.hashCode() : 0;
        result2 = 31 * result2 + (this.myDockerfile != null ? this.myDockerfile.hashCode() : 0);
        result2 = 31 * result2 + (this.myTarget != null ? this.myTarget.hashCode() : 0);
        result2 = 31 * result2 + (this.myArguments != null ? this.myArguments.hashCode() : 0);
        return result2;
    }

    private static class ArgsDeserializer
    extends JsonDeserializer<Map<String, String>> {
        private ArgsDeserializer() {
        }

        public Map<String, String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return (Map)p.readValueAs((TypeReference)new TypeReference<LinkedHashMap<String, String>>(){});
            }
            catch (IOException e) {
                List list = (List)p.readValueAs((TypeReference)new TypeReference<ArrayList<String>>(){});
                return list.stream().collect(Collectors.toMap(s -> StringsKt.substringBefore((String)s, (String)"=", (String)s), s -> StringsKt.substringAfter((String)s, (String)"=", (String)s)));
            }
        }
    }
}

