/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.intellij.docker.agent.cli.model.DockerBuildCliBuilder;
import com.intellij.docker.agent.cli.model.DockerBuildCliParserBase;
import com.intellij.docker.agent.cli.model.NormalizedCommandLine;
import com.intellij.docker.agent.util.InternalUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\"\u0010\u0013\u001a\u00020\u00002\u001a\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00160\u0015J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005J\u0019\u0010\u0019\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b\u00a2\u0006\u0002\u0010\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0014J\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0010\u0010!\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\bJ\u0010\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\u0005J\u0012\u0010%\u001a\u00020&*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0004J(\u0010'\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00050\u00042\u0014\b\u0002\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050)H\u0004J\u0012\u0010*\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerBuildCliBuilder;", "", "()V", "myBuildArgValues", "", "", "myContextDirectory", "myCustomBuildOptions", "Lcom/intellij/docker/agent/cli/model/NormalizedCommandLine;", "getMyCustomBuildOptions", "()Lcom/intellij/docker/agent/cli/model/NormalizedCommandLine;", "setMyCustomBuildOptions", "(Lcom/intellij/docker/agent/cli/model/NormalizedCommandLine;)V", "myDockerFile", "myImageTags", "addBuildArg", "", "name", "value", "addBuildArgs", "pairs", "", "Lkotlin/Pair;", "addImageTag", "imageTag", "addImageTags", "list", "", "([Ljava/lang/String;)Lcom/intellij/docker/agent/cli/model/DockerBuildCliBuilder;", "build", "doBuild", "setContextDirectory", "contextDirectory", "setCustomBuildOptions", "runOptions", "setDockerFile", "path", "addContextDirectory", "", "addDockerFile", "map", "Lkotlin/Function1;", "addTags", "Companion", "ForPreview", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerBuildCliBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerBuildCliBuilder.kt\ncom/intellij/docker/agent/cli/model/DockerBuildCliBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n13309#3,2:135\n1855#4,2:137\n1855#4,2:139\n1549#4:141\n1620#4,3:142\n*S KotlinDebug\n*F\n+ 1 DockerBuildCliBuilder.kt\ncom/intellij/docker/agent/cli/model/DockerBuildCliBuilder\n*L\n28#1:135,2\n38#1:137,2\n59#1:139,2\n79#1:141\n79#1:142,3\n*E\n"})
public class DockerBuildCliBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String myDockerFile;
    @NotNull
    private final List<String> myImageTags = new ArrayList();
    @Nullable
    private NormalizedCommandLine myCustomBuildOptions;
    @NotNull
    private final List<String> myBuildArgValues = new ArrayList();
    @Nullable
    private String myContextDirectory;
    @NotNull
    public static final String CANONICAL_FILE_NAME = "Dockerfile";
    @NotNull
    public static final String UNKNOWN_IMAGE_TAG = "<image_tag>";

    @Nullable
    protected final NormalizedCommandLine getMyCustomBuildOptions() {
        return this.myCustomBuildOptions;
    }

    protected final void setMyCustomBuildOptions(@Nullable NormalizedCommandLine normalizedCommandLine) {
        this.myCustomBuildOptions = normalizedCommandLine;
    }

    @NotNull
    public final DockerBuildCliBuilder setDockerFile(@Nullable String path) {
        DockerBuildCliBuilder dockerBuildCliBuilder;
        DockerBuildCliBuilder $this$setDockerFile_u24lambda_u240 = dockerBuildCliBuilder = this;
        boolean bl = false;
        $this$setDockerFile_u24lambda_u240.myDockerFile = path;
        return dockerBuildCliBuilder;
    }

    @NotNull
    public final DockerBuildCliBuilder setContextDirectory(@Nullable String contextDirectory) {
        DockerBuildCliBuilder dockerBuildCliBuilder;
        DockerBuildCliBuilder $this$setContextDirectory_u24lambda_u241 = dockerBuildCliBuilder = this;
        boolean bl = false;
        $this$setContextDirectory_u24lambda_u241.myContextDirectory = contextDirectory;
        return dockerBuildCliBuilder;
    }

    public final void addImageTag(@NotNull String imageTag) {
        Intrinsics.checkNotNullParameter((Object)imageTag, (String)"imageTag");
        if (!StringsKt.isBlank((CharSequence)imageTag)) {
            this.myImageTags.add(imageTag);
        }
    }

    @NotNull
    public final DockerBuildCliBuilder addImageTags(@NotNull String[] list) {
        DockerBuildCliBuilder dockerBuildCliBuilder;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        DockerBuildCliBuilder $this$addImageTags_u24lambda_u243 = dockerBuildCliBuilder = this;
        boolean bl = false;
        String[] $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl2 = false;
            $this$addImageTags_u24lambda_u243.addImageTag(it);
        }
        return dockerBuildCliBuilder;
    }

    public final void addBuildArg(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StringsKt.isBlank((CharSequence)name)) {
            return;
        }
        CharSequence charSequence = value;
        this.myBuildArgValues.add(name + (String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : "=" + value));
    }

    @NotNull
    public final DockerBuildCliBuilder addBuildArgs(@NotNull List<Pair<String, String>> pairs) {
        DockerBuildCliBuilder dockerBuildCliBuilder;
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        DockerBuildCliBuilder $this$addBuildArgs_u24lambda_u245 = dockerBuildCliBuilder = this;
        boolean bl = false;
        Iterable $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl2 = false;
            $this$addBuildArgs_u24lambda_u245.addBuildArg((String)it.getFirst(), (String)it.getSecond());
        }
        return dockerBuildCliBuilder;
    }

    @NotNull
    public final DockerBuildCliBuilder setCustomBuildOptions(@Nullable NormalizedCommandLine runOptions) {
        DockerBuildCliBuilder dockerBuildCliBuilder;
        DockerBuildCliBuilder $this$setCustomBuildOptions_u24lambda_u246 = dockerBuildCliBuilder = this;
        boolean bl = false;
        $this$setCustomBuildOptions_u24lambda_u246.myCustomBuildOptions = runOptions;
        return dockerBuildCliBuilder;
    }

    @NotNull
    public final List<String> build() {
        if (!((Collection)this.myBuildArgValues).isEmpty()) {
            Option buildArgsOption = DockerBuildCliParserBase.buildArgsOption();
            if (this.myCustomBuildOptions == null) {
                this.myCustomBuildOptions = new NormalizedCommandLine();
            }
            for (String nextValue : this.myBuildArgValues) {
                NormalizedCommandLine normalizedCommandLine = this.myCustomBuildOptions;
                Intrinsics.checkNotNull((Object)normalizedCommandLine);
                normalizedCommandLine.registerOneValue(buildArgsOption, nextValue);
            }
        }
        return this.doBuild();
    }

    protected final void addTags(@NotNull List<String> $this$addTags) {
        Intrinsics.checkNotNullParameter($this$addTags, (String)"<this>");
        Iterable $this$forEach$iv = this.myImageTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            $this$addTags.add("-t");
            $this$addTags.add(it);
        }
    }

    protected final boolean addContextDirectory(@NotNull List<String> $this$addContextDirectory) {
        Intrinsics.checkNotNullParameter($this$addContextDirectory, (String)"<this>");
        String string = this.myContextDirectory;
        if (string == null) {
            string = ".";
        }
        return $this$addContextDirectory.add(string);
    }

    protected final void addDockerFile(@NotNull List<String> $this$addDockerFile, @NotNull Function1<? super String, String> map) {
        block1: {
            Intrinsics.checkNotNullParameter($this$addDockerFile, (String)"<this>");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            String string = this.myDockerFile;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)CANONICAL_FILE_NAME)) {
                $this$addDockerFile.add("-f");
                $this$addDockerFile.add((String)map.invoke((Object)it));
            }
        }
    }

    public static /* synthetic */ void addDockerFile$default(DockerBuildCliBuilder dockerBuildCliBuilder, List list, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addDockerFile");
        }
        if ((n & 1) != 0) {
            function1 = addDockerFile.1.INSTANCE;
        }
        dockerBuildCliBuilder.addDockerFile(list, (Function1<? super String, String>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<String> doBuild() {
        List result2 = new ArrayList();
        NormalizedCommandLine normalizedCommandLine = this.myCustomBuildOptions;
        if (normalizedCommandLine != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            NormalizedCommandLine options2 = normalizedCommandLine;
            boolean bl = false;
            List<String> list = options2.groupByOptions();
            Intrinsics.checkNotNullExpressionValue(list, (String)"groupByOptions(...)");
            Iterable iterable = list;
            List list2 = result2;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                CharSequence charSequence = (CharSequence)it;
                Regex regex = new Regex(" (?=(([^'\"]*['\"]){2})*[^'\"]*$)");
                int n = 0;
                collection.add(regex.split(charSequence, n));
            }
            list2.addAll(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        }
        DockerBuildCliBuilder.addDockerFile$default(this, result2, null, 1, null);
        this.addTags(result2);
        this.addContextDirectory(result2);
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerBuildCliBuilder$Companion;", "", "()V", "CANONICAL_FILE_NAME", "", "UNKNOWN_IMAGE_TAG", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerBuildCliBuilder$ForPreview;", "Lcom/intellij/docker/agent/cli/model/DockerBuildCliBuilder;", "()V", "myEnableBuildKit", "", "doBuild", "", "", "setEnableBuildKit", "", "enableBuildKit", "shortenDockerFilePath", "filePath", "intellij.clouds.docker.agent"})
    public static final class ForPreview
    extends DockerBuildCliBuilder {
        private boolean myEnableBuildKit;

        public final void setEnableBuildKit(boolean enableBuildKit) {
            this.myEnableBuildKit = enableBuildKit;
        }

        @Override
        @NotNull
        protected List<String> doBuild() {
            String start2 = "docker build";
            List result2 = new ArrayList();
            List lastLine = new ArrayList();
            if (this.myEnableBuildKit) {
                result2.add("DOCKER_BUILDKIT=1");
            }
            if (this.getMyCustomBuildOptions() != null) {
                result2.add(start2);
                NormalizedCommandLine normalizedCommandLine = this.getMyCustomBuildOptions();
                Intrinsics.checkNotNull((Object)normalizedCommandLine);
                List<String> list = normalizedCommandLine.groupByOptions();
                Intrinsics.checkNotNullExpressionValue(list, (String)"groupByOptions(...)");
                result2.addAll((Collection)list);
            } else {
                lastLine.add(start2);
            }
            this.addDockerFile(lastLine, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this){

                @NotNull
                public final String invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ForPreview.access$shortenDockerFilePath((ForPreview)this.receiver, p0);
                }
            }));
            this.addTags(lastLine);
            this.addContextDirectory(lastLine);
            result2.add(CollectionsKt.joinToString$default((Iterable)lastLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            return result2;
        }

        private final String shortenDockerFilePath(String filePath) {
            String string;
            String path = InternalUtilsKt.toSystemIndependentName(filePath);
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null);
            if (lastSlash >= 0) {
                String string2 = path.substring(lastSlash + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = path;
            }
            return string;
        }

        public static final /* synthetic */ String access$shortenDockerFilePath(ForPreview $this, String filePath) {
            return $this.shortenDockerFilePath(filePath);
        }
    }
}

